/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.translator;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.NodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItem;
import com.aliyun.dataworks.migrationx.transformer.core.report.Reportable;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.AntCommandLine;
import com.aliyun.dataworks.migrationx.transformer.core.translator.NodePropertyTranslator;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommandSqlTranslator
implements Reportable,
NodePropertyTranslator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCommandSqlTranslator.class);
    protected List<ReportItem> reportItems = new ArrayList<ReportItem>();

    @Override
    public boolean match(DwWorkflow workflow, DwNode node) {
        if (StringUtils.isBlank((String)node.getCode())) {
            return false;
        }
        LOGGER.debug("pattern: {}, find: {}, code: {}", new Object[]{this.getCommandPrefixPattern(), this.getCommandPrefixPattern().matcher(node.getCode()).find(), node.getCode()});
        return this.getCommandPrefixPattern() != null && this.getCommandPrefixPattern().matcher(node.getCode()).find();
    }

    @Override
    public List<ReportItem> getReport() {
        return this.reportItems;
    }

    protected abstract Pattern getCommandPrefixPattern();

    @Override
    public boolean translate(DwWorkflow workflow, DwNode node) throws ParseException {
        if (!this.matchPattern(node)) {
            return false;
        }
        String sql = StringEscapeUtils.unescapeJava((String)this.parseGnuCommandLine(node.getCode(), this.getSqlOption()));
        node.setCode(sql);
        if (NodeUtils.isEmrNode((String)node.getType())) {
            node.setCode(EmrCodeUtils.toEmrCode((Node)node));
        }
        return true;
    }

    private boolean matchPattern(DwNode node) {
        if (StringUtils.isBlank((String)node.getCode())) {
            return false;
        }
        Pattern pattern = this.getCommandPrefixPattern();
        Matcher matcher = pattern.matcher(node.getCode());
        if (!matcher.find()) {
            LOGGER.info("code pattern not match with: {}", (Object)pattern);
            return false;
        }
        return true;
    }

    protected abstract String getSqlOption();

    protected abstract Options getGnuOptions();

    protected String parseGnuCommandLine(String code, String sqlOption) throws ParseException {
        Options options = this.getGnuOptions();
        MyParser parser = new MyParser();
        AntCommandLine antCommandLine = new AntCommandLine(code);
        CommandLine cli = parser.parse(options, antCommandLine.getCommandline());
        return cli.getOptionValue(sqlOption, code);
    }

    public static class MyParser
    extends GnuParser {
        protected void processOption(String arg, ListIterator<String> iter) throws ParseException {
            try {
                super.processOption(arg, iter);
            }
            catch (Exception e) {
                LOGGER.warn("{}", (Object)e.getMessage());
            }
        }
    }
}

