/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.sqoop;

import com.aliyun.dataworks.migrationx.transformer.core.sqoop.ConfigurationHelper;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.SqoopOptions;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.SqoopParser;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.ToolOptions;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SqoopTool {
    public static final Logger LOG = LoggerFactory.getLogger((String)SqoopTool.class.getName());
    public static final String TOOL_PLUGINS_KEY = "sqoop.tool.plugins";
    private static final Map<String, Class<? extends SqoopTool>> TOOLS = new TreeMap<String, Class<? extends SqoopTool>>();
    private static final Map<String, String> DESCRIPTIONS = new TreeMap<String, String>();
    private String toolName;
    protected String[] extraArguments;

    private static Configuration loadPluginsFromConfDir(Configuration conf) {
        if (conf.get(TOOL_PLUGINS_KEY) != null) {
            LOG.debug("sqoop.tool.plugins is set; ignoring tools.d");
            return conf;
        }
        String confDirName = System.getenv("SQOOP_CONF_DIR");
        if (null == confDirName) {
            LOG.warn("$SQOOP_CONF_DIR has not been set in the environment. Cannot check for additional configuration.");
            return conf;
        }
        File confDir = new File(confDirName);
        File toolsDir = new File(confDir, "tools.d");
        if (toolsDir.exists() && toolsDir.isDirectory()) {
            Object[] fileNames = toolsDir.list();
            Arrays.sort(fileNames);
            for (Object fileName : fileNames) {
                File f = new File(toolsDir, (String)fileName);
                if (!f.isFile()) continue;
            }
        }
        conf.setClassLoader(Thread.currentThread().getContextClassLoader());
        return conf;
    }

    private static void addPlugin(Configuration conf, String pluginName) {
        String existingPlugins = conf.get(TOOL_PLUGINS_KEY);
        String newPlugins = null;
        newPlugins = null == existingPlugins || existingPlugins.length() == 0 ? pluginName : existingPlugins + "," + pluginName;
        conf.set(TOOL_PLUGINS_KEY, newPlugins);
    }

    public static Set<String> getToolNames() {
        return TOOLS.keySet();
    }

    public static SqoopTool getTool(String toolName) {
        Class<? extends SqoopTool> cls = TOOLS.get(toolName);
        try {
            if (null != cls) {
                SqoopTool tool = cls.newInstance();
                tool.setToolName(toolName);
                return tool;
            }
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            return null;
        }
        return null;
    }

    public static String getToolDescription(String toolName) {
        return DESCRIPTIONS.get(toolName);
    }

    public SqoopTool() {
        this.toolName = "<" + this.getClass().getName() + ">";
    }

    public SqoopTool(String name) {
        this.toolName = name;
    }

    public String getToolName() {
        return this.toolName;
    }

    protected void setToolName(String name) {
        this.toolName = name;
    }

    public abstract int run(SqoopOptions var1);

    public void configureOptions(ToolOptions opts) {
    }

    public void printHelp(ToolOptions opts) {
        System.out.println("usage: sqoop " + this.getToolName() + " [GENERIC-ARGS] [TOOL-ARGS]");
        System.out.println("");
        opts.printHelp();
        System.out.println("");
        System.out.println("Generic Hadoop command-line arguments:");
        System.out.println("(must preceed any tool-specific arguments)");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
    }

    public void applyOptions(CommandLine in, SqoopOptions out) {
    }

    public void validateOptions(SqoopOptions options) {
    }

    public SqoopOptions parseArguments(String[] args, Configuration conf, SqoopOptions in, boolean useGenericOptions) throws ParseException, SqoopOptions.InvalidOptionsException {
        SqoopOptions out = in;
        if (null == out) {
            out = new SqoopOptions();
        }
        if (null != conf) {
            out.setConf(conf);
        } else if (null == out.getConf()) {
            out.setConf(new Configuration());
        }
        out.setActiveSqoopTool(this);
        String[] toolArgs = args;
        if (useGenericOptions) {
            try {
                toolArgs = ConfigurationHelper.parseGenericOptions(out.getConf(), args);
            }
            catch (IOException ioe) {
                ParseException pe = new ParseException("Could not parse generic arguments");
                pe.initCause((Throwable)ioe);
                throw pe;
            }
        }
        ToolOptions toolOptions = new ToolOptions();
        this.configureOptions(toolOptions);
        SqoopParser parser = new SqoopParser();
        CommandLine cmdLine = parser.parse(toolOptions.merge(), toolArgs, false);
        this.applyOptions(cmdLine, out);
        this.extraArguments = cmdLine.getArgs();
        return out;
    }

    public void appendArgs(String[] extra) {
        int existingLen = this.extraArguments == null ? 0 : this.extraArguments.length;
        int newLen = extra == null ? 0 : extra.length;
        String[] newExtra = new String[existingLen + newLen];
        if (null != this.extraArguments) {
            System.arraycopy(this.extraArguments, 0, newExtra, 0, existingLen);
        }
        if (null != extra) {
            System.arraycopy(extra, 0, newExtra, existingLen, newLen);
        }
        this.extraArguments = newExtra;
    }

    public List<String> getDependencyJars() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getToolName();
    }
}

