/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.sqoop;

import com.aliyun.dataworks.migrationx.transformer.core.sqoop.BaseSqoopTool;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.InvalidOptionsException;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.RelatedOptions;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.SqoopOptions;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.ToolOptions;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTool
extends BaseSqoopTool {
    public static final Logger LOG = LoggerFactory.getLogger((String)ImportTool.class.getName());
    protected String[] extraArguments;
    private boolean allTables;
    private int checkColumnType;
    private ClassLoader prevClassLoader = null;

    public ImportTool() {
        this("import", false);
    }

    public ImportTool(String toolName, boolean allTables) {
        super(toolName);
        this.allTables = allTables;
    }

    private boolean isIncremental(SqoopOptions options) {
        return !options.getIncrementalMode().equals((Object)SqoopOptions.IncrementalMode.None);
    }

    private boolean isDateTimeColumn(int columnType) {
        return columnType == 93 || columnType == 91 || columnType == 92;
    }

    protected RelatedOptions getImportOptions() {
        RelatedOptions importOpts = new RelatedOptions("Import control arguments");
        OptionBuilder.withDescription((String)"Use direct import fast path");
        OptionBuilder.withLongOpt((String)"direct");
        importOpts.addOption(OptionBuilder.create());
        if (!this.allTables) {
            OptionBuilder.withArgName((String)"table-name");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Table to read");
            OptionBuilder.withLongOpt((String)"table");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"col,col,col...");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Columns to import from table");
            OptionBuilder.withLongOpt((String)"columns");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"column-name");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Column of the table used to split work units");
            OptionBuilder.withLongOpt((String)"split-by");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"size");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Upper Limit of rows per split for split columns of Date/Time/Timestamp and integer types. For date or timestamp fields it is calculated in seconds. split-limit should be greater than 0");
            OptionBuilder.withLongOpt((String)"split-limit");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"where clause");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"WHERE clause to use during import");
            OptionBuilder.withLongOpt((String)"where");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withDescription((String)"Imports data in append mode");
            OptionBuilder.withLongOpt((String)"append");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withDescription((String)"Imports data in delete mode");
            OptionBuilder.withLongOpt((String)"delete-target-dir");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"dir");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"HDFS plain table destination");
            OptionBuilder.withLongOpt((String)"target-dir");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"statement");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Import results of SQL 'statement'");
            OptionBuilder.withLongOpt((String)"query");
            importOpts.addOption(OptionBuilder.create((String)"e"));
            OptionBuilder.withArgName((String)"statement");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Set boundary query for retrieving max and min value of the primary key");
            OptionBuilder.withLongOpt((String)"boundary-query");
            importOpts.addOption(OptionBuilder.create());
            OptionBuilder.withArgName((String)"column");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Key column to use to join results");
            OptionBuilder.withLongOpt((String)"merge-key");
            importOpts.addOption(OptionBuilder.create());
            this.addValidationOpts(importOpts);
        }
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"HDFS parent for table destination");
        OptionBuilder.withLongOpt((String)"warehouse-dir");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Imports data to SequenceFiles");
        OptionBuilder.withLongOpt((String)"as-sequencefile");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Imports data as plain text (default)");
        OptionBuilder.withLongOpt((String)"as-textfile");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Imports data to Avro data files");
        OptionBuilder.withLongOpt((String)"as-avrodatafile");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Imports data to Parquet files");
        OptionBuilder.withLongOpt((String)"as-parquetfile");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Use 'n' map tasks to import in parallel");
        OptionBuilder.withLongOpt((String)"num-mappers");
        importOpts.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set name for generated mapreduce job");
        OptionBuilder.withLongOpt((String)"mapreduce-job-name");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Enable compression");
        OptionBuilder.withLongOpt((String)"compress");
        importOpts.addOption(OptionBuilder.create((String)"z"));
        OptionBuilder.withArgName((String)"codec");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Compression codec to use for import");
        OptionBuilder.withLongOpt((String)"compression-codec");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Split the input stream every 'n' bytes when importing in direct mode");
        OptionBuilder.withLongOpt((String)"direct-split-size");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set the maximum size for an inline LOB");
        OptionBuilder.withLongOpt((String)"inline-lob-limit");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set number 'n' of rows to fetch from the database when more rows are needed");
        OptionBuilder.withLongOpt((String)"fetch-size");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"reset-mappers");
        OptionBuilder.withDescription((String)"Reset the number of mappers to one mapper if no split key available");
        OptionBuilder.withLongOpt((String)"autoreset-to-one-mapper");
        importOpts.addOption(OptionBuilder.create());
        return importOpts;
    }

    protected RelatedOptions getIncrementalOptions() {
        RelatedOptions incrementalOpts = new RelatedOptions("Incremental import arguments");
        OptionBuilder.withArgName((String)"import-type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Define an incremental import of type 'append' or 'lastmodified'");
        OptionBuilder.withLongOpt((String)"incremental");
        incrementalOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"column");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Source column to check for incremental change");
        OptionBuilder.withLongOpt((String)"check-column");
        incrementalOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Last imported value in the incremental check column");
        OptionBuilder.withLongOpt((String)"last-value");
        incrementalOpts.addOption(OptionBuilder.create());
        return incrementalOpts;
    }

    @Override
    public void configureOptions(ToolOptions toolOptions) {
        toolOptions.addUniqueOptions(this.getCommonOptions());
        toolOptions.addUniqueOptions(this.getImportOptions());
        if (!this.allTables) {
            toolOptions.addUniqueOptions(this.getIncrementalOptions());
        }
        toolOptions.addUniqueOptions(this.getOutputFormatOptions());
        toolOptions.addUniqueOptions(this.getInputFormatOptions());
        toolOptions.addUniqueOptions(this.getHiveOptions(true));
        toolOptions.addUniqueOptions(this.getHBaseOptions());
        toolOptions.addUniqueOptions(this.getHCatalogOptions());
        toolOptions.addUniqueOptions(this.getHCatImportOnlyOptions());
        toolOptions.addUniqueOptions(this.getAccumuloOptions());
        RelatedOptions codeGenOpts = this.getCodeGenOpts(this.allTables);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Disable code generation; use specified jar");
        OptionBuilder.withLongOpt((String)"jar-file");
        codeGenOpts.addOption(OptionBuilder.create());
        toolOptions.addUniqueOptions(codeGenOpts);
    }

    @Override
    public void printHelp(ToolOptions toolOptions) {
        super.printHelp(toolOptions);
        System.out.println("");
        if (this.allTables) {
            System.out.println("At minimum, you must specify --connect");
        } else {
            System.out.println("At minimum, you must specify --connect and --table");
        }
        System.out.println("Arguments to mysqldump and other subprograms may be supplied");
        System.out.println("after a '--' on the command line.");
    }

    private void applyIncrementalOptions(CommandLine in, SqoopOptions out) throws InvalidOptionsException {
        if (in.hasOption("incremental")) {
            String incrementalTypeStr = in.getOptionValue("incremental");
            if ("append".equals(incrementalTypeStr)) {
                out.setIncrementalMode(SqoopOptions.IncrementalMode.AppendRows);
                out.setAppendMode(true);
            } else if ("lastmodified".equals(incrementalTypeStr)) {
                out.setIncrementalMode(SqoopOptions.IncrementalMode.DateLastModified);
            } else {
                throw new InvalidOptionsException("Unknown incremental import mode: " + incrementalTypeStr + ". Use 'append' or 'lastmodified'." + "\nTry --help for usage instructions.");
            }
        }
        if (in.hasOption("check-column")) {
            out.setIncrementalTestColumn(in.getOptionValue("check-column"));
        }
        if (in.hasOption("last-value")) {
            out.setIncrementalLastValue(in.getOptionValue("last-value"));
        }
    }

    @Override
    public void applyOptions(CommandLine in, SqoopOptions out) {
        try {
            this.applyCommonOptions(in, out);
            if (in.hasOption("direct")) {
                out.setDirectMode(true);
            }
            if (!this.allTables) {
                if (in.hasOption("table")) {
                    out.setTableName(in.getOptionValue("table"));
                }
                if (in.hasOption("columns")) {
                    String[] cols = in.getOptionValue("columns").split(",");
                    for (int i = 0; i < cols.length; ++i) {
                        cols[i] = cols[i].trim();
                    }
                    out.setColumns(cols);
                }
                if (in.hasOption("split-by")) {
                    out.setSplitByCol(in.getOptionValue("split-by"));
                }
                if (in.hasOption("split-limit")) {
                    out.setSplitLimit(Integer.parseInt(in.getOptionValue("split-limit")));
                }
                if (in.hasOption("where")) {
                    out.setWhereClause(in.getOptionValue("where"));
                }
                if (in.hasOption("target-dir")) {
                    out.setTargetDir(in.getOptionValue("target-dir"));
                }
                if (in.hasOption("append")) {
                    out.setAppendMode(true);
                }
                if (in.hasOption("delete-target-dir")) {
                    out.setDeleteMode(true);
                }
                if (in.hasOption("query")) {
                    out.setSqlQuery(in.getOptionValue("query"));
                }
                if (in.hasOption("boundary-query")) {
                    out.setBoundaryQuery(in.getOptionValue("boundary-query"));
                }
                if (in.hasOption("merge-key")) {
                    out.setMergeKeyCol(in.getOptionValue("merge-key"));
                }
                this.applyValidationOptions(in, out);
            }
            if (in.hasOption("warehouse-dir")) {
                out.setWarehouseDir(in.getOptionValue("warehouse-dir"));
            }
            if (in.hasOption("as-sequencefile")) {
                out.setFileLayout(SqoopOptions.FileLayout.SequenceFile);
            }
            if (in.hasOption("as-textfile")) {
                out.setFileLayout(SqoopOptions.FileLayout.TextFile);
            }
            if (in.hasOption("as-avrodatafile")) {
                out.setFileLayout(SqoopOptions.FileLayout.AvroDataFile);
            }
            if (in.hasOption("as-parquetfile")) {
                out.setFileLayout(SqoopOptions.FileLayout.ParquetFile);
            }
            if (in.hasOption("num-mappers")) {
                out.setNumMappers(Integer.parseInt(in.getOptionValue("num-mappers")));
            }
            if (in.hasOption("mapreduce-job-name")) {
                out.setMapreduceJobName(in.getOptionValue("mapreduce-job-name"));
            }
            if (in.hasOption("compress")) {
                out.setUseCompression(true);
            }
            if (in.hasOption("compression-codec")) {
                out.setCompressionCodec(in.getOptionValue("compression-codec"));
            }
            if (in.hasOption("direct-split-size")) {
                out.setDirectSplitSize(Long.parseLong(in.getOptionValue("direct-split-size")));
            }
            if (in.hasOption("inline-lob-limit")) {
                out.setInlineLobLimit(Long.parseLong(in.getOptionValue("inline-lob-limit")));
            }
            if (in.hasOption("fetch-size")) {
                out.setFetchSize(new Integer(in.getOptionValue("fetch-size")));
            }
            if (in.hasOption("jar-file")) {
                out.setExistingJarName(in.getOptionValue("jar-file"));
            }
            if (in.hasOption("autoreset-to-one-mapper")) {
                out.setAutoResetToOneMapper(true);
            }
            this.applyIncrementalOptions(in, out);
            this.applyHiveOptions(in, out);
            this.applyCodeGenOptions(in, out, this.allTables);
            this.applyHBaseOptions(in, out);
            this.applyHCatalogOptions(in, out);
            this.applyAccumuloOptions(in, out);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidOptionsException("Error: expected numeric argument.\nTry --help for usage.");
        }
    }

    protected void validateImportOptions(SqoopOptions options) throws InvalidOptionsException {
        if (!this.allTables && options.getTableName() == null && options.getSqlQuery() == null) {
            throw new InvalidOptionsException("--table or --query is required for import. (Or use sqoop import-all-tables.)\nTry --help for usage instructions.");
        }
        if (options.getExistingJarName() != null && options.getClassName() == null) {
            throw new InvalidOptionsException("Jar specified with --jar-file, but no class specified with --class-name.\nTry --help for usage instructions.");
        }
        if (options.getTargetDir() != null && options.getWarehouseDir() != null) {
            throw new InvalidOptionsException("--target-dir with --warehouse-dir are incompatible options.\nTry --help for usage instructions.");
        }
        if (options.getTableName() != null && options.getSqlQuery() != null) {
            throw new InvalidOptionsException("Cannot specify --query and --table together.\nTry --help for usage instructions.");
        }
        if (options.getSqlQuery() != null && options.getTargetDir() == null && options.getHBaseTable() == null && options.getHCatTableName() == null && options.getAccumuloTable() == null) {
            throw new InvalidOptionsException("Must specify destination with --target-dir. \nTry --help for usage instructions.");
        }
        if (options.getSqlQuery() != null && options.doHiveImport() && options.getHiveTableName() == null) {
            throw new InvalidOptionsException("When importing a query to Hive, you must specify --hive-table.\nTry --help for usage instructions.");
        }
        if (options.getSqlQuery() != null && options.getNumMappers() > 1 && options.getSplitByCol() == null) {
            throw new InvalidOptionsException("When importing query results in parallel, you must specify --split-by.\nTry --help for usage instructions.");
        }
        if (options.isDirect() && options.getFileLayout() != SqoopOptions.FileLayout.TextFile && options.getConnectString().contains("jdbc:mysql://")) {
            throw new InvalidOptionsException("MySQL direct import currently supports only text output format. Parameters --as-sequencefile --as-avrodatafile and --as-parquetfile are not supported with --direct params in MySQL case.");
        }
        if (options.isDirect() && options.doHiveDropDelims()) {
            throw new InvalidOptionsException("Direct import currently do not support dropping hive delimiters, please remove parameter --hive-drop-import-delims.");
        }
        if (this.allTables && options.isValidationEnabled()) {
            throw new InvalidOptionsException("Validation is not supported for all tables but single table only.");
        }
        if (options.getSqlQuery() != null && options.isValidationEnabled()) {
            throw new InvalidOptionsException("Validation is not supported for free from query but single table only.");
        }
        if (options.getWhereClause() != null && options.isValidationEnabled()) {
            throw new InvalidOptionsException("Validation is not supported for where clause but single table only.");
        }
        if (options.getIncrementalMode() != SqoopOptions.IncrementalMode.None && options.isValidationEnabled()) {
            throw new InvalidOptionsException("Validation is not supported for incremental imports but single table only.");
        }
        if ((options.getTargetDir() != null || options.getWarehouseDir() != null) && options.getHCatTableName() != null) {
            throw new InvalidOptionsException("--hcatalog-table cannot be used  --warehouse-dir or --target-dir options");
        }
        if (options.isDeleteMode() && options.isAppendMode()) {
            throw new InvalidOptionsException("--append and --delete-target-dir can not be used together.");
        }
        if (options.isDeleteMode() && options.getIncrementalMode() != SqoopOptions.IncrementalMode.None) {
            throw new InvalidOptionsException("--delete-target-dir can not be used with incremental imports.");
        }
        if (options.getAutoResetToOneMapper() && options.getSplitByCol() != null) {
            throw new InvalidOptionsException("--autoreset-to-one-mapper and --split-by cannot be used together.");
        }
    }

    private void validateIncrementalOptions(SqoopOptions options) throws InvalidOptionsException {
        if (options.getIncrementalMode() != SqoopOptions.IncrementalMode.None && options.getIncrementalTestColumn() == null) {
            throw new InvalidOptionsException("For an incremental import, the check column must be specified with --check-column. \nTry --help for usage instructions.");
        }
        if (options.getIncrementalMode() == SqoopOptions.IncrementalMode.None && options.getIncrementalTestColumn() != null) {
            throw new InvalidOptionsException("You must specify an incremental import mode with --incremental. \nTry --help for usage instructions.");
        }
        if (options.getIncrementalMode() == SqoopOptions.IncrementalMode.DateLastModified && options.getFileLayout() == SqoopOptions.FileLayout.AvroDataFile) {
            throw new InvalidOptionsException("--incremental lastmodified cannot be used in conjunction with --as-avrodatafile.\nTry --help for usage instructions.");
        }
    }

    @Override
    public void validateOptions(SqoopOptions options) {
        options.setExtraArgs(this.getSubcommandArgs(this.extraArguments));
        int dashPos = this.getDashPosition(this.extraArguments);
        if (this.hasUnrecognizedArgs(this.extraArguments, 0, dashPos)) {
            throw new InvalidOptionsException("\nTry --help for usage instructions.");
        }
        this.validateImportOptions(options);
        this.validateIncrementalOptions(options);
        this.validateCommonOptions(options);
        this.validateCodeGenOptions(options);
        this.validateOutputFormatOptions(options);
        this.validateHBaseOptions(options);
        this.validateHiveOptions(options);
        this.validateHCatalogOptions(options);
        this.validateAccumuloOptions(options);
    }

    @Override
    public int run(SqoopOptions options) {
        return 0;
    }
}

