/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.sqoop;

public class DelimiterSet
implements Cloneable {
    public static final DelimiterSet DEFAULT_DELIMITERS = new DelimiterSet(',', '\n', '\u0000', '\u0000', false);
    public static final DelimiterSet HIVE_DELIMITERS;
    public static final DelimiterSet MYSQL_DELIMITERS;
    public static final char NULL_CHAR = '\u0000';
    private char fieldDelim;
    private char recordDelim;
    private char enclosedBy;
    private char escapedBy;
    private boolean encloseRequired;
    public static final String OUTPUT_FIELD_DELIM_KEY = "sqoop.output.field.delim";
    public static final String OUTPUT_RECORD_DELIM_KEY = "sqoop.output.record.delim";
    public static final String OUTPUT_ENCLOSED_BY_KEY = "sqoop.output.enclosed.by";
    public static final String OUTPUT_ESCAPED_BY_KEY = "sqoop.output.escaped.by";
    public static final String OUTPUT_ENCLOSE_REQUIRED_KEY = "sqoop.output.enclose.required";
    public static final String INPUT_FIELD_DELIM_KEY = "sqoop.input.field.delim";
    public static final String INPUT_RECORD_DELIM_KEY = "sqoop.input.record.delim";
    public static final String INPUT_ENCLOSED_BY_KEY = "sqoop.input.enclosed.by";
    public static final String INPUT_ESCAPED_BY_KEY = "sqoop.input.escaped.by";
    public static final String INPUT_ENCLOSE_REQUIRED_KEY = "sqoop.input.enclose.required";

    public DelimiterSet() {
        this(',', '\n', '\u0000', '\u0000', false);
    }

    public DelimiterSet(char field, char record, char enclose, char escape, boolean isEncloseRequired) {
        this.fieldDelim = field;
        this.recordDelim = record;
        this.enclosedBy = enclose;
        this.escapedBy = escape;
        this.encloseRequired = isEncloseRequired;
    }

    public DelimiterSet copy() {
        try {
            return (DelimiterSet)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public void setFieldsTerminatedBy(char f) {
        this.fieldDelim = f;
    }

    public char getFieldsTerminatedBy() {
        return this.fieldDelim;
    }

    public void setLinesTerminatedBy(char r) {
        this.recordDelim = r;
    }

    public char getLinesTerminatedBy() {
        return this.recordDelim;
    }

    public void setEnclosedBy(char e) {
        this.enclosedBy = e;
    }

    public char getEnclosedBy() {
        return this.enclosedBy;
    }

    public void setEscapedBy(char e) {
        this.escapedBy = e;
    }

    public char getEscapedBy() {
        return this.escapedBy;
    }

    public void setEncloseRequired(boolean required) {
        this.encloseRequired = required;
    }

    public boolean isEncloseRequired() {
        return this.encloseRequired;
    }

    public String toString() {
        return "fields=" + this.fieldDelim + " records=" + this.recordDelim + " escape=" + this.escapedBy + " enclose=" + this.enclosedBy + " required=" + this.encloseRequired;
    }

    public String formatConstructor() {
        return "new DelimiterSet((char) " + this.fieldDelim + ", (char) " + this.recordDelim + ", (char) " + this.enclosedBy + ", (char) " + this.escapedBy + ", " + this.encloseRequired + ")";
    }

    public int hashCode() {
        return this.fieldDelim + (this.recordDelim << 4) + (this.escapedBy << 8) + (this.enclosedBy << 12) + (this.recordDelim << 16) + (this.encloseRequired ? 65278 : 28784);
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        DelimiterSet set = (DelimiterSet)other;
        return this.fieldDelim == set.fieldDelim && this.recordDelim == set.recordDelim && this.escapedBy == set.escapedBy && this.enclosedBy == set.enclosedBy && this.encloseRequired == set.encloseRequired;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static {
        MYSQL_DELIMITERS = new DelimiterSet(',', '\n', '\'', '\\', false);
        HIVE_DELIMITERS = new DelimiterSet('\u0001', '\n', '\u0000', '\u0000', false);
    }
}

