/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.loader;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwFunction;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Resource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.WorkflowType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DefaultNodeTypeUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.ResourceUtils;
import com.aliyun.dataworks.migrationx.transformer.core.common.Constants;
import com.aliyun.dataworks.migrationx.transformer.core.controller.Task;
import com.aliyun.migrationx.common.utils.BeanUtils;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectWorkflowLoader
extends Task<List<DwWorkflow>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectWorkflowLoader.class);
    private String projectDir;
    private List<DwWorkflow> workflowList;
    private List<DwResource> resources;

    public ProjectWorkflowLoader(String projectDir) {
        super(ProjectWorkflowLoader.class.getSimpleName());
        this.projectDir = projectDir;
    }

    public ProjectWorkflowLoader(String projectDir, String name) {
        super(name);
        this.projectDir = projectDir;
    }

    @Override
    public List<DwWorkflow> call() throws Exception {
        File projectPath = new File(this.projectDir);
        File workflowPath = new File(projectPath.getAbsolutePath() + File.separator + Constants.WORKFLOWS_DIR_PRJ_RELATED);
        this.workflowList = new ArrayList<DwWorkflow>();
        LOGGER.info("workflow path: {}", (Object)workflowPath);
        if (workflowPath == null || workflowPath.listFiles() == null || !workflowPath.exists()) {
            return this.workflowList;
        }
        this.getResources();
        boolean newWorkflowDirectory = this.isNewWorkflowDirectory(workflowPath);
        if (!newWorkflowDirectory) {
            this.processWorkflowType(workflowPath, null);
        } else if (workflowPath.listFiles() != null) {
            Arrays.stream(workflowPath.listFiles()).forEach(typeDir -> {
                try {
                    this.processWorkflowType((File)typeDir, WorkflowType.valueOf((String)StringUtils.upperCase((String)typeDir.getName())));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return this.workflowList;
    }

    private void processWorkflowType(File workflowPath, WorkflowType type) throws IOException {
        for (File flowDir : workflowPath.listFiles()) {
            if (flowDir.isFile()) {
                LOGGER.info("{} is not directory, skip it", (Object)flowDir.getName());
                continue;
            }
            LOGGER.info("found workflow: {}, path: {}", (Object)flowDir.getName(), (Object)flowDir.getAbsoluteFile());
            DwWorkflow workflow = this.loadWorkflowDir(flowDir);
            if (type == null) {
                if (BooleanUtils.isTrue((Boolean)workflow.getScheduled())) {
                    workflow.setType(WorkflowType.BUSINESS);
                } else {
                    workflow.setType(WorkflowType.MANUAL_BUSINESS);
                }
                if (workflow.getName().equalsIgnoreCase("OLD_VERSION_WORKFLOW")) {
                    workflow.setType(WorkflowType.OLD_WORKFLOW);
                }
            } else {
                workflow.setType(type);
            }
            workflow.setLocalPath(flowDir);
            this.workflowList.add(workflow);
        }
    }

    private boolean isNewWorkflowDirectory(File workflowPath) {
        File[] subDirs = workflowPath.listFiles();
        if (subDirs == null) {
            return false;
        }
        return Arrays.stream(subDirs).allMatch(dir -> Arrays.stream(WorkflowType.values()).anyMatch(t -> t.name().equalsIgnoreCase(dir.getName())));
    }

    private void getResources() {
        this.resources = this.dependencies.stream().filter(task -> task.getResult() != null).filter(task -> task.getResult() instanceof List).filter(task -> !CollectionUtils.isEmpty((Collection)((List)task.getResult()))).filter(task -> ((List)task.getResult()).get(0) instanceof DwResource).map(task -> (List)task.getResult()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private DwWorkflow loadWorkflowDir(File flowDir) throws IOException {
        String workflowXmlFile = flowDir.getAbsolutePath() + File.separator + "workflow.xml";
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        DwWorkflow workflow = (DwWorkflow)xmlMapper.readValue(new File(workflowXmlFile), DwWorkflow.class);
        workflow.setNodes(ListUtils.emptyIfNull((List)workflow.getNodes()).stream().map(node -> {
            DwNode dwNode = new DwNode();
            BeanUtils.copyProperties((Object)node, (Object)dwNode);
            ListUtils.emptyIfNull((List)dwNode.getInputs()).stream().filter(in -> in.getParseType() == null).forEach(in -> in.setParseType(Integer.valueOf(1)));
            ListUtils.emptyIfNull((List)dwNode.getOutputs()).stream().filter(in -> in.getParseType() == null).forEach(in -> in.setParseType(Integer.valueOf(1)));
            if (workflow.getScheduled().booleanValue()) {
                dwNode.setNodeUseType(Optional.ofNullable(node.getNodeUseType()).orElse(NodeUseType.SCHEDULED));
            } else {
                dwNode.setNodeUseType(Optional.ofNullable(node.getNodeUseType()).orElse(NodeUseType.MANUAL));
            }
            if (DefaultNodeTypeUtils.isDiNode((String)dwNode.getType())) {
                this.setDiResourceGroupInfo(dwNode);
            }
            return dwNode;
        }).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty((Collection)workflow.getResources())) {
            Map<String, DwResource> map = this.resources.stream().collect(Collectors.toMap(res -> res.getName(), res -> res));
            Map<String, Resource> resMap = workflow.getResources().stream().collect(Collectors.toMap(res -> res.getName(), res -> res));
            ArrayList newResList = new ArrayList();
            resMap.keySet().stream().forEach(name -> {
                Resource res = (Resource)resMap.get(name);
                DwResource dwRes = new DwResource();
                BeanUtils.copyProperties((Object)res, (Object)dwRes);
                if (map.containsKey(name)) {
                    dwRes.setLocalPath(((DwResource)map.get(name)).getLocalPath());
                }
                if (res.getType() == null) {
                    dwRes.setType(ResourceUtils.getFileResourceType((String)name));
                }
                dwRes.setWorkflowRef(workflow);
                newResList.add(dwRes);
            });
            workflow.setResources(newResList);
        }
        if (!CollectionUtils.isEmpty((Collection)workflow.getFunctions())) {
            workflow.setFunctions(workflow.getFunctions().stream().map(fun -> {
                DwFunction dwFunction = new DwFunction();
                BeanUtils.copyProperties((Object)fun, (Object)dwFunction);
                dwFunction.setWorkflowRef(workflow);
                return dwFunction;
            }).collect(Collectors.toList()));
        }
        return workflow;
    }

    private void setDiResourceGroupInfo(DwNode dwNode) {
        if (StringUtils.isNotBlank((CharSequence)dwNode.getDiResourceGroup())) {
            return;
        }
        String code = dwNode.getCode();
        if (StringUtils.isBlank((CharSequence)code)) {
            return;
        }
        try {
            JsonObject jsonObject = (JsonObject)GsonUtils.gson.fromJson(code, JsonObject.class);
            if (jsonObject == null) {
                return;
            }
            if (!jsonObject.has("extend")) {
                return;
            }
            JsonObject extendJson = jsonObject.get("extend").getAsJsonObject();
            if (!extendJson.has("resourceGroup")) {
                return;
            }
            String resourceGroup = extendJson.get("resourceGroup").getAsString();
            dwNode.setDiResourceGroup(resourceGroup);
            dwNode.setDiResourceGroupName(resourceGroup);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

