/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.controller;

import com.aliyun.dataworks.migrationx.transformer.core.common.Context;
import com.aliyun.dataworks.migrationx.transformer.core.controller.TaskDag;
import com.aliyun.dataworks.migrationx.transformer.core.controller.TaskStage;
import com.aliyun.dataworks.migrationx.transformer.core.controller.TaskStatus;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItem;
import com.aliyun.dataworks.migrationx.transformer.core.report.Reportable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public abstract class Task<T>
implements Callable<T>,
Reportable {
    protected String name;
    protected List<Task<?>> dependencies = new ArrayList();
    protected T result;
    protected Context context;
    protected TaskStage stage;
    protected List<ReportItem> reportItems = new ArrayList<ReportItem>();
    protected TaskDag taskDag;
    protected TaskStatus taskStatus = TaskStatus.INIT;

    public Task() {
        this.name = this.getClass().getSimpleName();
    }

    public Task(String name) {
        this.name = name;
    }

    public Task(String name, Task ... dependsOn) {
        this.name = name;
        for (Task dep : dependsOn) {
            this.dependencies.add(dep);
        }
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    public void setTaskDag(TaskDag taskDag) {
        this.taskDag = taskDag;
    }

    public Class<T> getTemplateParameterType() {
        Method[] methods;
        for (Method method : methods = this.getClass().getDeclaredMethods()) {
            if (!"call".equals(method.getName())) continue;
            return method.getReturnType();
        }
        throw new RuntimeException("get template parameter type exception");
    }

    public TaskStage getStage() {
        return this.stage;
    }

    public void setStage(TaskStage stage) {
        this.stage = stage;
    }

    public String getName() {
        return this.name;
    }

    public List<Task<?>> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Task<?>> dependencies) {
        this.dependencies = dependencies;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Task<T> dependsOn(Task<?> dependTask) {
        long count = this.getDependencies().stream().filter(o -> o.getName().equals(dependTask.getName())).count();
        if (count == 0L) {
            this.dependencies.add(dependTask);
        }
        return this;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public T getResult() {
        return this.result;
    }

    @Override
    public T call() throws Exception {
        this.result = this.call();
        return this.result;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public List<ReportItem> getReport() {
        return this.reportItems;
    }
}

