/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core;

import com.aliyun.dataworks.client.command.CommandApp;
import com.aliyun.dataworks.migrationx.domain.dataworks.standard.objects.Package;
import com.aliyun.dataworks.migrationx.transformer.core.transformer.Transformer;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.utils.JSONUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTransformerApp
extends CommandApp {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTransformerApp.class);
    private static final String EXAMPLE = "python ./migrationx-transformer/bin/transformer.py -a dataworks_transformer -c dataworks-config.json -s project_a.zip -t dw.zip";
    private static final String HEADER = "Transformer Command App";
    protected final Class<? extends Package> from;
    protected final Class<? extends Package> to;
    protected String optConfig;
    protected String optSourcePackage;
    protected String optTargetPackage;
    protected String checkpoint;
    protected String load;
    protected String resourceDir;

    public BaseTransformerApp(Class<? extends Package> from, Class<? extends Package> to) {
        this.from = from;
        this.to = to;
    }

    public void run(String[] args) {
        LOGGER.info("Transformer App started with {}", (Object)JSONUtils.toJsonString((Object)args));
        Options options = new Options();
        options.addRequiredOption("c", "config", true, "transform configuration file path");
        options.addRequiredOption("s", "sourcePackage", true, "source package file path");
        options.addRequiredOption("t", "targetPackage", true, "target package file path");
        options.addOption("ckpt", "checkpoint", true, "checkpoint dir");
        options.addOption("ld", "load", true, "resume dir");
        options.addOption("rs", "resource", true, "resource directory");
        HelpFormatter helpFormatter = new HelpFormatter();
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine commandLine = parser.parse(options, args);
            this.optConfig = commandLine.getOptionValue("c");
            this.optSourcePackage = commandLine.getOptionValue("s");
            this.optTargetPackage = commandLine.getOptionValue("t");
            this.checkpoint = commandLine.getOptionValue("ckpt");
            this.load = commandLine.getOptionValue("ld");
            this.resourceDir = commandLine.getOptionValue("rs");
            this.doTransform();
        }
        catch (ParseException e) {
            LOGGER.error("parser command error: {}", (Object)e.getMessage());
            helpFormatter.printHelp("Options", HEADER, options, EXAMPLE);
            System.exit(-1);
        }
        catch (Exception e) {
            LOGGER.error("transformer error: {}", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected abstract Transformer createTransformer(File var1, Package var2, Package var3);

    protected void doTransform() throws Exception {
        Package fromPackage = this.from.newInstance().setPackageFile(new File(new File(this.optSourcePackage).getAbsolutePath()));
        Package toPackage = this.to.newInstance().setPackageFile(new File(new File(this.optTargetPackage).getAbsolutePath()));
        LOGGER.info("start transform from: {}, to: {}", this.from, this.to);
        Transformer transformer = this.createTransformer(new File(this.optConfig), fromPackage, toPackage);
        this.initCollector();
        TransformerContext.getContext().setCustomResourceDir(this.resourceDir);
        this.checkAndSetCheckpoint();
        transformer.init();
        transformer.load();
        transformer.transform();
        transformer.write();
        this.finishCollector();
        LOGGER.info("transform success");
    }

    protected void initCollector() {
    }

    protected void checkAndSetCheckpoint() throws IOException {
        TransformerContext.getContext().setCheckpoint(this.checkpoint);
        TransformerContext.getContext().setLoad(this.load);
        if (TransformerContext.getContext().getCheckpoint() != null && TransformerContext.getContext().getLoad() != null && TransformerContext.getContext().getCheckpoint().getCanonicalPath().equals(TransformerContext.getContext().getLoad().getCanonicalPath())) {
            throw new RuntimeException("checkpoint path can not equals to load path");
        }
        File file = TransformerContext.getContext().getCheckpoint();
        if (file != null && file.exists()) {
            for (File child : file.listFiles()) {
                if (!child.getName().endsWith(".ckpt")) continue;
                child.delete();
            }
        }
    }

    protected void finishCollector() {
        TransformerContext.getCollector().finishCollector();
        TransformerContext.clear();
    }
}

