/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import java.util.HashMap;
import java.util.Map;

public class AzureEnvironment {
    private String name;
    private String serviceManagementEndpoint;
    private String resourceManagerEndpoint;
    private String activeDirectoryEndpoint;
    public static final String ARM_DATABRICKS_RESOURCE_ID = "2ff814a6-3304-4ab8-85cb-cd0e6f879c1d";
    private static final Map<String, AzureEnvironment> ENVIRONMENTS = new HashMap<String, AzureEnvironment>();

    public AzureEnvironment(String name, String serviceManagementEndpoint, String resourceManagerEndpoint, String activeDirectoryEndpoint) {
        this.name = name;
        this.serviceManagementEndpoint = serviceManagementEndpoint;
        this.resourceManagerEndpoint = resourceManagerEndpoint;
        this.activeDirectoryEndpoint = activeDirectoryEndpoint;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceManagementEndpoint() {
        return this.serviceManagementEndpoint;
    }

    public String getResourceManagerEndpoint() {
        return this.resourceManagerEndpoint;
    }

    public String getActiveDirectoryEndpoint() {
        return this.activeDirectoryEndpoint;
    }

    public static AzureEnvironment getEnvironment(String env) {
        if (!ENVIRONMENTS.containsKey(env)) {
            throw new IllegalArgumentException("Cannot find Azure " + env + " Environment");
        }
        return ENVIRONMENTS.get(env);
    }

    static {
        ENVIRONMENTS.put("PUBLIC", new AzureEnvironment("PUBLIC", "https://management.core.windows.net/", "https://management.azure.com/", "https://login.microsoftonline.com/"));
        ENVIRONMENTS.put("GERMAN", new AzureEnvironment("GERMAN", "https://management.core.cloudapi.de/", "https://management.microsoftazure.de/", "https://login.microsoftonline.de/"));
        ENVIRONMENTS.put("USGOVERNMENT", new AzureEnvironment("USGOVERNMENT", "https://management.core.usgovcloudapi.net/", "https://management.usgovcloudapi.net/", "https://login.microsoftonline.us/"));
        ENVIRONMENTS.put("CHINA", new AzureEnvironment("CHINA", "https://management.core.chinacloudapi.cn/", "https://management.chinacloudapi.cn/", "https://login.chinacloudapi.cn/"));
    }
}

