/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.utils.resource.mapping;

import com.aliyun.migration.teleport.common.utils.resource.mapping.MappingRule;
import com.aliyun.migration.teleport.common.utils.resource.mapping.ResourceMapping;
import java.util.ArrayList;

public class PartitionMapping
implements ResourceMapping {
    private final String rule;

    public PartitionMapping(String rule) {
        this.rule = rule;
    }

    @Override
    public String map(String partitionName) {
        if (partitionName == null || partitionName.isEmpty()) {
            return "";
        }
        if (this.rule == null || this.rule.isEmpty()) {
            return partitionName;
        }
        ArrayList<Object> results = new ArrayList<Object>();
        String[] parts = partitionName.split("/");
        String[] rules = this.rule.trim().split(";");
        block5: for (int i = 0; i < parts.length; ++i) {
            if (i >= rules.length) {
                results.add(parts[i]);
                continue;
            }
            MappingRule mappingRule = MappingRule.parse(rules[i]);
            if (mappingRule == null) {
                results.add(parts[i]);
                continue;
            }
            String[] kv = parts[i].split("=");
            switch (mappingRule.getType()) {
                case REPLACE: {
                    results.add(kv[0].replace(mappingRule.getKeyword(), mappingRule.getReplace()) + "=" + kv[1]);
                    continue block5;
                }
                case PREFIX: {
                    results.add(mappingRule.getKeyword() + kv[0] + "=" + kv[1]);
                    continue block5;
                }
                case SUFFIX: {
                    results.add(kv[0] + mappingRule.getKeyword() + "=" + kv[1]);
                    continue block5;
                }
                default: {
                    results.add(parts[i]);
                }
            }
        }
        return String.join((CharSequence)"/", results);
    }
}

