/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.utils.resource.mapping;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MappingRule {
    static Pattern defaultPattern = Pattern.compile("^(.*?):(.*?)$");
    static Pattern replacePattern = Pattern.compile("\\$\\{replace:(.*?):(.*?)}");
    static Pattern prePattern = Pattern.compile("\\$\\{pre:(.*?)}");
    static Pattern endPattern = Pattern.compile("\\$\\{end:(.*?)}");
    private MappingType type;
    private String keyword;
    private String replace;

    public static MappingRule parse(String mapping) {
        if (mapping == null || mapping.isEmpty()) {
            return null;
        }
        MappingRule rule = new MappingRule();
        Matcher replaceMatcher = replacePattern.matcher(mapping);
        if (replaceMatcher.find()) {
            rule.setType(MappingType.REPLACE);
            rule.setKeyword(replaceMatcher.group(1));
            rule.setReplace(replaceMatcher.group(2));
            return rule;
        }
        Matcher preMatcher = prePattern.matcher(mapping);
        if (preMatcher.find()) {
            rule.setType(MappingType.PREFIX);
            rule.setKeyword(preMatcher.group(1));
            return rule;
        }
        Matcher endMatcher = endPattern.matcher(mapping);
        if (endMatcher.find()) {
            rule.setType(MappingType.SUFFIX);
            rule.setKeyword(endMatcher.group(1));
            return rule;
        }
        Matcher defaultMatcher = defaultPattern.matcher(mapping);
        if (defaultMatcher.find()) {
            rule.setType(MappingType.REPLACE);
            rule.setKeyword(defaultMatcher.group(1));
            rule.setReplace(defaultMatcher.group(2));
            return rule;
        }
        rule.setType(MappingType.NONE);
        rule.setKeyword(mapping);
        rule.setReplace(mapping);
        return rule;
    }

    public MappingType getType() {
        return this.type;
    }

    public void setType(MappingType type) {
        this.type = type;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getReplace() {
        return this.replace;
    }

    public void setReplace(String replace) {
        this.replace = replace;
    }

    public static enum MappingType {
        NONE,
        REPLACE,
        PREFIX,
        SUFFIX;

    }
}

