/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.utils;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class TeleportThreadFactory
implements ThreadFactory {
    private ThreadGroup threadGroup;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private String namePrefix;
    private static final String DEFAULT_THREAD_GROUP = "teleport-thread-group";

    public TeleportThreadFactory(String threadGroup, String namePrefix) {
        this.threadGroup = new ThreadGroup(threadGroup);
        this.namePrefix = namePrefix;
    }

    public TeleportThreadFactory(String namePrefix) {
        this.threadGroup = new ThreadGroup(DEFAULT_THREAD_GROUP);
        this.namePrefix = namePrefix;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.threadGroup, r, this.namePrefix + "-" + this.threadNumber.getAndIncrement(), 0L);
        t.setUncaughtExceptionHandler((thread, error) -> thread.getThreadGroup().interrupt());
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

