/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.element.meta.dataset;

import java.io.Serializable;
import lombok.NonNull;

public class QualifiedName
implements Serializable {
    private String datasourceId;
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String partitionName;
    private Type type;

    private QualifiedName(@NonNull String datasourceId, String catalogName, @NonNull String schemaName, String tableName, String partitionName) {
        if (datasourceId == null) {
            throw new NullPointerException("datasourceId is marked non-null but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        this.catalogName = catalogName;
        this.datasourceId = datasourceId;
        this.schemaName = schemaName;
        this.tableName = QualifiedName.standardizeOptional(tableName);
        this.partitionName = QualifiedName.standardizeOptional(partitionName);
        if (this.datasourceId.isEmpty()) {
            throw new IllegalStateException("datasourceId is not present");
        }
        if ((this.catalogName == null || this.catalogName.isBlank()) && this.schemaName.isEmpty()) {
            throw new IllegalStateException("schemaName is not present");
        }
        if (this.tableName.isEmpty() && !this.partitionName.isEmpty()) {
            throw new IllegalStateException("tableName is not present but partitionName is present");
        }
        this.type = !this.partitionName.isEmpty() ? Type.PARTITION : (!this.tableName.isEmpty() ? Type.TABLE : Type.SCHEMA);
    }

    private QualifiedName(@NonNull String datasourceId, @NonNull String schemaName, String tableName, String partitionName) {
        if (datasourceId == null) {
            throw new NullPointerException("datasourceId is marked non-null but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        this.datasourceId = datasourceId;
        this.schemaName = schemaName;
        this.tableName = QualifiedName.standardizeOptional(tableName);
        this.partitionName = QualifiedName.standardizeOptional(partitionName);
        if (this.datasourceId.isEmpty()) {
            throw new IllegalStateException("datasourceId is not present");
        }
        if (this.schemaName.isEmpty()) {
            throw new IllegalStateException("schemaName is not present");
        }
        if (this.tableName.isEmpty() && !this.partitionName.isEmpty()) {
            throw new IllegalStateException("tableName is not present but partitionName is present");
        }
        this.type = !this.partitionName.isEmpty() ? Type.PARTITION : (!this.tableName.isEmpty() ? Type.TABLE : Type.SCHEMA);
    }

    public static QualifiedName ofCatalog(@NonNull String datasourceId, @NonNull String catalogName) {
        if (datasourceId == null) {
            throw new NullPointerException("datasourceId is marked non-null but is null");
        }
        if (catalogName == null) {
            throw new NullPointerException("catalogName is marked non-null but is null");
        }
        return new QualifiedName(datasourceId, catalogName, "", null, null);
    }

    public static QualifiedName ofSchema(@NonNull String datasourceId, String catalogName, @NonNull String databaseName) {
        if (datasourceId == null) {
            throw new NullPointerException("datasourceId is marked non-null but is null");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName is marked non-null but is null");
        }
        return new QualifiedName(datasourceId, catalogName, databaseName, null, null);
    }

    public static QualifiedName ofSchema(@NonNull String datasourceId, @NonNull String databaseName) {
        if (datasourceId == null) {
            throw new NullPointerException("datasourceId is marked non-null but is null");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName is marked non-null but is null");
        }
        return new QualifiedName(datasourceId, databaseName, null, null);
    }

    public static QualifiedName ofTable(@NonNull String datasourceId, String catalogName, @NonNull String schemaName, @NonNull String tableName) {
        if (datasourceId == null) {
            throw new NullPointerException("datasourceId is marked non-null but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        return new QualifiedName(datasourceId, catalogName, schemaName, tableName, null);
    }

    public static QualifiedName ofTable(@NonNull String datasourceId, @NonNull String schemaName, @NonNull String tableName) {
        if (datasourceId == null) {
            throw new NullPointerException("datasourceId is marked non-null but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        return new QualifiedName(datasourceId, schemaName, tableName, null);
    }

    public static QualifiedName ofTable(@NonNull QualifiedName partitionId) {
        if (partitionId == null) {
            throw new NullPointerException("partitionId is marked non-null but is null");
        }
        return new QualifiedName(partitionId.getDatasourceId(), partitionId.getCatalogName(), partitionId.getSchemaName(), partitionId.getTableName(), null);
    }

    public static QualifiedName ofPartition(@NonNull String datasourceId, String catalogName, @NonNull String schemaName, @NonNull String tableName, @NonNull String partitionName) {
        if (datasourceId == null) {
            throw new NullPointerException("datasourceId is marked non-null but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (partitionName == null) {
            throw new NullPointerException("partitionName is marked non-null but is null");
        }
        return new QualifiedName(datasourceId, catalogName, schemaName, tableName, partitionName);
    }

    public static QualifiedName ofPartition(@NonNull String datasourceId, @NonNull String schemaName, @NonNull String tableName, @NonNull String partitionName) {
        if (datasourceId == null) {
            throw new NullPointerException("datasourceId is marked non-null but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (partitionName == null) {
            throw new NullPointerException("partitionName is marked non-null but is null");
        }
        return new QualifiedName(datasourceId, schemaName, tableName, partitionName);
    }

    public static QualifiedName fromString(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        String name = s.trim();
        if (name.isEmpty()) {
            throw new IllegalArgumentException("passed in an empty definition name");
        }
        String[] parts = name.split("\\.", 4);
        if (parts.length < 2) {
            throw new IllegalArgumentException("Unable to convert '" + name + "' into a qualifiedDefinition");
        }
        String datasourceId = parts[0];
        String[] split = parts[1].split("-", 2);
        String catalogName = split.length > 1 ? split[0] : null;
        String schemaName = split.length > 1 ? split[1] : split[0];
        switch (parts.length) {
            case 2: {
                return QualifiedName.ofSchema(datasourceId, catalogName, schemaName);
            }
            case 3: {
                return QualifiedName.ofTable(datasourceId, catalogName, schemaName, parts[2]);
            }
            case 4: {
                return QualifiedName.ofPartition(datasourceId, catalogName, schemaName, parts[2], parts[3]);
            }
        }
        throw new IllegalArgumentException("Unable to convert '" + name + "' into a qualifiedDefinition");
    }

    private static String standardizeOptional(String value) {
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.datasourceId);
        if (this.catalogName != null && !this.catalogName.isEmpty()) {
            sb.append('.');
            sb.append(this.catalogName);
            if (this.schemaName != null && !this.schemaName.isEmpty()) {
                sb.append('-');
                sb.append(this.schemaName);
            }
        } else if (this.schemaName != null && !this.schemaName.isEmpty()) {
            sb.append('.');
            sb.append(this.schemaName);
        }
        if (this.tableName != null && !this.tableName.isEmpty()) {
            sb.append('.');
            sb.append(this.tableName);
        }
        if (this.partitionName != null && !this.partitionName.isEmpty()) {
            sb.append('.');
            sb.append(this.partitionName);
        }
        return sb.toString();
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public Type getType() {
        return this.type;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QualifiedName)) {
            return false;
        }
        QualifiedName other = (QualifiedName)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$datasourceId = this.getDatasourceId();
        String other$datasourceId = other.getDatasourceId();
        if (this$datasourceId == null ? other$datasourceId != null : !this$datasourceId.equals(other$datasourceId)) {
            return false;
        }
        String this$catalogName = this.getCatalogName();
        String other$catalogName = other.getCatalogName();
        if (this$catalogName == null ? other$catalogName != null : !this$catalogName.equals(other$catalogName)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$partitionName = this.getPartitionName();
        String other$partitionName = other.getPartitionName();
        if (this$partitionName == null ? other$partitionName != null : !this$partitionName.equals(other$partitionName)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QualifiedName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $datasourceId = this.getDatasourceId();
        result = result * 59 + ($datasourceId == null ? 43 : $datasourceId.hashCode());
        String $catalogName = this.getCatalogName();
        result = result * 59 + ($catalogName == null ? 43 : $catalogName.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $partitionName = this.getPartitionName();
        result = result * 59 + ($partitionName == null ? 43 : $partitionName.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public QualifiedName() {
    }

    public static enum Type {
        CATALOG,
        SCHEMA,
        TABLE,
        PARTITION;

    }
}

