/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.element.meta;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class Version
implements Serializable {
    private VersionType type;
    private String time;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");

    public static Version of(String version) {
        String[] split = version.split("_");
        return new Version(VersionType.valueOf(split[0]), split[1]);
    }

    public static Version of(String type, String time) {
        return new Version(VersionType.valueOf(type), time);
    }

    public static Version ofLatestBaseVersion() {
        return new Version(VersionType.BASE, LocalDateTime.now().format(FORMATTER));
    }

    public static Version ofLatestUploadVersion() {
        return new Version(VersionType.UPLOAD, LocalDateTime.now().format(FORMATTER));
    }

    public static Version ofLatestCustomVersion() {
        return new Version(VersionType.CUSTOM, LocalDateTime.now().format(FORMATTER));
    }

    public static Version ofLatestConvertVersion() {
        return new Version(VersionType.CONVERT, LocalDateTime.now().format(FORMATTER));
    }

    public static Version ofLatestMigrationVersion() {
        return new Version(VersionType.MIGRATION, LocalDateTime.now().format(FORMATTER));
    }

    public static Version ofLatestLineageVersion() {
        return new Version(VersionType.LINEAGE, LocalDateTime.now().format(FORMATTER));
    }

    public static boolean isBaseVersion(Version version) {
        return VersionType.BASE.equals((Object)version.getType()) || VersionType.UPLOAD.equals((Object)version.getType());
    }

    public String toString() {
        return this.type + "_" + this.time;
    }

    public Date versionDate() {
        String dateString = this.time.substring(0, 12);
        LocalDateTime localDateTime = LocalDateTime.parse(dateString, DateTimeFormatter.ofPattern("yyyyMMddHHmm"));
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public Version() {
    }

    public Version(VersionType type, String time) {
        this.type = type;
        this.time = time;
    }

    public VersionType getType() {
        return this.type;
    }

    public String getTime() {
        return this.time;
    }

    public void setType(VersionType type) {
        this.type = type;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (!other.canEqual(this)) {
            return false;
        }
        VersionType this$type = this.getType();
        VersionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$time = this.getTime();
        String other$time = other.getTime();
        return !(this$time == null ? other$time != null : !this$time.equals(other$time));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Version;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        VersionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : $time.hashCode());
        return result;
    }

    public static enum VersionType {
        BASE,
        UPLOAD,
        CUSTOM,
        CONVERT,
        MIGRATION,
        LINEAGE;

    }
}

