/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.dto.migration.enums;

import java.util.Arrays;
import java.util.List;

public enum ExecutionStatus {
    INIT("\u521d\u59cb\u6001"),
    WAITING("\u7b49\u5f85\u6267\u884c"),
    RUNNING("\u8fd0\u884c\u4e2d"),
    SUCCEED("\u8fd0\u884c\u5b8c\u6210"),
    FAILED("\u8fd0\u884c\u5931\u8d25"),
    KILLED("\u624b\u52a8\u53d6\u6d88"),
    NOT_SUPPORTED("\u4e0d\u652f\u6301");

    private String description;

    private ExecutionStatus(String description) {
        this.description = description;
    }

    public boolean isInitial() {
        return this == INIT;
    }

    public boolean isTerminated() {
        switch (this) {
            case SUCCEED: 
            case FAILED: 
            case KILLED: 
            case NOT_SUPPORTED: {
                return true;
            }
        }
        return false;
    }

    public boolean isSuccess() {
        switch (this) {
            case SUCCEED: 
            case NOT_SUPPORTED: {
                return true;
            }
        }
        return false;
    }

    public static List<String> notTerminated() {
        return Arrays.asList(INIT.name(), WAITING.name(), RUNNING.name());
    }

    public static List<String> terminatedStatus() {
        return Arrays.asList(SUCCEED.name(), FAILED.name(), KILLED.name(), NOT_SUPPORTED.name());
    }

    public static List<String> retryStatus() {
        return Arrays.asList(FAILED.name(), KILLED.name());
    }

    public static ExecutionStatus of(String value) {
        for (ExecutionStatus status : ExecutionStatus.values()) {
            if (!status.name().equalsIgnoreCase(value)) continue;
            return status;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

