/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.dto.migration;

import com.aliyun.migration.teleport.common.dto.migration.enums.TaskType;
import com.aliyun.migration.teleport.common.utils.TimeUtil;
import java.util.Optional;

public class BaseOverview {
    private TaskType taskType;
    private String errorMessage;
    private String createTime;
    private String startTime;
    private String endTime;
    private ExecStatus status;
    private ExecResult result;
    private Long executeDuration;
    private String executeDurationPretty;
    private Double progress;
    private Long totalTaskCount;
    private Long successTaskCount;
    private Long failedTaskCount;
    private String progressPretty;

    public void populate() {
        this.executeDuration = TimeUtil.between(this.startTime, this.endTime);
        this.executeDurationPretty = TimeUtil.durationFormat(this.executeDuration);
        long total = Optional.ofNullable(this.getTotalTaskCount()).orElse(0L);
        long success = Optional.ofNullable(this.getSuccessTaskCount()).orElse(0L);
        long fail = Optional.ofNullable(this.getFailedTaskCount()).orElse(0L);
        long completeTasks = success + fail;
        if (total != 0L) {
            this.status = completeTasks == total ? ExecStatus.FINISHED : (completeTasks == 0L ? ExecStatus.INIT : ExecStatus.RUNNING);
            this.result = fail > 0L ? (success > 0L ? ExecResult.PARTIAL_FAIL : ExecResult.ERROR) : (completeTasks == total ? ExecResult.SUCCESS : ExecResult.NO_RESULT);
        } else {
            this.result = ExecResult.NO_RESULT;
            this.status = ExecStatus.FINISHED;
        }
        this.progress = this.totalTaskCount == null || this.totalTaskCount == 0L ? Double.valueOf(1.0) : Double.valueOf((Optional.ofNullable(this.successTaskCount).orElse(0L) + Optional.ofNullable(this.failedTaskCount).orElse(0L)) / this.totalTaskCount);
        this.progressPretty = String.format("%.2f", this.progress * 100.0);
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public ExecStatus getStatus() {
        return this.status;
    }

    public ExecResult getResult() {
        return this.result;
    }

    public Long getExecuteDuration() {
        return this.executeDuration;
    }

    public String getExecuteDurationPretty() {
        return this.executeDurationPretty;
    }

    public Double getProgress() {
        return this.progress;
    }

    public Long getTotalTaskCount() {
        return this.totalTaskCount;
    }

    public Long getSuccessTaskCount() {
        return this.successTaskCount;
    }

    public Long getFailedTaskCount() {
        return this.failedTaskCount;
    }

    public String getProgressPretty() {
        return this.progressPretty;
    }

    public void setTaskType(TaskType taskType) {
        this.taskType = taskType;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setStatus(ExecStatus status) {
        this.status = status;
    }

    public void setResult(ExecResult result) {
        this.result = result;
    }

    public void setExecuteDuration(Long executeDuration) {
        this.executeDuration = executeDuration;
    }

    public void setExecuteDurationPretty(String executeDurationPretty) {
        this.executeDurationPretty = executeDurationPretty;
    }

    public void setProgress(Double progress) {
        this.progress = progress;
    }

    public void setTotalTaskCount(Long totalTaskCount) {
        this.totalTaskCount = totalTaskCount;
    }

    public void setSuccessTaskCount(Long successTaskCount) {
        this.successTaskCount = successTaskCount;
    }

    public void setFailedTaskCount(Long failedTaskCount) {
        this.failedTaskCount = failedTaskCount;
    }

    public void setProgressPretty(String progressPretty) {
        this.progressPretty = progressPretty;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseOverview)) {
            return false;
        }
        BaseOverview other = (BaseOverview)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$executeDuration = this.getExecuteDuration();
        Long other$executeDuration = other.getExecuteDuration();
        if (this$executeDuration == null ? other$executeDuration != null : !((Object)this$executeDuration).equals(other$executeDuration)) {
            return false;
        }
        Double this$progress = this.getProgress();
        Double other$progress = other.getProgress();
        if (this$progress == null ? other$progress != null : !((Object)this$progress).equals(other$progress)) {
            return false;
        }
        Long this$totalTaskCount = this.getTotalTaskCount();
        Long other$totalTaskCount = other.getTotalTaskCount();
        if (this$totalTaskCount == null ? other$totalTaskCount != null : !((Object)this$totalTaskCount).equals(other$totalTaskCount)) {
            return false;
        }
        Long this$successTaskCount = this.getSuccessTaskCount();
        Long other$successTaskCount = other.getSuccessTaskCount();
        if (this$successTaskCount == null ? other$successTaskCount != null : !((Object)this$successTaskCount).equals(other$successTaskCount)) {
            return false;
        }
        Long this$failedTaskCount = this.getFailedTaskCount();
        Long other$failedTaskCount = other.getFailedTaskCount();
        if (this$failedTaskCount == null ? other$failedTaskCount != null : !((Object)this$failedTaskCount).equals(other$failedTaskCount)) {
            return false;
        }
        TaskType this$taskType = this.getTaskType();
        TaskType other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)((Object)this$taskType)).equals((Object)other$taskType)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
            return false;
        }
        ExecStatus this$status = this.getStatus();
        ExecStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        ExecResult this$result = this.getResult();
        ExecResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)((Object)this$result)).equals((Object)other$result)) {
            return false;
        }
        String this$executeDurationPretty = this.getExecuteDurationPretty();
        String other$executeDurationPretty = other.getExecuteDurationPretty();
        if (this$executeDurationPretty == null ? other$executeDurationPretty != null : !this$executeDurationPretty.equals(other$executeDurationPretty)) {
            return false;
        }
        String this$progressPretty = this.getProgressPretty();
        String other$progressPretty = other.getProgressPretty();
        return !(this$progressPretty == null ? other$progressPretty != null : !this$progressPretty.equals(other$progressPretty));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseOverview;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $executeDuration = this.getExecuteDuration();
        result = result * 59 + ($executeDuration == null ? 43 : ((Object)$executeDuration).hashCode());
        Double $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : ((Object)$progress).hashCode());
        Long $totalTaskCount = this.getTotalTaskCount();
        result = result * 59 + ($totalTaskCount == null ? 43 : ((Object)$totalTaskCount).hashCode());
        Long $successTaskCount = this.getSuccessTaskCount();
        result = result * 59 + ($successTaskCount == null ? 43 : ((Object)$successTaskCount).hashCode());
        Long $failedTaskCount = this.getFailedTaskCount();
        result = result * 59 + ($failedTaskCount == null ? 43 : ((Object)$failedTaskCount).hashCode());
        TaskType $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)((Object)$taskType)).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        ExecStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        ExecResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)((Object)$result)).hashCode());
        String $executeDurationPretty = this.getExecuteDurationPretty();
        result = result * 59 + ($executeDurationPretty == null ? 43 : $executeDurationPretty.hashCode());
        String $progressPretty = this.getProgressPretty();
        result = result * 59 + ($progressPretty == null ? 43 : $progressPretty.hashCode());
        return result;
    }

    public String toString() {
        return "BaseOverview(taskType=" + this.getTaskType() + ", errorMessage=" + this.getErrorMessage() + ", createTime=" + this.getCreateTime() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", status=" + this.getStatus() + ", result=" + this.getResult() + ", executeDuration=" + this.getExecuteDuration() + ", executeDurationPretty=" + this.getExecuteDurationPretty() + ", progress=" + this.getProgress() + ", totalTaskCount=" + this.getTotalTaskCount() + ", successTaskCount=" + this.getSuccessTaskCount() + ", failedTaskCount=" + this.getFailedTaskCount() + ", progressPretty=" + this.getProgressPretty() + ")";
    }

    public static enum ExecStatus {
        FINISHED,
        RUNNING,
        INIT;

    }

    public static enum ExecResult {
        SUCCESS,
        PARTIAL_FAIL,
        ERROR,
        NO_RESULT;

    }
}

