/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.dto.meta.condition;

import com.aliyun.migration.teleport.common.dto.migration.enums.MatchType;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MetaDiscoveryCondition {
    private MatchType type;
    private String catalogName;
    private String schemaName;
    private String tableNamePattern;
    private String partitionFilter;
    private static Pattern TABLE_NAME = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");

    public boolean isCatalogCondition() {
        return StringUtils.isNotBlank((CharSequence)this.catalogName) && StringUtils.isBlank((CharSequence)this.tableNamePattern) && StringUtils.isBlank((CharSequence)this.partitionFilter);
    }

    public boolean isSchemaCondition() {
        return StringUtils.isNotBlank((CharSequence)this.schemaName) && StringUtils.isBlank((CharSequence)this.tableNamePattern) && StringUtils.isBlank((CharSequence)this.partitionFilter);
    }

    public boolean isTableCondition() {
        return StringUtils.isNotBlank((CharSequence)this.schemaName) && StringUtils.isNotBlank((CharSequence)this.tableNamePattern) && StringUtils.isBlank((CharSequence)this.partitionFilter);
    }

    public boolean isPartitionCondition() {
        return StringUtils.isNotBlank((CharSequence)this.schemaName) && StringUtils.isNotBlank((CharSequence)this.tableNamePattern) && StringUtils.isNotBlank((CharSequence)this.partitionFilter);
    }

    public boolean isWhiteList() {
        return MatchType.WHITE_LIST.equals((Object)this.type);
    }

    public boolean isBlackList() {
        return MatchType.BLACK_LIST.equals((Object)this.type);
    }

    public boolean isTableName() {
        if (StringUtils.isBlank((CharSequence)this.tableNamePattern)) {
            return false;
        }
        return TABLE_NAME.matcher(this.tableNamePattern).matches();
    }

    public MatchType getType() {
        return this.type;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public String getPartitionFilter() {
        return this.partitionFilter;
    }

    public void setType(MatchType type) {
        this.type = type;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setPartitionFilter(String partitionFilter) {
        this.partitionFilter = partitionFilter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaDiscoveryCondition)) {
            return false;
        }
        MetaDiscoveryCondition other = (MetaDiscoveryCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MatchType this$type = this.getType();
        MatchType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$catalogName = this.getCatalogName();
        String other$catalogName = other.getCatalogName();
        if (this$catalogName == null ? other$catalogName != null : !this$catalogName.equals(other$catalogName)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableNamePattern = this.getTableNamePattern();
        String other$tableNamePattern = other.getTableNamePattern();
        if (this$tableNamePattern == null ? other$tableNamePattern != null : !this$tableNamePattern.equals(other$tableNamePattern)) {
            return false;
        }
        String this$partitionFilter = this.getPartitionFilter();
        String other$partitionFilter = other.getPartitionFilter();
        return !(this$partitionFilter == null ? other$partitionFilter != null : !this$partitionFilter.equals(other$partitionFilter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaDiscoveryCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MatchType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $catalogName = this.getCatalogName();
        result = result * 59 + ($catalogName == null ? 43 : $catalogName.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableNamePattern = this.getTableNamePattern();
        result = result * 59 + ($tableNamePattern == null ? 43 : $tableNamePattern.hashCode());
        String $partitionFilter = this.getPartitionFilter();
        result = result * 59 + ($partitionFilter == null ? 43 : $partitionFilter.hashCode());
        return result;
    }

    public String toString() {
        return "MetaDiscoveryCondition(type=" + this.getType() + ", catalogName=" + this.getCatalogName() + ", schemaName=" + this.getSchemaName() + ", tableNamePattern=" + this.getTableNamePattern() + ", partitionFilter=" + this.getPartitionFilter() + ")";
    }

    public MetaDiscoveryCondition() {
    }

    public MetaDiscoveryCondition(MatchType type, String catalogName, String schemaName, String tableNamePattern, String partitionFilter) {
        this.type = type;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableNamePattern = tableNamePattern;
        this.partitionFilter = partitionFilter;
    }
}

