/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.common.dto.discovery.data;

import com.aliyun.migration.teleport.common.dto.meta.data.MetaVersion;
import com.aliyun.migration.teleport.common.dto.meta.enums.DiscoveryScope;
import com.aliyun.migration.teleport.common.dto.meta.enums.DiscoveryType;
import com.aliyun.migration.teleport.common.dto.meta.enums.JobStatus;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DiscoveryJobDTO
implements Serializable {
    private Long jobId;
    private Long taskId;
    private String tenantId;
    private MetaVersion metaVersion;
    private JobStatus jobStatus;
    private DiscoveryType discoveryType;
    private String conditions;
    private String pluginId;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private List<String> filePath;
    private String errorCode;
    private String errorMessage;
    private List<DiscoveryScope> discoveryScope;

    public static DiscoveryJobDTO createCronJob(Long taskId, Long datasourceId, String conditions, DiscoveryType discoveryType, String pluginId) {
        DiscoveryJobDTO jobDTO = new DiscoveryJobDTO();
        jobDTO.setTaskId(taskId);
        jobDTO.setMetaVersion(MetaVersion.ofLatestBaseVersion(datasourceId));
        jobDTO.setJobStatus(JobStatus.INIT);
        if (StringUtils.isNotBlank((CharSequence)conditions)) {
            jobDTO.setConditions(conditions);
        }
        jobDTO.setDiscoveryType(discoveryType);
        jobDTO.setPluginId(pluginId);
        return jobDTO;
    }

    public static DiscoveryJobDTO createOnceJob(Long taskId, Long datasourceId, String conditions, DiscoveryType discoveryType, String pluginId) {
        DiscoveryJobDTO jobDTO = new DiscoveryJobDTO();
        jobDTO.setTaskId(taskId);
        jobDTO.setMetaVersion(MetaVersion.ofLatestCustomVersion(datasourceId));
        jobDTO.setJobStatus(JobStatus.INIT);
        if (StringUtils.isNotBlank((CharSequence)conditions)) {
            jobDTO.setConditions(conditions);
        }
        jobDTO.setDiscoveryType(discoveryType);
        jobDTO.setPluginId(pluginId);
        return jobDTO;
    }

    public static DiscoveryJobDTO createFileParserJob(Long taskId, Long datasourceId, List<String> filePath, String conditions, DiscoveryType discoveryType, String pluginId) {
        DiscoveryJobDTO jobDTO = new DiscoveryJobDTO();
        jobDTO.setTaskId(taskId);
        jobDTO.setMetaVersion(MetaVersion.ofLatestUploadVersion(datasourceId));
        jobDTO.setJobStatus(JobStatus.INIT);
        if (filePath != null && !filePath.isEmpty()) {
            jobDTO.setFilePath(filePath);
        }
        if (StringUtils.isNotBlank((CharSequence)conditions)) {
            jobDTO.setConditions(conditions);
        }
        jobDTO.setDiscoveryType(discoveryType);
        jobDTO.setPluginId(pluginId);
        return jobDTO;
    }

    public static DiscoveryJobDTO createMigrationJob(Long taskId, Long datasourceId, String conditions, DiscoveryType discoveryType, String pluginId, List<DiscoveryScope> discoveryScope) {
        DiscoveryJobDTO jobDTO = new DiscoveryJobDTO();
        jobDTO.setTaskId(taskId);
        jobDTO.setMetaVersion(MetaVersion.ofLatestMigrationVersion(datasourceId));
        jobDTO.setJobStatus(JobStatus.INIT);
        if (StringUtils.isNotBlank((CharSequence)conditions)) {
            jobDTO.setConditions(conditions);
        }
        jobDTO.setDiscoveryType(discoveryType);
        jobDTO.setPluginId(pluginId);
        jobDTO.setDiscoveryScope(discoveryScope);
        return jobDTO;
    }

    public static DiscoveryJobDTO createCronJob(Long taskId, Long datasourceId, String conditions, DiscoveryType discoveryType, String pluginId, String tenantId) {
        DiscoveryJobDTO jobDTO = DiscoveryJobDTO.createCronJob(taskId, datasourceId, conditions, discoveryType, pluginId);
        jobDTO.setTenantId(tenantId);
        return jobDTO;
    }

    public static DiscoveryJobDTO createCronJob(Long taskId, Long datasourceId, String conditions, DiscoveryType discoveryType, String pluginId, String tenantId, List<DiscoveryScope> discoveryScope) {
        DiscoveryJobDTO jobDTO = DiscoveryJobDTO.createCronJob(taskId, datasourceId, conditions, discoveryType, pluginId);
        jobDTO.setTenantId(tenantId);
        jobDTO.setDiscoveryScope(discoveryScope);
        return jobDTO;
    }

    public static DiscoveryJobDTO createOnceJob(Long taskId, Long datasourceId, String conditions, DiscoveryType discoveryType, String pluginId, String tenantId) {
        DiscoveryJobDTO jobDTO = DiscoveryJobDTO.createOnceJob(taskId, datasourceId, conditions, discoveryType, pluginId);
        jobDTO.setTenantId(tenantId);
        return jobDTO;
    }

    public static DiscoveryJobDTO createOnceJob(Long taskId, Long datasourceId, String conditions, DiscoveryType discoveryType, String pluginId, String tenantId, List<DiscoveryScope> discoveryScope) {
        DiscoveryJobDTO jobDTO = DiscoveryJobDTO.createOnceJob(taskId, datasourceId, conditions, discoveryType, pluginId);
        jobDTO.setTenantId(tenantId);
        jobDTO.setDiscoveryScope(discoveryScope);
        return jobDTO;
    }

    public static DiscoveryJobDTO createFileParserJob(Long taskId, Long datasourceId, List<String> filePath, String conditions, DiscoveryType discoveryType, String pluginId, String tenantId) {
        DiscoveryJobDTO jobDTO = DiscoveryJobDTO.createFileParserJob(taskId, datasourceId, filePath, conditions, discoveryType, pluginId);
        jobDTO.setTenantId(tenantId);
        return jobDTO;
    }

    public static DiscoveryJobDTO createFileParserJob(Long taskId, Long datasourceId, List<String> filePath, String conditions, DiscoveryType discoveryType, String pluginId, String tenantId, List<DiscoveryScope> discoveryScope) {
        DiscoveryJobDTO jobDTO = DiscoveryJobDTO.createFileParserJob(taskId, datasourceId, filePath, conditions, discoveryType, pluginId);
        jobDTO.setTenantId(tenantId);
        jobDTO.setDiscoveryScope(discoveryScope);
        return jobDTO;
    }

    public static DiscoveryJobDTO createMigrationJob(Long taskId, Long datasourceId, String conditions, DiscoveryType discoveryType, String pluginId, List<DiscoveryScope> discoveryScope, String tenantId) {
        DiscoveryJobDTO jobDTO = DiscoveryJobDTO.createMigrationJob(taskId, datasourceId, conditions, discoveryType, pluginId, discoveryScope);
        jobDTO.setTenantId(tenantId);
        return jobDTO;
    }

    public static DiscoveryJobDTO createLineageJob(Long taskId, Long datasourceId, String conditions, DiscoveryType discoveryType, String pluginId, List<DiscoveryScope> discoveryScope, String tenantId) {
        DiscoveryJobDTO jobDTO = new DiscoveryJobDTO();
        jobDTO.setTaskId(taskId);
        jobDTO.setMetaVersion(MetaVersion.ofLatestLineageVersion(datasourceId));
        jobDTO.setJobStatus(JobStatus.INIT);
        if (StringUtils.isNotBlank((CharSequence)conditions)) {
            jobDTO.setConditions(conditions);
        }
        jobDTO.setDiscoveryType(discoveryType);
        jobDTO.setPluginId(pluginId);
        jobDTO.setDiscoveryScope(discoveryScope);
        jobDTO.setTenantId(tenantId);
        return jobDTO;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public MetaVersion getMetaVersion() {
        return this.metaVersion;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public DiscoveryType getDiscoveryType() {
        return this.discoveryType;
    }

    public String getConditions() {
        return this.conditions;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public List<String> getFilePath() {
        return this.filePath;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<DiscoveryScope> getDiscoveryScope() {
        return this.discoveryScope;
    }

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setMetaVersion(MetaVersion metaVersion) {
        this.metaVersion = metaVersion;
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public void setDiscoveryType(DiscoveryType discoveryType) {
        this.discoveryType = discoveryType;
    }

    public void setConditions(String conditions) {
        this.conditions = conditions;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public void setFilePath(List<String> filePath) {
        this.filePath = filePath;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setDiscoveryScope(List<DiscoveryScope> discoveryScope) {
        this.discoveryScope = discoveryScope;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiscoveryJobDTO)) {
            return false;
        }
        DiscoveryJobDTO other = (DiscoveryJobDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$jobId = this.getJobId();
        Long other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
            return false;
        }
        Long this$taskId = this.getTaskId();
        Long other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        MetaVersion this$metaVersion = this.getMetaVersion();
        MetaVersion other$metaVersion = other.getMetaVersion();
        if (this$metaVersion == null ? other$metaVersion != null : !((Object)this$metaVersion).equals(other$metaVersion)) {
            return false;
        }
        JobStatus this$jobStatus = this.getJobStatus();
        JobStatus other$jobStatus = other.getJobStatus();
        if (this$jobStatus == null ? other$jobStatus != null : !this$jobStatus.equals(other$jobStatus)) {
            return false;
        }
        DiscoveryType this$discoveryType = this.getDiscoveryType();
        DiscoveryType other$discoveryType = other.getDiscoveryType();
        if (this$discoveryType == null ? other$discoveryType != null : !((Object)((Object)this$discoveryType)).equals((Object)other$discoveryType)) {
            return false;
        }
        String this$conditions = this.getConditions();
        String other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !this$conditions.equals(other$conditions)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalDateTime this$endTime = this.getEndTime();
        LocalDateTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        List<String> this$filePath = this.getFilePath();
        List<String> other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !((Object)this$filePath).equals(other$filePath)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        List<DiscoveryScope> this$discoveryScope = this.getDiscoveryScope();
        List<DiscoveryScope> other$discoveryScope = other.getDiscoveryScope();
        return !(this$discoveryScope == null ? other$discoveryScope != null : !((Object)this$discoveryScope).equals(other$discoveryScope));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DiscoveryJobDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
        Long $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        MetaVersion $metaVersion = this.getMetaVersion();
        result = result * 59 + ($metaVersion == null ? 43 : ((Object)$metaVersion).hashCode());
        JobStatus $jobStatus = this.getJobStatus();
        result = result * 59 + ($jobStatus == null ? 43 : $jobStatus.hashCode());
        DiscoveryType $discoveryType = this.getDiscoveryType();
        result = result * 59 + ($discoveryType == null ? 43 : ((Object)((Object)$discoveryType)).hashCode());
        String $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : $conditions.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalDateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        List<String> $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : ((Object)$filePath).hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        List<DiscoveryScope> $discoveryScope = this.getDiscoveryScope();
        result = result * 59 + ($discoveryScope == null ? 43 : ((Object)$discoveryScope).hashCode());
        return result;
    }

    public String toString() {
        return "DiscoveryJobDTO(jobId=" + this.getJobId() + ", taskId=" + this.getTaskId() + ", tenantId=" + this.getTenantId() + ", metaVersion=" + this.getMetaVersion() + ", jobStatus=" + this.getJobStatus() + ", discoveryType=" + this.getDiscoveryType() + ", conditions=" + this.getConditions() + ", pluginId=" + this.getPluginId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", filePath=" + this.getFilePath() + ", errorCode=" + this.getErrorCode() + ", errorMessage=" + this.getErrorMessage() + ", discoveryScope=" + this.getDiscoveryScope() + ")";
    }
}

