/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dms.utils;

import com.aliyun.dms_enterprise20181101.models.GetTaskFlowGraphRequest;
import com.aliyun.dms_enterprise20181101.models.GetTaskFlowNotificationRequest;
import com.aliyun.dms_enterprise20181101.models.GetTaskFlowNotificationResponse;
import com.aliyun.dms_enterprise20181101.models.GetTaskFlowNotificationResponseBody;
import com.aliyun.dms_enterprise20181101.models.GetTaskRequest;
import com.aliyun.dms_enterprise20181101.models.GetTaskResponse;
import com.aliyun.dms_enterprise20181101.models.ListDatabasesRequest;
import com.aliyun.dms_enterprise20181101.models.ListDatabasesResponse;
import com.aliyun.dms_enterprise20181101.models.ListDatabasesResponseBody;
import com.aliyun.dms_enterprise20181101.models.ListInstancesRequest;
import com.aliyun.dms_enterprise20181101.models.ListInstancesResponse;
import com.aliyun.dms_enterprise20181101.models.ListInstancesResponseBody;
import com.aliyun.dms_enterprise20181101.models.ListScenariosRequest;
import com.aliyun.dms_enterprise20181101.models.ListScenariosResponse;
import com.aliyun.dms_enterprise20181101.models.ListScenariosResponseBody;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowConstantsRequest;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowConstantsResponse;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowConstantsResponseBody;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowCooperatorsRequest;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowCooperatorsResponse;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowCooperatorsResponseBody;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowRequest;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowResponse;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowResponseBody;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowTimeVariablesRequest;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowTimeVariablesResponse;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowTimeVariablesResponseBody;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowsByPageRequest;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowsByPageResponse;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowsByPageResponseBody;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.workflow.migration.common.utils.PageUtil;
import com.aliyun.migration.workflow.migration.dms.utils.temp.Client;
import com.aliyun.migration.workflow.migration.dms.utils.temp.entity.GetTaskFlowGraphResponse;
import com.aliyun.migration.workflow.migration.dms.utils.temp.entity.GetTaskFlowGraphResponseBody;
import com.aliyun.teaopenapi.models.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmsClient {
    private static final Logger log = LoggerFactory.getLogger(DmsClient.class);
    Client client;

    public DmsClient(String ak, String sk, String endPoint) throws Exception {
        Config config = new Config().setAccessKeyId(ak).setAccessKeySecret(sk).setEndpoint(endPoint);
        this.client = new Client(config);
    }

    public Map<String, String> ListScenarios() {
        ListScenariosRequest request = new ListScenariosRequest();
        log.info("\u6b63\u5728\u83b7\u53d6DMS\u4e1a\u52a1\u573a\u666f\u5217\u8868\uff08\u9664\u9ed8\u8ba4\u4e1a\u52a1\u573a\u666f\u5916\uff09");
        try {
            ListScenariosResponse response = this.client.listScenarios(request);
            HashMap<String, String> scenarioMap = new HashMap<String, String>();
            if (response.getBody() != null && CollectionUtils.isNotEmpty((Collection)response.getBody().getScenarioList())) {
                for (ListScenariosResponseBody.ListScenariosResponseBodyScenarioList scenario : response.getBody().getScenarioList()) {
                    scenarioMap.put(scenario.getId().toString(), scenario.getScenarioName());
                    log.info("\u65b0\u83b7\u53d6\u5230\u4e1a\u52a1\u573a\u666f\uff1a" + scenario.getId() + " - " + scenario.getScenarioName());
                }
            }
            return scenarioMap;
        }
        catch (Exception e) {
            log.error("ListScenarios error", (Throwable)e);
            return null;
        }
    }

    public List<ListTaskFlowResponseBody.ListTaskFlowResponseBodyTaskFlowListTaskFlow> ListTaskFlow() {
        ListTaskFlowRequest request = new ListTaskFlowRequest();
        try {
            ListTaskFlowResponse response = this.client.listTaskFlow(request);
            return response.getBody().getTaskFlowList().getTaskFlow();
        }
        catch (Exception e) {
            log.error("ListTaskFlow error", (Throwable)e);
            return new ArrayList<ListTaskFlowResponseBody.ListTaskFlowResponseBodyTaskFlowListTaskFlow>();
        }
    }

    public List<ListTaskFlowsByPageResponseBody.ListTaskFlowsByPageResponseBodyTaskFlowListTaskFlow> ListTaskFlowDetail() {
        log.info("\u6b63\u5728\u5206\u9875\u83b7\u53d6DMS\u5de5\u4f5c\u6d41\u5217\u8868");
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(20);
        paginator.setPageNum(1);
        ArrayList<ListTaskFlowsByPageResponseBody.ListTaskFlowsByPageResponseBodyTaskFlowListTaskFlow> result = new ArrayList<ListTaskFlowsByPageResponseBody.ListTaskFlowsByPageResponseBodyTaskFlowListTaskFlow>();
        try {
            PageUtil.doPaginate((PageUtil.Paginator)paginator, p -> {
                try {
                    ListTaskFlowsByPageRequest request = new ListTaskFlowsByPageRequest();
                    request.setPageIndex(Integer.valueOf(p.getPageNum()));
                    request.setPageSize(Integer.valueOf(p.getPageSize()));
                    ListTaskFlowsByPageResponse response = this.client.listTaskFlowsByPage(request);
                    result.addAll(response.getBody().getTaskFlowList().getTaskFlow());
                    Integer count = response.getBody().getTaskFlowList().getTaskFlow().size();
                    PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                    paginateResult.setPageNum(p.getPageNum());
                    paginateResult.setPageSize(p.getPageSize());
                    paginateResult.setData(response.getBody().getTaskFlowList().getTaskFlow());
                    paginateResult.setTotalCount(count.intValue());
                    log.info("\u5df2\u83b7\u53d6\u6570\u91cf..." + result.size());
                    return paginateResult;
                }
                catch (Exception e) {
                    throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.DMS_CLIENT_ERROR, (String)e.getMessage());
                }
            });
            log.info("\u83b7\u53d6\u5b8c\u6210\uff0c\u603b\u8ba1\u6570\u91cf" + result.size());
        }
        catch (InterruptedException e) {
            log.error("listTaskFlowDetail error", (Throwable)e);
        }
        return result;
    }

    public GetTaskFlowGraphResponseBody GetTaskFlowGraph(Long taskFlowId) {
        GetTaskFlowGraphRequest request = new GetTaskFlowGraphRequest();
        request.setDagId(taskFlowId);
        try {
            GetTaskFlowGraphResponse response = this.client.getTaskFlowGraph(request);
            return response.getBody();
        }
        catch (Exception e) {
            log.error("GetTaskFlowGraph error", (Throwable)e);
            return null;
        }
    }

    public List<ListTaskFlowConstantsResponseBody.ListTaskFlowConstantsResponseBodyDagConstantsDagConstant> ListTaskFlowConstants(Long taskFlowId) {
        ListTaskFlowConstantsRequest request = new ListTaskFlowConstantsRequest();
        request.setDagId(taskFlowId);
        try {
            ListTaskFlowConstantsResponse response = this.client.listTaskFlowConstants(request);
            if (response.getBody().getDagConstants() == null) {
                return null;
            }
            return response.getBody().getDagConstants().getDagConstant();
        }
        catch (Exception e) {
            log.error("ListTaskFlowConstants error", (Throwable)e);
            return null;
        }
    }

    public List<ListTaskFlowTimeVariablesResponseBody.ListTaskFlowTimeVariablesResponseBodyTimeVariablesTimeVariable> ListTaskFlowTimeVariables(Long taskFlowId) {
        ListTaskFlowTimeVariablesRequest request = new ListTaskFlowTimeVariablesRequest();
        request.setDagId(taskFlowId);
        try {
            ListTaskFlowTimeVariablesResponse response = this.client.listTaskFlowTimeVariables(request);
            if (response.getBody().getTimeVariables() == null) {
                return null;
            }
            return response.getBody().getTimeVariables().getTimeVariable();
        }
        catch (Exception e) {
            log.error("ListTaskFlowTimeVariables error", (Throwable)e);
            return null;
        }
    }

    public List<ListTaskFlowCooperatorsResponseBody.ListTaskFlowCooperatorsResponseBodyCooperatorListCooperator> ListTaskFlowCooperators(long taskFlowId) {
        ListTaskFlowCooperatorsRequest request = new ListTaskFlowCooperatorsRequest();
        request.setDagId(Long.valueOf(taskFlowId));
        try {
            ListTaskFlowCooperatorsResponse response = this.client.listTaskFlowCooperators(request);
            if (response.getBody().getCooperatorList() == null) {
                return null;
            }
            return response.getBody().getCooperatorList().getCooperator();
        }
        catch (Exception e) {
            log.error("UpdateTaskFlowCooperators error", (Throwable)e);
            return null;
        }
    }

    public GetTaskFlowNotificationResponseBody.GetTaskFlowNotificationResponseBodyNotification GetTaskFlowNotification(long taskFlowId) {
        GetTaskFlowNotificationRequest request = new GetTaskFlowNotificationRequest();
        request.setDagId(Long.valueOf(taskFlowId));
        try {
            GetTaskFlowNotificationResponse response = this.client.getTaskFlowNotification(request);
            if (response.getBody().getNotification() == null) {
                return null;
            }
            return response.getBody().getNotification();
        }
        catch (Exception e) {
            log.error("GetTaskFlowNotification error", (Throwable)e);
            return null;
        }
    }

    public List<ListInstancesResponseBody.ListInstancesResponseBodyInstanceListInstance> ListDatasourceInstance() {
        log.info("\u6b63\u5728\u5206\u9875\u83b7\u53d6DMS\u6570\u636e\u6e90\u5217\u8868");
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(20);
        paginator.setPageNum(1);
        ArrayList<ListInstancesResponseBody.ListInstancesResponseBodyInstanceListInstance> result = new ArrayList<ListInstancesResponseBody.ListInstancesResponseBodyInstanceListInstance>();
        try {
            PageUtil.doPaginate((PageUtil.Paginator)paginator, p -> {
                try {
                    ListInstancesRequest request = new ListInstancesRequest();
                    request.setPageNumber(Integer.valueOf(p.getPageNum()));
                    request.setPageSize(Integer.valueOf(p.getPageSize()));
                    ListInstancesResponse response = this.client.listInstances(request);
                    result.addAll(response.getBody().getInstanceList().getInstance());
                    Integer count = response.getBody().getInstanceList().getInstance().size();
                    PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                    paginateResult.setPageNum(p.getPageNum());
                    paginateResult.setPageSize(p.getPageSize());
                    paginateResult.setData(response.getBody().getInstanceList().getInstance());
                    paginateResult.setTotalCount(count.intValue());
                    log.info("\u5df2\u83b7\u53d6\u6570\u91cf..." + result.size());
                    return paginateResult;
                }
                catch (Exception e) {
                    throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.DMS_CLIENT_ERROR, (String)e.getMessage());
                }
            });
        }
        catch (InterruptedException e) {
            log.error("listInstance error", (Throwable)e);
        }
        log.info("\u83b7\u53d6\u5b8c\u6210\uff0c\u603b\u8ba1\u6570\u91cf" + result.size());
        return result;
    }

    public Map<String, String> ListDatabases(String instanceId) {
        PageUtil.Paginator paginator = new PageUtil.Paginator();
        paginator.setPageSize(20);
        paginator.setPageNum(1);
        HashMap<String, String> schemaMap = new HashMap<String, String>();
        try {
            PageUtil.doPaginate((PageUtil.Paginator)paginator, p -> {
                try {
                    ListDatabasesRequest request = new ListDatabasesRequest();
                    request.setPageNumber(Integer.valueOf(p.getPageNum()));
                    request.setPageSize(Integer.valueOf(p.getPageSize()));
                    request.setInstanceId(instanceId);
                    ListDatabasesResponse response = this.client.listDatabases(request);
                    HashMap<String, String> pageResult = new HashMap<String, String>();
                    if (response.getBody() != null && response.getBody().getDatabaseList() != null && CollectionUtils.isNotEmpty((Collection)response.getBody().getDatabaseList().getDatabase())) {
                        for (ListDatabasesResponseBody.ListDatabasesResponseBodyDatabaseListDatabase database : response.getBody().getDatabaseList().getDatabase()) {
                            pageResult.put(database.getDatabaseId(), database.getSchemaName());
                        }
                    }
                    schemaMap.putAll(pageResult);
                    Integer count = pageResult.keySet().size();
                    PageUtil.PaginateResult paginateResult = new PageUtil.PaginateResult();
                    paginateResult.setPageNum(p.getPageNum());
                    paginateResult.setPageSize(p.getPageSize());
                    paginateResult.setData(pageResult.keySet().stream().toList());
                    paginateResult.setTotalCount(count.intValue());
                    return paginateResult;
                }
                catch (Exception e) {
                    throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.DMS_CLIENT_ERROR, (String)e.getMessage());
                }
            });
        }
        catch (InterruptedException e) {
            log.error("listInstance error", (Throwable)e);
        }
        return schemaMap;
    }

    public String GetTaskContent(Long nodeId) {
        GetTaskRequest request = new GetTaskRequest();
        request.setNodeId(nodeId);
        try {
            GetTaskResponse response = this.client.getTask(request);
            return response.getBody().getTask().getNodeContent();
        }
        catch (Exception e) {
            log.error("GetTaskContent error", (Throwable)e);
            return null;
        }
    }
}

