/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dms.handle;

import com.alibaba.cola.dto.Response;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dms_enterprise20181101.models.GetTaskFlowNotificationResponseBody;
import com.aliyun.dms_enterprise20181101.models.ListInstancesResponseBody;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowConstantsResponseBody;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowCooperatorsResponseBody;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowResponseBody;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowTimeVariablesResponseBody;
import com.aliyun.dms_enterprise20181101.models.ListTaskFlowsByPageResponseBody;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.common.utils.ZipFileUtil;
import com.aliyun.migration.workflow.migration.dms.domain.DmsDatasource;
import com.aliyun.migration.workflow.migration.dms.domain.DmsWorkflow;
import com.aliyun.migration.workflow.migration.dms.handle.AbstractDmsHandler;
import com.aliyun.migration.workflow.migration.dms.handle.DmsFileHandler;
import com.aliyun.migration.workflow.migration.dms.utils.DmsClient;
import com.aliyun.migration.workflow.migration.dms.utils.temp.entity.GetTaskFlowGraphResponseBody;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmsOpenapiHandler
extends AbstractDmsHandler {
    private static final Logger log = LoggerFactory.getLogger(DmsOpenapiHandler.class);
    private DmsClient dmsClient;
    private List<DmsWorkflow> dmsWorkflows = new ArrayList<DmsWorkflow>();
    private List<DmsDatasource> datasources = new ArrayList<DmsDatasource>();
    private String savePath;

    public DmsOpenapiHandler(TaskContext taskContext) {
        super.setTaskContext(taskContext);
        Datasource schedulerDatasource = taskContext.getReaderDatasource();
        Map datasourceProperties = schedulerDatasource.getProperties();
        String ak = System.getenv("LHM_DW_AK");
        String sk = System.getenv("LHM_DW_SK");
        if (StringUtils.isBlank((CharSequence)ak)) {
            ak = (String)datasourceProperties.get("ak");
        }
        if (StringUtils.isBlank((CharSequence)sk)) {
            sk = (String)datasourceProperties.get("sk");
        }
        String endpoint = (String)datasourceProperties.get("endpoint");
        try {
            this.dmsClient = new DmsClient(ak, sk, endpoint);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.savePath = taskContext.getSourceFilePackage();
    }

    @Override
    public Response preCheck() {
        try {
            List<ListTaskFlowResponseBody.ListTaskFlowResponseBodyTaskFlowListTaskFlow> listTaskFlowResponse = this.dmsClient.ListTaskFlow();
            if (CollectionUtils.isEmpty(listTaskFlowResponse)) {
                return Response.buildFailure((String)BwmServiceErrorCode.PRE_CHECK_ERROR.getCode(), (String)"not.find.the.taskflows");
            }
        }
        catch (Exception e) {
            log.error("detect.dms.error", (Throwable)e);
            return Response.buildFailure((String)BwmServiceErrorCode.PRE_CHECK_ERROR.getCode(), (String)"detect.dms.error");
        }
        return Response.buildSuccess();
    }

    @Override
    public WorkflowProjectPackage read() {
        log.info("\u5728\u7ebf\u6a21\u5f0f\uff0c\u5f00\u59cb\u83b7\u53d6DMS\u4efb\u52a1\u7f16\u6392");
        this.getDatasourceFromApi();
        this.getInfoFromApi();
        log.info("\u5b58\u50a8\u539f\u59cb\u4fe1\u606f\u5230\u672c\u5730\uff0c{}", (Object)this.savePath);
        this.exportApiOrginalResponseToFile();
        DmsFileHandler dmsFileHandler = new DmsFileHandler(this.taskContext);
        dmsFileHandler.preCheck();
        return dmsFileHandler.read();
    }

    public void getDatasourceFromApi() {
        log.info("\u5f00\u59cb\u83b7\u53d6DMS\u6570\u636e\u6e90");
        List<ListInstancesResponseBody.ListInstancesResponseBodyInstanceListInstance> instances = this.dmsClient.ListDatasourceInstance();
        if (CollectionUtils.isNotEmpty(instances)) {
            for (ListInstancesResponseBody.ListInstancesResponseBodyInstanceListInstance instance : instances) {
                String instanceId = instance.getInstanceId();
                Map<String, String> schemaMap = this.dmsClient.ListDatabases(instanceId);
                DmsDatasource dmsDatasource = new DmsDatasource(instance, schemaMap);
                this.datasources.add(dmsDatasource);
            }
        }
    }

    public void getInfoFromApi() {
        List<ListTaskFlowsByPageResponseBody.ListTaskFlowsByPageResponseBodyTaskFlowListTaskFlow> flows;
        this.dmsWorkflows = new ArrayList<DmsWorkflow>();
        Map<String, String> scenarios = this.dmsClient.ListScenarios();
        List<ListTaskFlowResponseBody.ListTaskFlowResponseBodyTaskFlowListTaskFlow> taskFlowOverviews = this.dmsClient.ListTaskFlow();
        HashMap<String, ListTaskFlowResponseBody.ListTaskFlowResponseBodyTaskFlowListTaskFlow> taskFlowMap = new HashMap<String, ListTaskFlowResponseBody.ListTaskFlowResponseBodyTaskFlowListTaskFlow>();
        if (CollectionUtils.isNotEmpty(taskFlowOverviews)) {
            for (ListTaskFlowResponseBody.ListTaskFlowResponseBodyTaskFlowListTaskFlow taskFlowOverview : taskFlowOverviews) {
                taskFlowMap.put(taskFlowOverview.getId().toString(), taskFlowOverview);
            }
        }
        if (CollectionUtils.isNotEmpty(flows = this.dmsClient.ListTaskFlowDetail())) {
            log.info("\u5f00\u59cb\u9010\u4e2a\u83b7\u53d6DMS\u5de5\u4f5c\u6d41\u8be6\u60c5");
            int count = 1;
            for (ListTaskFlowsByPageResponseBody.ListTaskFlowsByPageResponseBodyTaskFlowListTaskFlow flow : flows) {
                log.info("\u6b63\u5728\u83b7\u53d6\uff1a{}\uff08{}/{}\uff09", new Object[]{flow.getDagName(), count++, flows.size()});
                Long flowId = flow.getId();
                GetTaskFlowGraphResponseBody graph = this.dmsClient.GetTaskFlowGraph(flowId);
                if (ObjectUtils.isNotEmpty((Object)((Object)graph)) && ObjectUtils.isNotEmpty((Object)((Object)graph.getTaskFlowGraph())) && ObjectUtils.isNotEmpty((Object)((Object)graph.getTaskFlowGraph().getNodes())) && CollectionUtils.isNotEmpty(graph.getTaskFlowGraph().getNodes().getNode())) {
                    for (GetTaskFlowGraphResponseBody.GetTaskFlowGraphResponseBodyTaskFlowGraphNodesNode node : graph.getTaskFlowGraph().getNodes().getNode()) {
                        String nodeId = node.getNodeId().toString();
                        String taskContent = this.dmsClient.GetTaskContent(Long.valueOf(nodeId));
                        node.setNodeContent(taskContent);
                    }
                }
                ListTaskFlowResponseBody.ListTaskFlowResponseBodyTaskFlowListTaskFlow flowOverview = (ListTaskFlowResponseBody.ListTaskFlowResponseBodyTaskFlowListTaskFlow)taskFlowMap.get(flowId.toString());
                List<ListTaskFlowConstantsResponseBody.ListTaskFlowConstantsResponseBodyDagConstantsDagConstant> constants = this.dmsClient.ListTaskFlowConstants(flowId);
                List<ListTaskFlowTimeVariablesResponseBody.ListTaskFlowTimeVariablesResponseBodyTimeVariablesTimeVariable> timeVariables = this.dmsClient.ListTaskFlowTimeVariables(flowId);
                List<ListTaskFlowCooperatorsResponseBody.ListTaskFlowCooperatorsResponseBodyCooperatorListCooperator> cooperators = this.dmsClient.ListTaskFlowCooperators(flowId);
                GetTaskFlowNotificationResponseBody.GetTaskFlowNotificationResponseBodyNotification notification = this.dmsClient.GetTaskFlowNotification(flowId);
                String scenarioName = null;
                scenarioName = ObjectUtils.isNotEmpty((Object)flow.getScenarioId()) ? scenarios.get(flow.getScenarioId().toString()) : "\u9ed8\u8ba4\u4e1a\u52a1\u573a\u666f";
                DmsWorkflow dmsWorkflow = new DmsWorkflow(flowOverview, flow, graph, constants, timeVariables, cooperators, notification, scenarioName);
                this.dmsWorkflows.add(dmsWorkflow);
            }
        }
    }

    public File exportApiOrginalResponseToFile() {
        File pkgFile = new File(this.savePath);
        try {
            File tempDatasourceDir;
            File tempWorkflowDir;
            File tempDir = new File(pkgFile.getParentFile(), ".tmp");
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            if (!(tempWorkflowDir = new File(tempDir, "workflow")).exists()) {
                tempWorkflowDir.mkdirs();
            }
            if (CollectionUtils.isNotEmpty(this.dmsWorkflows)) {
                for (DmsWorkflow dmsWorkflow : this.dmsWorkflows) {
                    String filename = dmsWorkflow.getScenarioName() + "#" + dmsWorkflow.getBasicInfo().getDagName() + "#" + dmsWorkflow.getBasicInfo().getId() + ".json";
                    File workflowFile = new File(tempWorkflowDir, filename);
                    if (workflowFile.exists()) {
                        workflowFile.delete();
                    }
                    FileUtils.writeStringToFile((File)workflowFile, (String)JSONObject.toJSONString((Object)dmsWorkflow, (JSONWriter.Feature[])new JSONWriter.Feature[0]), (String)"UTF-8");
                }
            }
            if (!(tempDatasourceDir = new File(tempDir, "datasource")).exists()) {
                tempDatasourceDir.mkdirs();
            }
            if (CollectionUtils.isNotEmpty(this.datasources)) {
                for (DmsDatasource datasource : this.datasources) {
                    String filename = datasource.getInstance().getInstanceAlias() + "#" + datasource.getInstance().getInstanceId() + ".json";
                    File datasourceFile = new File(tempDatasourceDir, filename);
                    if (datasourceFile.exists()) {
                        datasourceFile.delete();
                    }
                    FileUtils.writeStringToFile((File)datasourceFile, (String)JSONObject.toJSONString((Object)datasource, (JSONWriter.Feature[])new JSONWriter.Feature[0]), (String)"UTF-8");
                }
            }
            ZipFileUtil.zipDir((File)tempDir, (File)pkgFile);
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (Exception e) {
            log.error("save.dms.workflow.error", (Throwable)e);
        }
        return pkgFile;
    }

    @Override
    public void save() {
    }
}

