/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dms.handle;

import com.alibaba.cola.dto.Response;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.common.utils.ZipFileUtil;
import com.aliyun.migration.workflow.migration.dms.converter.Dms2WorkflowConverter;
import com.aliyun.migration.workflow.migration.dms.domain.DmsDatasource;
import com.aliyun.migration.workflow.migration.dms.domain.DmsWorkflow;
import com.aliyun.migration.workflow.migration.dms.handle.AbstractDmsHandler;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmsFileHandler
extends AbstractDmsHandler {
    private static final Logger log = LoggerFactory.getLogger(DmsFileHandler.class);
    private String sourceFilePackage;
    private String targetFilePackage;
    private List<DmsWorkflow> dmsWorkflows;
    private List<DmsDatasource> datasources;

    public DmsFileHandler(TaskContext taskContext) {
        super.setTaskContext(taskContext);
        this.sourceFilePackage = taskContext.getSourceFilePackage();
        this.targetFilePackage = taskContext.getTargetFilePackage();
    }

    @Override
    public Response preCheck() {
        if (StringUtils.isBlank((CharSequence)this.sourceFilePackage)) {
            return Response.buildFailure((String)BwmServiceErrorCode.PRE_CHECK_ERROR.getCode(), (String)"not.set.the.source.file");
        }
        File sourceFile = new File(this.sourceFilePackage);
        if (!(sourceFile.exists() && sourceFile.isFile() && sourceFile.getName().endsWith(".zip"))) {
            return Response.buildFailure((String)BwmServiceErrorCode.PRE_CHECK_ERROR.getCode(), (String)"not.find.the.source.file");
        }
        if (StringUtils.isBlank((CharSequence)this.targetFilePackage)) {
            return Response.buildFailure((String)BwmServiceErrorCode.PRE_CHECK_ERROR.getCode(), (String)"not.set.the.target.file");
        }
        return Response.buildSuccess();
    }

    @Override
    public WorkflowProjectPackage read() {
        log.info("\u5f00\u59cb\u4ece\u6587\u4ef6\u8bfb\u53d6DMS\u4efb\u52a1\u7f16\u6392");
        this.loadDmsWorkflows();
        Dms2WorkflowConverter dms2WorkflowConverter = new Dms2WorkflowConverter();
        return dms2WorkflowConverter.convert(this.dmsWorkflows, this.datasources);
    }

    private void loadDmsWorkflows() {
        String json;
        List<Path> jsonFiles;
        this.dmsWorkflows = new ArrayList<DmsWorkflow>();
        this.datasources = new ArrayList<DmsDatasource>();
        File packageDir = null;
        try {
            packageDir = ZipFileUtil.decompress((File)new File(this.sourceFilePackage));
        }
        catch (IOException e) {
            log.error("decompress.filePath.error ", (Throwable)e);
            return;
        }
        File workflowDir = this.findWorkflowDir(packageDir);
        File datasourceDir = this.findDatasourceDir(packageDir);
        if (workflowDir != null && CollectionUtils.isNotEmpty(jsonFiles = this.findJsonFiles(workflowDir))) {
            for (Path jsonFile : jsonFiles) {
                try {
                    json = FileUtils.readFileToString((File)jsonFile.toFile());
                    ObjectMapper objectMapper = new ObjectMapper();
                    DmsWorkflow dmsWorkflow = (DmsWorkflow)objectMapper.readValue(json, (TypeReference)new TypeReference<DmsWorkflow>(){});
                    this.dmsWorkflows.add(dmsWorkflow);
                }
                catch (IOException e) {
                    log.error("read.file.error ", (Throwable)e);
                }
            }
        }
        if (datasourceDir != null && CollectionUtils.isNotEmpty(jsonFiles = this.findJsonFiles(datasourceDir))) {
            for (Path jsonFile : jsonFiles) {
                try {
                    json = FileUtils.readFileToString((File)jsonFile.toFile());
                    DmsDatasource datasource = (DmsDatasource)BwmJsonUtil.parseObject((String)json, DmsDatasource.class);
                    this.datasources.add(datasource);
                }
                catch (IOException e) {
                    log.error("read.file.error ", (Throwable)e);
                }
            }
        }
    }

    private List<Path> findJsonFiles(File directoryPath) {
        try {
            return Files.walk(directoryPath.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).collect(Collectors.toList());
        }
        catch (IOException e) {
            log.error("find.json.files.error ", (Throwable)e);
            return new ArrayList<Path>();
        }
    }

    private File findWorkflowDir(File directoryPath) {
        try {
            List paths = Files.walk(directoryPath.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> StringUtils.equals((CharSequence)path.getFileName().toString(), (CharSequence)"workflow")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(paths)) {
                log.error("not.find.the.workflow.dir");
                return null;
            }
            return ((Path)paths.get(0)).toFile();
        }
        catch (IOException e) {
            log.error("find.workflow.dir.error ", (Throwable)e);
            return null;
        }
    }

    private File findDatasourceDir(File directoryPath) {
        try {
            List paths = Files.walk(directoryPath.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> StringUtils.equals((CharSequence)path.getFileName().toString(), (CharSequence)"datasource")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(paths)) {
                log.error("not.find.the.datasource.dir");
                return null;
            }
            return ((Path)paths.get(0)).toFile();
        }
        catch (IOException e) {
            log.error("find.datasource.dir.error ", (Throwable)e);
            return null;
        }
    }

    @Override
    public void save() {
    }
}

