/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dms.converter;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dms_enterprise20181101.models.ListInstancesResponseBody;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.type.DmsDatasourceType;
import com.aliyun.migration.workflow.migration.common.type.DmsNodeType;
import com.aliyun.migration.workflow.migration.dms.domain.DmsDatasource;
import com.aliyun.migration.workflow.migration.dms.domain.DmsWorkflow;
import com.aliyun.migration.workflow.migration.dms.utils.temp.entity.GetTaskFlowGraphResponseBody;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dms2WorkflowConverter {
    private static final Logger log = LoggerFactory.getLogger(Dms2WorkflowConverter.class);

    public WorkflowProjectPackage convert(List<DmsWorkflow> dmsWorkflows, List<DmsDatasource> datasources) {
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        workflowProjectPackage.setWorkflowProject(new WorkflowProject());
        workflowProjectPackage.getWorkflowProject().setName("SourceDmsFlows");
        workflowProjectPackage.getWorkflowProject().setProjectId("SourceDmsFlows");
        workflowProjectPackage.setDatasources(new ArrayList());
        if (CollectionUtils.isNotEmpty(datasources)) {
            log.info("\u5f00\u59cb\u89e3\u6790DMS\u6570\u636e\u6e90\uff0c\u5171\u8ba1{}\u4e2a", (Object)datasources.size());
            datasources.forEach(x -> workflowProjectPackage.getDatasources().addAll(this.convertDatasource((DmsDatasource)x, workflowProjectPackage.getWorkflowProject())));
        }
        workflowProjectPackage.setWorkflowList(new ArrayList());
        if (CollectionUtils.isNotEmpty(dmsWorkflows)) {
            log.info("\u5f00\u59cb\u89e3\u6790DMS\u4efb\u52a1\u7f16\u6392\uff0c\u5171\u8ba1{}\u4e2a", (Object)dmsWorkflows.size());
            workflowProjectPackage.getWorkflowList().addAll(dmsWorkflows.stream().map(x -> this.convertWorkflow((DmsWorkflow)x, workflowProjectPackage.getWorkflowProject(), workflowProjectPackage.getDatasources())).collect(Collectors.toList()));
        }
        return workflowProjectPackage;
    }

    public Workflow convertWorkflow(DmsWorkflow dmsWorkflow, WorkflowProject workflowProject, List<WorkflowDatasource> datasources) {
        log.info("\u5f00\u59cb\u89e3\u6790DMS\u4efb\u52a1\u7f16\u6392\uff1a{}", (Object)dmsWorkflow.getBasicInfo().getDagName());
        Workflow workflow = new Workflow();
        if (dmsWorkflow.getBasicInfo() != null) {
            workflow.setWorkflowId(Long.toString(dmsWorkflow.getBasicInfo().getId()));
            workflow.setWorkflowName(dmsWorkflow.getBasicInfo().getDagName());
            workflow.setProjectName(workflowProject.getName());
            workflow.setProjectId(workflowProject.getProjectId());
            workflow.setOwner(dmsWorkflow.getBasicInfo().getDagOwnerId());
            workflow.setTriggers(new ArrayList());
            workflow.getTriggers().add(new WorkflowTrigger());
            if (ObjectUtils.equals((Object)dmsWorkflow.getBasicInfo().getTriggerType(), (Object)0)) {
                ((WorkflowTrigger)workflow.getTriggers().get(0)).setCron(dmsWorkflow.getBasicInfo().getCronStr());
                if (StringUtils.isNotBlank((CharSequence)dmsWorkflow.getBasicInfo().getCronBeginDate())) {
                    ((WorkflowTrigger)workflow.getTriggers().get(0)).setStartTime(LocalDateTime.parse(dmsWorkflow.getBasicInfo().getCronBeginDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                }
                if (StringUtils.isNotBlank((CharSequence)dmsWorkflow.getBasicInfo().getCronEndDate())) {
                    ((WorkflowTrigger)workflow.getTriggers().get(0)).setEndTime(LocalDateTime.parse(dmsWorkflow.getBasicInfo().getCronEndDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                }
                if (StringUtils.isNotBlank((CharSequence)dmsWorkflow.getBasicInfo().getTimeZoneId())) {
                    ((WorkflowTrigger)workflow.getTriggers().get(0)).setTimezone(ZoneId.of(dmsWorkflow.getBasicInfo().getTimeZoneId()));
                }
            }
        }
        if (dmsWorkflow.getFlowOverview() != null && StringUtils.isNotBlank((CharSequence)dmsWorkflow.getFlowOverview().getDagOwnerNickName())) {
            workflow.setOwner(dmsWorkflow.getFlowOverview().getDagOwnerNickName());
        }
        workflow.setWorkflowNodes(new ArrayList());
        if (CollectionUtils.isNotEmpty(dmsWorkflow.getNodes())) {
            workflow.getWorkflowNodes().addAll(dmsWorkflow.getNodes().stream().map(x -> this.convertDmsNode((GetTaskFlowGraphResponseBody.GetTaskFlowGraphResponseBodyTaskFlowGraphNodesNode)((Object)x), workflow, datasources)).collect(Collectors.toList()));
        }
        workflow.setNodeRelations(new ArrayList());
        if (CollectionUtils.isNotEmpty(dmsWorkflow.getEdges())) {
            workflow.getNodeRelations().addAll(dmsWorkflow.getEdges().stream().map(x -> this.convertNodeRelation((GetTaskFlowGraphResponseBody.GetTaskFlowGraphResponseBodyTaskFlowGraphEdgesEdge)((Object)x), workflow)).collect(Collectors.toList()));
        }
        workflow.setParamMap(new HashMap());
        if (CollectionUtils.isNotEmpty(dmsWorkflow.getTimeVariables())) {
            dmsWorkflow.getTimeVariables().forEach(x -> workflow.getParamMap().put(x.getName(), "${" + x.getPattern() + "}"));
        }
        if (CollectionUtils.isNotEmpty(dmsWorkflow.getConstants())) {
            dmsWorkflow.getConstants().forEach(x -> workflow.getParamMap().put(x.getKey(), x.getValue()));
        }
        if (StringUtils.isNotBlank((CharSequence)dmsWorkflow.getScenarioName())) {
            workflow.setCategoryValue(dmsWorkflow.getScenarioName());
        }
        return workflow;
    }

    public WorkflowNode convertDmsNode(GetTaskFlowGraphResponseBody.GetTaskFlowGraphResponseBodyTaskFlowGraphNodesNode dmsTaskNode, Workflow workflow, List<WorkflowDatasource> datasources) {
        JSONObject timeVariablesJson;
        WorkflowNode workflowNode = new WorkflowNode();
        workflowNode.setWorkflowName(workflow.getWorkflowName());
        workflowNode.setWorkflowId(workflow.getWorkflowId());
        workflowNode.setProjectName(workflow.getProjectName());
        workflowNode.setProjectId(workflow.getProjectId());
        workflowNode.setNodeName(dmsTaskNode.getNodeName());
        workflowNode.setNodeId(Long.toString(dmsTaskNode.getNodeId()));
        workflowNode.setNodeType(dmsTaskNode.getNodeType());
        workflowNode.setScript(dmsTaskNode.getNodeContent());
        if (StringUtils.isNotBlank((CharSequence)dmsTaskNode.getNodeConfig())) {
            JSONObject nodeConfigJson = JSONObject.parseObject((String)dmsTaskNode.getNodeConfig());
            if (nodeConfigJson.containsKey("resourceCtl")) {
                JSONObject resourceCtlJson = nodeConfigJson.getJSONObject("resourceCtl");
                if (nodeConfigJson.containsKey("rcSwitch") && nodeConfigJson.getBoolean("rcSwitch").booleanValue() && nodeConfigJson.containsKey("jobPriority")) {
                    workflowNode.setPriority(resourceCtlJson.getInteger("jobPriority"));
                }
                if (nodeConfigJson.containsKey("rcSwitch") && nodeConfigJson.getBoolean("rcSwitch").booleanValue() && nodeConfigJson.containsKey("maxTimeOut")) {
                    workflowNode.setTimeout(resourceCtlJson.getInteger("maxTimeOut"));
                }
            }
            if (nodeConfigJson.containsKey("rerun")) {
                JSONObject rerunJson = nodeConfigJson.getJSONObject("rerun");
                if (rerunJson.containsKey("rerunEnable") && rerunJson.getBoolean("rerunEnable").booleanValue()) {
                    workflowNode.setRerunMode(WorkflowNode.RerunMode.FAILURE_ALLOWED);
                } else {
                    workflowNode.setRerunMode(WorkflowNode.RerunMode.ALL_DENIED);
                }
                if (rerunJson.containsKey("rerunInterval")) {
                    workflowNode.setRerunInterval(Integer.valueOf(rerunJson.getInteger("rerunInterval") * 1000));
                }
                if (rerunJson.containsKey("rerunCount")) {
                    workflowNode.setRerunTimes(rerunJson.getInteger("rerunCount"));
                }
            } else {
                workflowNode.setRerunMode(WorkflowNode.RerunMode.ALL_DENIED);
            }
        }
        workflowNode.setParamMap(new HashMap());
        if (!StringUtils.isEmpty((CharSequence)dmsTaskNode.getTimeVariables()) && (timeVariablesJson = JSONObject.parseObject((String)dmsTaskNode.getTimeVariables())).containsKey("variables")) {
            timeVariablesJson.getJSONArray("variables").forEach(item -> {
                JSONObject variableJson = (JSONObject)item;
                workflowNode.getParamMap().put(variableJson.getString("name"), "${" + variableJson.getString("pattern") + "}");
            });
        }
        workflowNode.setCustomProperties(new HashMap());
        workflowNode.getCustomProperties().put("NodeConfig", dmsTaskNode.getNodeConfig());
        DmsNodeType nodeType = DmsNodeType.TypeOf((String)dmsTaskNode.getNodeType());
        if (nodeType != null) {
            switch (nodeType) {
                case NORMAL_SQL: {
                    if (!StringUtils.isNotBlank((CharSequence)workflowNode.getScript())) break;
                    JSONObject nodeContentJson = JSONObject.parseObject((String)workflowNode.getScript());
                    if (nodeContentJson.containsKey("dbId")) {
                        workflowNode.setDatasourceId(nodeContentJson.getString("dbId"));
                        for (WorkflowDatasource datasource : datasources) {
                            if (!ObjectUtils.equals((Object)datasource.getDatasourceId(), (Object)nodeContentJson.getString("dbId"))) continue;
                            workflowNode.setDataSources(List.of(datasource));
                            break;
                        }
                    }
                    if (nodeContentJson.containsKey("dbType")) {
                        workflowNode.setDbType(nodeContentJson.getString("dbType"));
                    }
                    if (nodeContentJson.containsKey("sql")) {
                        workflowNode.setScript(nodeContentJson.getString("sql"));
                        break;
                    }
                    workflowNode.setScript("");
                    break;
                }
                case LINDORM_SPARK: {
                    JSONObject nodeContentJson = JSONObject.parseObject((String)workflowNode.getScript());
                    workflowNode.setDbType(DmsDatasourceType.LINDORM_SQL.getTag());
                    if (nodeContentJson.containsKey("jobType")) {
                        if (workflowNode.getCustomProperties() == null) {
                            workflowNode.setCustomProperties(new HashMap());
                        }
                        workflowNode.getCustomProperties().put("jobType", nodeContentJson.getString("jobType"));
                        switch (nodeContentJson.getString("jobType")) {
                            case "sql": {
                                if (nodeContentJson.containsKey("sql")) {
                                    workflowNode.setScript(nodeContentJson.getString("sql"));
                                    break;
                                }
                                workflowNode.setScript("");
                            }
                        }
                    }
                    if (nodeContentJson.containsKey("instance")) {
                        String instance = nodeContentJson.getString("instance");
                        if (CollectionUtils.isNotEmpty(datasources)) {
                            for (WorkflowDatasource datasource : datasources) {
                                String ecsInstanceId;
                                if (!StringUtils.equals((CharSequence)datasource.getType(), (CharSequence)DmsDatasourceType.LINDORM_SQL.getTag()) || !(datasource.getCustomProperties().get("instance") instanceof ListInstancesResponseBody.ListInstancesResponseBodyInstanceListInstance) || !StringUtils.equals((CharSequence)(ecsInstanceId = ((ListInstancesResponseBody.ListInstancesResponseBodyInstanceListInstance)datasource.getCustomProperties().get("instance")).getEcsInstanceId()), (CharSequence)instance)) continue;
                                workflowNode.setDatasourceId(datasource.getDatasourceId());
                                workflowNode.setDataSources(List.of(datasource));
                                break;
                            }
                        }
                    }
                    if (!nodeContentJson.containsKey("configs")) break;
                    if (workflowNode.getCustomProperties() == null) {
                        workflowNode.setCustomProperties(new HashMap());
                    }
                    workflowNode.getCustomProperties().put("configs", nodeContentJson.getString("configs"));
                    break;
                }
            }
        }
        return workflowNode;
    }

    public RelationPackage convertNodeRelation(GetTaskFlowGraphResponseBody.GetTaskFlowGraphResponseBodyTaskFlowGraphEdgesEdge dmsTaskEdge, Workflow workflow) {
        RelationPackage relationPackage = RelationPackage.builder().from(String.valueOf(dmsTaskEdge.getNodeFrom())).to(String.valueOf(dmsTaskEdge.getNodeEnd())).reType(RelationPackage.ReType.NODE).build();
        return relationPackage;
    }

    public List<WorkflowDatasource> convertDatasource(DmsDatasource dmsDatasource, WorkflowProject workflowProject) {
        if (dmsDatasource == null || MapUtils.isEmpty(dmsDatasource.getSchemaMap())) {
            return new ArrayList<WorkflowDatasource>();
        }
        ArrayList<WorkflowDatasource> workflowDatasources = new ArrayList<WorkflowDatasource>();
        for (String schemaId : dmsDatasource.getSchemaMap().keySet()) {
            WorkflowDatasource datasource = new WorkflowDatasource();
            datasource.setName(dmsDatasource.getInstance().getInstanceAlias() + "#" + dmsDatasource.getSchemaMap().get(schemaId));
            datasource.setDatasourceId(schemaId);
            datasource.setType(dmsDatasource.getInstance().getInstanceType());
            datasource.setCustomProperties(new HashMap());
            JSONObject rawDatasource = JSONObject.from((Object)dmsDatasource);
            for (String key : rawDatasource.keySet()) {
                if (rawDatasource.get(key) instanceof JSONObject) {
                    datasource.getCustomProperties().put(key, rawDatasource.getJSONObject(key).toJSONString(new JSONWriter.Feature[0]));
                    continue;
                }
                if (rawDatasource.get(key) instanceof JSONArray) {
                    datasource.getCustomProperties().put(key, rawDatasource.getJSONArray(key).toJSONString(new JSONWriter.Feature[0]));
                    continue;
                }
                datasource.getCustomProperties().put(key, rawDatasource.get(key));
            }
            workflowDatasources.add(datasource);
        }
        return workflowDatasources;
    }
}

