/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.autoreload.config;

import com.alibaba.securitysdk.com.typesafe.config.Config;
import com.alibaba.securitysdk.com.typesafe.config.ConfigFactory;
import com.alibaba.securitysdk.com.typesafe.config.ConfigMergeable;
import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;

public class Configs {
    private static final Logger logger = SecurityLogManager.getLogger((String)"communication");
    private static final Config systemProperties = ConfigFactory.systemProperties();
    private static final Config systemEnvironment = ConfigFactory.systemEnvironment();
    private static final AtomicReference<Config> propertiesRef = new AtomicReference<Object>(null);

    private Configs() {
    }

    private static void initProperties(Config config) {
        if (!propertiesRef.compareAndSet(null, config)) {
            throw new RuntimeException("propertiesRef Config has already been initialized. This should only be called once.");
        }
    }

    public static Config properties() {
        return propertiesRef.get();
    }

    public static Config systemProperties() {
        return systemProperties;
    }

    public static Config systemEnvironment() {
        return systemEnvironment;
    }

    public static Builder newBuilder(boolean defaultApplication) {
        return new Builder(defaultApplication);
    }

    public static Builder newBuilder() {
        return new Builder(false);
    }

    public static class Builder {
        private Config conf;

        Builder(boolean defaultApplication) {
            this.conf = defaultApplication ? ConfigFactory.load() : ConfigFactory.empty();
        }

        public Builder withResource(String resource) {
            Config resourceConfig = ConfigFactory.load((ClassLoader)this.getClass().getClassLoader(), (String)resource);
            this.conf = this.conf.withFallback((ConfigMergeable)resourceConfig);
            int configEntrySize = resourceConfig.entrySet().size();
            String info = configEntrySize == 0 ? " contains no values" : String.valueOf(configEntrySize);
            logger.info("Loaded config file from resource ({})-{}", (Object)resource, (Object)info);
            return this;
        }

        public Builder withSystemProperties() {
            this.conf = this.conf.withFallback((ConfigMergeable)systemProperties);
            logger.info("Loaded system properties into config");
            return this;
        }

        public Builder withSystemEnvironment() {
            this.conf = this.conf.withFallback((ConfigMergeable)systemEnvironment);
            logger.info("Loaded system environment into config");
            return this;
        }

        public Builder withOptionalFile(String path) {
            File secureConfFile = new File(path);
            if (secureConfFile.exists()) {
                logger.info("Loaded config file from path ({})", (Object)path);
                this.conf = this.conf.withFallback((ConfigMergeable)ConfigFactory.parseFile((File)secureConfFile));
            } else {
                logger.info("Attempted to load file from path ({}) but it was not found", (Object)path);
            }
            return this;
        }

        public Builder withConfig(Config config) {
            this.conf = this.conf.withFallback((ConfigMergeable)config);
            return this;
        }

        public Config build() {
            this.conf = this.conf.resolve();
            if (logger.isDebugEnabled()) {
                logger.debug("Logging properties. Make sure sensitive data such as passwords or secrets are not logged!");
                logger.debug(this.conf.root().render());
            }
            return this.conf;
        }
    }
}

