/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.autoreload.adaptor;

import com.aliyun.rapt.commons.autoreload.AbstractPolicyResourceReloadMonitor;
import com.aliyun.rapt.commons.autoreload.PolicyReloadedListener;
import com.aliyun.rapt.commons.autoreload.config.DiamondConfigurator;
import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.rapt.commons.utils.StringUtils;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.taobao.diamond.manager.ManagerListener;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class DiamondPolicyReloadMonitor
extends AbstractPolicyResourceReloadMonitor {
    private static final Logger logger = SecurityLogManager.getLogger((String)"reload");
    private ManagerListener managerListener;

    public DiamondPolicyReloadMonitor(PolicyReloadedListener listener) {
        super(listener);
    }

    @Override
    protected void start0() throws Exception {
        this.managerListener = new DummyDiamondListener(this.listener, this.newThreadFactory("diamond-reloader"));
        DiamondConfigurator.instance.doConfig(this.managerListener);
    }

    @Override
    protected void destroy0() throws Exception {
        if (this.managerListener != null) {
            DiamondConfigurator.instance.remove(this.managerListener);
        } else {
            DiamondConfigurator.instance.remove();
        }
    }

    class DummyDiamondListener
    implements ManagerListener {
        private PolicyReloadedListener listener;
        private ExecutorService executor;

        DummyDiamondListener(PolicyReloadedListener listener, ThreadFactory threadFactory) {
            this.listener = listener;
            this.executor = Executors.newSingleThreadExecutor(threadFactory);
        }

        public Executor getExecutor() {
            return this.executor;
        }

        public void receiveConfigInfo(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return;
            }
            logger.info("receive config: {} Bytes", (Object)StringUtils.memoryBytesSizeOf((String)s));
            logger.debug("receive config: {}", (Object)s);
            this.listener.reload(s);
        }
    }
}

