/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTimeZone;
import org.quartz.CronExpression;

public class Utils {
    public static final Random RANDOM = new Random();
    private static final Logger logger = Logger.getLogger(Utils.class);

    private Utils() {
    }

    public static boolean equals(Object a, Object b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.equals(b);
    }

    public static <T> T nonNull(T t) {
        if (t == null) {
            throw new IllegalArgumentException("Null value not allowed.");
        }
        return t;
    }

    public static File findFilefromDir(File dir, String fn) {
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                if (!f.getName().equals(fn)) continue;
                return f;
            }
        }
        return null;
    }

    public static void croak(String message, int exitCode) {
        System.err.println(message);
        System.exit(exitCode);
    }

    public static boolean isValidPort(int port) {
        return port >= 1 && port <= 65535;
    }

    public static File createTempDir() {
        return Utils.createTempDir(new File(System.getProperty("java.io.tmpdir")));
    }

    public static File createTempDir(File parent) {
        File temp = new File(parent, Integer.toString(Math.abs(RANDOM.nextInt()) % 100000000));
        temp.delete();
        temp.mkdir();
        temp.deleteOnExit();
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File input, File output) throws IOException {
        FileOutputStream out = new FileOutputStream(output);
        try (ZipOutputStream zOut = new ZipOutputStream(out);){
            Utils.zipFile("", input, zOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFolderContent(File folder, File output) throws IOException {
        FileOutputStream out = new FileOutputStream(output);
        try (ZipOutputStream zOut = new ZipOutputStream(out);){
            File[] files = folder.listFiles();
            if (files != null) {
                for (File f : files) {
                    Utils.zipFile("", f, zOut);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(String path, File input, ZipOutputStream zOut) throws IOException {
        block5: {
            block4: {
                if (!input.isDirectory()) break block4;
                File[] files = input.listFiles();
                if (files == null) break block5;
                for (File f : files) {
                    String childPath = path + input.getName() + (f.isDirectory() ? "/" : "");
                    Utils.zipFile(childPath, f, zOut);
                }
                break block5;
            }
            String childPath = path + (path.length() > 0 ? "/" : "") + input.getName();
            ZipEntry entry = new ZipEntry(childPath);
            zOut.putNextEntry(entry);
            try (BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(input));){
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)zOut);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(ZipFile source, File dest) throws IOException {
        Enumeration<? extends ZipEntry> entries = source.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File newFile = new File(dest, entry.getName());
            if (!newFile.getCanonicalPath().startsWith(dest.getCanonicalPath())) {
                throw new IOException("Extracting zip entry would have resulted in a file outside the specified destination directory.");
            }
            if (entry.isDirectory()) {
                newFile.mkdirs();
                continue;
            }
            newFile.getParentFile().mkdirs();
            try (InputStream src = source.getInputStream(entry);
                 BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(newFile));){
                IOUtils.copy((InputStream)src, (OutputStream)output);
            }
        }
    }

    public static String flattenToString(Collection<?> collection, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        for (Object obj : collection) {
            buffer.append(obj.toString());
            buffer.append(delimiter);
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public static Double convertToDouble(Object obj) {
        if (obj instanceof String) {
            return Double.parseDouble((String)obj);
        }
        return (Double)obj;
    }

    private static RuntimeException getCause(InvocationTargetException e) {
        Throwable cause = e.getCause();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new IllegalStateException(e.getCause());
    }

    public static Class<?>[] getTypes(Object ... args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        return argTypes;
    }

    public static Object callConstructor(Class<?> c, Object ... args) {
        return Utils.callConstructor(c, Utils.getTypes(args), args);
    }

    public static Object callConstructor(Class<?> c, Class<?>[] argTypes, Object[] args) {
        try {
            Constructor<?> cons = c.getConstructor(argTypes);
            return cons.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw Utils.getCause(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object invokeStaticMethod(ClassLoader loader, String className, String methodName, Object ... args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = loader.loadClass(className);
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        Method method = clazz.getDeclaredMethod(methodName, argTypes);
        return method.invoke(null, args);
    }

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }

    public static long parseMemString(String strMemSize) {
        long size;
        if (strMemSize == null) {
            return 0L;
        }
        if (strMemSize.endsWith("g") || strMemSize.endsWith("G") || strMemSize.endsWith("m") || strMemSize.endsWith("M") || strMemSize.endsWith("k") || strMemSize.endsWith("K")) {
            String strSize = strMemSize.substring(0, strMemSize.length() - 1);
            size = Long.parseLong(strSize);
        } else {
            size = Long.parseLong(strMemSize);
        }
        long sizeInKb = strMemSize.endsWith("g") || strMemSize.endsWith("G") ? size * 1024L * 1024L : (strMemSize.endsWith("m") || strMemSize.endsWith("M") ? size * 1024L : (strMemSize.endsWith("k") || strMemSize.endsWith("K") ? size : size / 1024L));
        return sizeInKb;
    }

    public static CronExpression parseCronExpression(String cronExpression, DateTimeZone timezone) {
        if (cronExpression != null) {
            try {
                CronExpression ce = new CronExpression(cronExpression);
                ce.setTimeZone(TimeZone.getTimeZone(timezone.getID()));
                return ce;
            }
            catch (ParseException pe) {
                logger.error((Object)("this cron expression {" + cronExpression + "} can not be parsed. Please Check Quartz Cron Syntax."));
                return null;
            }
        }
        return null;
    }

    public static boolean isCronExpressionValid(String cronExpression, DateTimeZone timezone) {
        if (!CronExpression.isValidExpression((String)cronExpression)) {
            return false;
        }
        CronExpression cronExecutionTime = Utils.parseCronExpression(cronExpression, timezone);
        return cronExecutionTime != null && cronExecutionTime.getNextValidTimeAfter(new Date()) != null;
    }
}

