/*
 * Decompiled with CFR 0.152.
 */
package azkaban;

import java.time.Duration;

public class Constants {
    public static final double DEFAULT_AZKABAN_FLOW_VERSION = 1.0;
    public static final double AZKABAN_FLOW_VERSION_2_0 = 2.0;
    public static final String PROJECT_FILE_SUFFIX = ".project";
    public static final String FLOW_FILE_SUFFIX = ".flow";
    public static final String NODE_TYPE = "type";
    public static final String FLOW_NODE_TYPE = "flow";
    public static final String PATH_DELIMITER = ":";
    public static final String JOB_OVERRIDE_SUFFIX = ".jor";
    public static final String AZKABAN_PROPERTIES_FILE = "azkaban.properties";
    public static final String AZKABAN_PRIVATE_PROPERTIES_FILE = "azkaban.private.properties";
    public static final String DEFAULT_CONF_PATH = "conf";
    public static final String DEFAULT_EXECUTOR_PORT_FILE = "executor.port";
    public static final String AZKABAN_SERVLET_CONTEXT_KEY = "azkaban_app";
    public static final String AZKABAN_SLA_CHECKER_USERNAME = "azkaban_sla";
    public static final long MEMORY_CHECK_INTERVAL_MS = 60000L;
    public static final int MEMORY_CHECK_RETRY_LIMIT = 720;
    public static final int DEFAULT_PORT_NUMBER = 8081;
    public static final int DEFAULT_SSL_PORT_NUMBER = 8443;
    public static final int DEFAULT_JETTY_MAX_THREAD_COUNT = 20;
    public static final long DEFAULT_SCHEDULE_END_EPOCH_TIME = 2524608000000L;
    public static final Duration DEFAULT_FLOW_TRIGGER_MAX_WAIT_TIME = Duration.ofDays(10L);
    public static final Duration MIN_FLOW_TRIGGER_WAIT_TIME = Duration.ofMinutes(1L);
    public static final int UNASSIGNED_EXEC_ID = -1;
    public static final int FAILED_EXEC_ID = -2;

    public static class FlowTriggerProps {
        public static final String SCHEDULE_TYPE = "type";
        public static final String CRON_SCHEDULE_TYPE = "cron";
        public static final String SCHEDULE_VALUE = "value";
        public static final String DEP_NAME = "name";
        public static final String START_TIME = "startTime";
        public static final String TRIGGER_INSTANCE_ID = "triggerInstanceId";
    }

    public static class JobCallbackProperties {
        public static final String JOBCALLBACK_CONNECTION_REQUEST_TIMEOUT = "jobcallback.connection.request.timeout";
        public static final String JOBCALLBACK_CONNECTION_TIMEOUT = "jobcallback.connection.timeout";
        public static final String JOBCALLBACK_SOCKET_TIMEOUT = "jobcallback.socket.timeout";
        public static final String JOBCALLBACK_RESPONSE_WAIT_TIMEOUT = "jobcallback.response.wait.timeout";
        public static final String JOBCALLBACK_THREAD_POOL_SIZE = "jobcallback.thread.pool.size";
    }

    public static class JobProperties {
        public static final String AZKABAN_JOB_LOGGING_KAFKA_ENABLE = "azkaban.job.logging.kafka.enable";
        public static final String EXTRA_HCAT_CLUSTERS = "azkaban.job.hive.other_hcat_clusters";
        @Deprecated
        public static final String EXTRA_HCAT_LOCATION = "other_hcat_location";
        public static final String ENABLE_JOB_SSL = "azkaban.job.enable.ssl";
        public static final String JOB_MAX_XMS = "job.max.Xms";
        public static final String MAX_XMS_DEFAULT = "1G";
        public static final String JOB_MAX_XMX = "job.max.Xmx";
        public static final String MAX_XMX_DEFAULT = "2G";
        public static final String USER_TO_PROXY = "user.to.proxy";
        public static final String JOB_LOG_LAYOUT = "azkaban.job.log.layout";
    }

    public static class FlowProperties {
        public static final String AZKABAN_FLOW_PROJECT_NAME = "azkaban.flow.projectname";
        public static final String AZKABAN_FLOW_FLOW_ID = "azkaban.flow.flowid";
        public static final String AZKABAN_FLOW_SUBMIT_USER = "azkaban.flow.submituser";
        public static final String AZKABAN_FLOW_EXEC_ID = "azkaban.flow.execid";
        public static final String AZKABAN_FLOW_PROJECT_VERSION = "azkaban.flow.projectversion";
    }

    public static class ConfigurationKeys {
        public static final String AZKABAN_POLL_MODEL = "azkaban.poll.model";
        public static final String AZKABAN_POLLING_INTERVAL_MS = "azkaban.polling.interval.ms";
        public static final String AZKABAN_EXECUTOR_HEALTHCHECK_INTERVAL_MIN = "azkaban.executor.healthcheck.interval.min";
        public static final String AZKABAN_EXECUTOR_MAX_FAILURE_COUNT = "azkaban.executor.max.failurecount";
        public static final String AZKABAN_ADMIN_ALERT_EMAIL = "azkaban.admin.alert.email";
        public static final String AZKABAN_FLOW_VERSION = "azkaban-flow-version";
        public static final String AZKABAN_PID_FILENAME = "azkaban.pid.filename";
        public static final String AZKABAN_SERVER_EXTERNAL_TOPICS = "azkaban.server.external.topics";
        public static final String AZKABAN_SERVER_EXTERNAL_TOPIC_URL = "azkaban.server.external.${topic}.url";
        public static final String AZKABAN_SERVER_EXTERNAL_ANALYZER_TOPIC = "azkaban.server.external.analyzer.topic";
        public static final String AZKABAN_SERVER_EXTERNAL_ANALYZER_LABEL = "azkaban.server.external.analyzer.label";
        public static final String AZKABAN_SERVER_EXTERNAL_LOGVIEWER_TOPIC = "azkaban.server.external.logviewer.topic";
        public static final String AZKABAN_SERVER_EXTERNAL_LOGVIEWER_LABEL = "azkaban.server.external.logviewer.label";
        public static final String RESOURCE_MANAGER_JOB_URL = "azkaban.server.external.resource_manager_job_url";
        public static final String HISTORY_SERVER_JOB_URL = "azkaban.server.external.history_server_job_url";
        public static final String SPARK_HISTORY_SERVER_JOB_URL = "azkaban.server.external.spark_history_server_job_url";
        public static final String AZKABAN_SERVER_LOGGING_KAFKA_BROKERLIST = "azkaban.server.logging.kafka.brokerList";
        public static final String AZKABAN_SERVER_LOGGING_KAFKA_TOPIC = "azkaban.server.logging.kafka.topic";
        public static final String CUSTOM_METRICS_REPORTER_CLASS_NAME = "azkaban.metrics.reporter.name";
        public static final String METRICS_SERVER_URL = "azkaban.metrics.server.url";
        public static final String IS_METRICS_ENABLED = "azkaban.is.metrics.enabled";
        public static final String AZKABAN_WEBSERVER_EXTERNAL_HOSTNAME = "azkaban.webserver.external_hostname";
        public static final String AZKABAN_WEBSERVER_EXTERNAL_SSL_PORT = "azkaban.webserver.external_ssl_port";
        public static final String AZKABAN_WEBSERVER_EXTERNAL_PORT = "azkaban.webserver.external_port";
        public static final String AZKABAN_SERVER_HOST_NAME = "azkaban.server.hostname";
        public static final String BLACK_LISTED_USERS = "azkaban.server.blacklist.users";
        public static final String AZKABAN_SERVER_NATIVE_LIB_FOLDER = "azkaban.native.lib";
        public static final String AZKABAN_SERVER_GROUP_NAME = "azkaban.group.name";
        public static final String EXECUTOR_PORT_FILE = "executor.portfile";
        public static final String EXECUTOR_PORT = "executor.port";
        public static final String AZKABAN_MAX_FLOW_RUNNING_MINS = "azkaban.server.flow.max.running.minutes";
        public static final String AZKABAN_STORAGE_TYPE = "azkaban.storage.type";
        public static final String AZKABAN_STORAGE_LOCAL_BASEDIR = "azkaban.storage.local.basedir";
        public static final String HADOOP_CONF_DIR_PATH = "hadoop.conf.dir.path";
        public static final String AZKABAN_STORAGE_HDFS_ROOT_URI = "azkaban.storage.hdfs.root.uri";
        public static final String AZKABAN_KERBEROS_PRINCIPAL = "azkaban.kerberos.principal";
        public static final String AZKABAN_KEYTAB_PATH = "azkaban.keytab.path";
        public static final String PROJECT_TEMP_DIR = "project.temp.dir";
        public static final String AZKABAN_EVENT_REPORTING_CLASS_PARAM = "azkaban.event.reporting.class";
        public static final String AZKABAN_EVENT_REPORTING_ENABLED = "azkaban.event.reporting.enabled";
        public static final String AZKABAN_EVENT_REPORTING_PROPERTIES_TO_PROPAGATE = "azkaban.event.reporting.propagateProperties";
        public static final String AZKABAN_EVENT_REPORTING_KAFKA_BROKERS = "azkaban.event.reporting.kafka.brokers";
        public static final String AZKABAN_EVENT_REPORTING_KAFKA_TOPIC = "azkaban.event.reporting.kafka.topic";
        public static final String AZKABAN_EVENT_REPORTING_KAFKA_SCHEMA_REGISTRY_URL = "azkaban.event.reporting.kafka.schema.registry.url";
        public static final String AZKABAN_STORAGE_ARTIFACT_MAX_RETENTION = "azkaban.storage.artifact.max.retention";
        public static final String ENABLE_QUARTZ = "azkaban.server.schedule.enable_quartz";
        public static final String CUSTOM_CREDENTIAL_NAME = "azkaban.security.credential";
        public static final String DEPENDENCY_PLUGIN_DIR = "azkaban.dependency.plugin.dir";
        public static final String USE_MULTIPLE_EXECUTORS = "azkaban.use.multiple.executors";
        public static final String MAX_CONCURRENT_RUNS_ONEFLOW = "azkaban.max.concurrent.runs.oneflow";
        public static final String WEBSERVER_QUEUE_SIZE = "azkaban.webserver.queue.size";
        public static final String ACTIVE_EXECUTOR_REFRESH_IN_MS = "azkaban.activeexecutor.refresh.milisecinterval";
        public static final String ACTIVE_EXECUTOR_REFRESH_IN_NUM_FLOW = "azkaban.activeexecutor.refresh.flowinterval";
        public static final String EXECUTORINFO_REFRESH_MAX_THREADS = "azkaban.executorinfo.refresh.maxThreads";
        public static final String MAX_DISPATCHING_ERRORS_PERMITTED = "azkaban.maxDispatchingErrors";
        public static final String EXECUTOR_SELECTOR_FILTERS = "azkaban.executorselector.filters";
        public static final String EXECUTOR_SELECTOR_COMPARATOR_PREFIX = "azkaban.executorselector.comparator.";
        public static final String QUEUEPROCESSING_ENABLED = "azkaban.queueprocessing.enabled";
        public static final String SESSION_TIME_TO_LIVE = "session.time.to.live";
        public static final String PROJECT_CACHE_SIZE_PERCENTAGE = "azkaban.project_cache_size_percentage_of_disk";
        public static final String PROJECT_VERSION_RETENTION = "project.version.retention";
        public static final String DISPLAY_EXECUTION_PAGE_SIZE = "azkaban.display.execution_page_size";
    }
}

