/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.dsv1.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.enums.EngineType;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.workflow.migration.common.convert.FileResourceConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsV1FileConvert
extends FileResourceConvert {
    private static final Logger log = LoggerFactory.getLogger(DsV1FileConvert.class);

    public DsV1FileConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public WorkflowFileResource convert(WorkflowFileResource workflowFileResource) {
        WorkflowFileResource resource = (WorkflowFileResource)BwmJsonUtil.deepCopy((Object)workflowFileResource, WorkflowFileResource.class);
        String targetEngine = this.getTargetEngineTypeStr(this.taskContext);
        if (targetEngine.equals(EngineType.EMR.getEngineName())) {
            if (workflowFileResource.getName().endsWith(".jar")) {
                resource.setFileType(CodeProgramType.EMR_JAR.getName());
            } else {
                resource.setFileType(CodeProgramType.EMR_FILE.getName());
            }
            if (resource.getCustomProperties() == null) {
                resource.setCustomProperties(new HashMap());
            }
            resource.getCustomProperties().put("workflow.converter.target.engine.datasource.name", this.getTargetEngineNameStr(this.taskContext));
        } else if (targetEngine.equals(EngineType.MAXCOMPUTE.getEngineName())) {
            if (workflowFileResource.getName().endsWith(".jar")) {
                resource.setFileType(CodeProgramType.ODPS_JAR.getName());
            } else {
                resource.setFileType(CodeProgramType.ODPS_FILE.getName());
            }
            if (resource.getCustomProperties() == null) {
                resource.setCustomProperties(new HashMap());
            }
            resource.getCustomProperties().put("workflow.converter.target.engine.datasource.name", this.getTargetEngineNameStr(this.taskContext));
        } else if (targetEngine.equals(EngineType.CDH.getEngineName())) {
            if (workflowFileResource.getName().endsWith(".jar")) {
                resource.setFileType(CodeProgramType.CDH_JAR.getName());
            } else {
                resource.setFileType(CodeProgramType.CDH_FILE.getName());
            }
            if (resource.getCustomProperties() == null) {
                resource.setCustomProperties(new HashMap());
            }
            resource.getCustomProperties().put("workflow.converter.target.engine.datasource.name", this.getTargetEngineNameStr(this.taskContext));
        } else {
            log.warn("\u672a\u80fd\u8bc6\u522b\u5f15\u64ce\uff0cworkflow.converter.target.engine.type\u5f53\u524d\u8bbe\u7f6e\u4e3a{}\uff0c\u5bfc\u81f4\u8d44\u6e90\u6587\u4ef6\u7c7b\u578b\u5b9a\u4e49\u5931\u8d25", (Object)targetEngine);
        }
        return resource;
    }
}

