/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.dsv1.convert;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.CodeModeType;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIConfigTemplate;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.AbstractDataxConverter;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DataxReaderConvertFactory;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DataxType;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DataxWriterConvertFactory;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataxNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(DataxNodeConvert.class);

    public DataxNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        DIJsonProcessor diProcessor = DIJsonProcessor.from((String)DIConfigTemplate.DI_CODE_TEMPLATE);
        DIJsonProcessor readerJp = diProcessor.getConfiguration("steps[0]");
        DIJsonProcessor writerJp = diProcessor.getConfiguration("steps[1]");
        try {
            this.processDataxSource(workflowNode, readerJp);
            this.processDataxTarget(workflowNode, writerJp);
        }
        catch (Exception e) {
            log.error("parse datax config error, please manal fix", (Throwable)e);
        }
        diProcessor.set("extend.mode", (Object)CodeModeType.CODE.getValue());
        tgtworkflowNode.setScript(diProcessor.toJSON());
        if (Objects.nonNull(tgtworkflowNode.getCustomProperties())) {
            tgtworkflowNode.setCustomProperties(new HashMap());
        }
        if (Objects.isNull(tgtworkflowNode.getCustomProperties())) {
            tgtworkflowNode.setCustomProperties(new HashMap());
        }
        tgtworkflowNode.getCustomProperties().put("codeMode", CodeModeType.CODE.getValue());
        String diResourceGroup = this.selfConfMap.getOrDefault("workflow.di.resource.group", "");
        String resourceGroup = this.selfConfMap.getOrDefault("workflow.resource.group", "");
        if (org.springframework.util.CollectionUtils.isEmpty((Map)workflowNode.getCustomProperties())) {
            tgtworkflowNode.setCustomProperties(new HashMap());
        }
        tgtworkflowNode.getCustomProperties().put("workflow.di.resource.group", diResourceGroup);
        tgtworkflowNode.getCustomProperties().put("workflow.resource.group", resourceGroup);
        tgtworkflowNode.setNodeType(CodeProgramType.DI.getName());
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    private void processDataxSource(WorkflowNode workflowNode, DIJsonProcessor readerJp) {
        JSONObject dataxJson = JSON.parseObject((String)workflowNode.getScript());
        if ((Integer)dataxJson.getObject("customConfig", Integer.class, new JSONReader.Feature[0]) == 0) {
            this.processDataxSourceWithTemplate(workflowNode, readerJp);
        } else {
            this.processDataxSourceWithJson(workflowNode, readerJp);
        }
    }

    private void processDataxSourceWithTemplate(WorkflowNode workflowNode, DIJsonProcessor readerJp) {
        String name;
        JSONObject dataxJson = JSON.parseObject((String)workflowNode.getScript());
        String dsType = dataxJson.getString("dsType");
        String readerType = DataxType.getTypeByName((String)dsType).getReadName();
        JSONObject readerJson = new JSONObject();
        readerJson.put((Object)"name", (Object)readerType);
        String sqlReaderScript = dataxJson.getString("sql");
        if (StringUtils.isNotBlank((CharSequence)sqlReaderScript)) {
            readerJson.put((Object)"parameter", new JSONObject().put((Object)"connection", (Object)new JSONArray().add(new JSONObject().put((Object)"querySql", (Object)new ArrayList<String>().add(sqlReaderScript)))));
        }
        if (StringUtils.isBlank((CharSequence)(name = readerJson.getString("name")))) {
            throw new UnsupportedOperationException("reader.name.can.not.be.null");
        }
        DataxReaderConvertFactory dataxConverterFactory = new DataxReaderConvertFactory(this.bwmConfiguration);
        AbstractDataxConverter readerConvert = dataxConverterFactory.getReaderConvert(name);
        readerConvert.convert(readerJson, readerJp);
    }

    private void processDataxSourceWithJson(WorkflowNode workflowNode, DIJsonProcessor readerJp) {
        JSONObject dataxJson = JSON.parseObject((String)workflowNode.getScript());
        if (dataxJson.getJSONObject("json") == null) {
            log.error("datax\u8282\u70b9{}\u4f7f\u7528\u4e86\u81ea\u5b9a\u4e49\u7684\u6a21\u677f\uff0c\u4f46json\u4e3a\u7a7a", (Object)workflowNode.getNodeName());
            return;
        }
        JSONArray content = dataxJson.getJSONObject("json").getJSONObject("job").getJSONArray("content");
        Iterator iterator = content.stream().iterator();
        JSONObject readerJson = null;
        while (iterator.hasNext()) {
            JSONObject item = (JSONObject)iterator.next();
            if (!item.containsKey("reader")) continue;
            readerJson = item.getJSONObject("reader");
            break;
        }
        if (Objects.isNull(readerJson)) {
            log.error("datax.format.error,not.found.reader");
            return;
        }
        String name = readerJson.getString("name");
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new UnsupportedOperationException("reader.name.can.not.be.null");
        }
        DataxReaderConvertFactory dataxConverterFactory = new DataxReaderConvertFactory(this.bwmConfiguration);
        AbstractDataxConverter readerConvert = dataxConverterFactory.getReaderConvert(name);
        readerConvert.convert(readerJson, readerJp);
    }

    private void processDataxTarget(WorkflowNode workflowNode, DIJsonProcessor writerJp) {
        JSONObject dataxJson = JSON.parseObject((String)workflowNode.getScript());
        if ((Integer)dataxJson.getObject("customConfig", Integer.class, new JSONReader.Feature[0]) == 0) {
            this.processDataxTargetWithTemplate(workflowNode, writerJp);
        } else {
            this.processDataxTargetWithJson(workflowNode, writerJp);
        }
    }

    private void processDataxTargetWithTemplate(WorkflowNode workflowNode, DIJsonProcessor writerJp) {
        JSONObject dataxJson = JSON.parseObject((String)workflowNode.getScript());
        String dsType = dataxJson.getString("dtType");
        String writerType = DataxType.getTypeByName((String)dsType).getWriterName();
        JSONObject writerJson = new JSONObject();
        writerJson.put((Object)"name", (Object)writerType);
        HashMap<String, String> writerScript = new HashMap<String, String>();
        if (dataxJson.containsKey("preStatements")) {
            writerScript.put("preSql", dataxJson.getString("preStatements"));
        }
        if (dataxJson.containsKey("postStatements")) {
            writerScript.put("postSql", dataxJson.getString("postStatements"));
        }
        if (writerScript.size() > 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.putAll(writerScript);
            writerJson.put((Object)"parameter", (Object)jsonObject);
        }
        if (Objects.isNull(writerJson)) {
            log.error("datax.format.error,not.found.reader");
            return;
        }
        String name = writerJson.getString("name");
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new UnsupportedOperationException("reader.name.can.not.be.null");
        }
        DataxWriterConvertFactory dataxConverterFactory = new DataxWriterConvertFactory(this.bwmConfiguration);
        AbstractDataxConverter writerConvert = dataxConverterFactory.getWriterConvert(name);
        writerConvert.convert(writerJson, writerJp);
    }

    private void processDataxTargetWithJson(WorkflowNode workflowNode, DIJsonProcessor writerJp) {
        JSONObject dataxJson = JSON.parseObject((String)workflowNode.getScript());
        if (dataxJson.getJSONObject("json") == null) {
            log.error("datax\u8282\u70b9{}\u4f7f\u7528\u4e86\u81ea\u5b9a\u4e49\u7684\u6a21\u677f\uff0c\u4f46json\u4e3a\u7a7a", (Object)workflowNode.getNodeName());
            return;
        }
        JSONArray content = dataxJson.getJSONObject("json").getJSONObject("job").getJSONArray("content");
        Iterator iterator = content.stream().iterator();
        JSONObject writerJson = null;
        while (iterator.hasNext()) {
            JSONObject item = (JSONObject)iterator.next();
            if (!item.containsKey("writer")) continue;
            writerJson = item.getJSONObject("writer");
            break;
        }
        if (Objects.isNull(writerJson)) {
            log.error("datax.format.error,not.found.reader");
            return;
        }
        String name = writerJson.getString("name");
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new UnsupportedOperationException("reader.name.can.not.be.null");
        }
        DataxWriterConvertFactory dataxConverterFactory = new DataxWriterConvertFactory(this.bwmConfiguration);
        AbstractDataxConverter writerConvert = dataxConverterFactory.getWriterConvert(name);
        writerConvert.convert(writerJson, writerJp);
    }
}

