/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;

public class Base64Utils {
    private static final int RANGE = 255;
    private static final char[] BASE64_BYTE_TO_STR;
    private static byte[] strToBase64Byte;

    public static String encodeUtf8(String source) throws UnsupportedEncodingException {
        return Base64Utils.encode(source.getBytes("UTF-8"));
    }

    public static String decodeUtf8(String val) {
        if (val == null || val.isEmpty()) {
            return "";
        }
        try {
            return new String(Base64Utils.decode(val), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return val;
        }
    }

    public static String decodeString(String val) {
        try {
            return new String(Base64Utils.decode(val), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String encode(byte[] bytes) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i <= bytes.length - 1; i += 3) {
            int k;
            byte[] enBytes = new byte[4];
            int tmp = 0;
            for (k = 0; k <= 2; ++k) {
                if (i + k <= bytes.length - 1) {
                    enBytes[k] = (byte)((bytes[i + k] & 0xFF) >>> 2 + 2 * k | tmp);
                    tmp = (byte)(((bytes[i + k] & 0xFF) << 2 + 2 * (2 - k) & 0xFF) >>> 2);
                    continue;
                }
                enBytes[k] = tmp;
                tmp = 64;
            }
            enBytes[3] = tmp;
            for (k = 0; k <= 3; ++k) {
                if (enBytes[k] <= 63) {
                    res.append(BASE64_BYTE_TO_STR[enBytes[k]]);
                    continue;
                }
                res.append('=');
            }
        }
        return res.toString();
    }

    private static boolean isBase64(String str) {
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        return Pattern.matches(base64Pattern, str);
    }

    public static byte[] decode(String val) throws UnsupportedEncodingException {
        int i;
        boolean isEncode = Base64Utils.isBase64(val);
        if (!isEncode) {
            throw new UnsupportedEncodingException();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] srcBytes = val.getBytes("utf-8");
        byte[] base64bytes = new byte[srcBytes.length];
        for (i = 0; i <= srcBytes.length - 1; ++i) {
            byte ind = srcBytes[i];
            base64bytes[i] = strToBase64Byte[ind];
        }
        for (i = 0; i <= base64bytes.length - 1; i += 4) {
            int k;
            byte[] deBytes = new byte[3];
            int delen = 0;
            for (k = 0; k <= 2; ++k) {
                if (i + k + 1 > base64bytes.length - 1 || base64bytes[i + k + 1] < 0) continue;
                byte tmp = (byte)((base64bytes[i + k + 1] & 0xFF) >>> 2 + 2 * (2 - (k + 1)));
                deBytes[k] = (byte)((base64bytes[i + k] & 0xFF) << 2 + 2 * k & 0xFF | tmp);
                ++delen;
            }
            for (k = 0; k <= delen - 1; ++k) {
                bos.write(deBytes[k]);
            }
        }
        return bos.toByteArray();
    }

    static {
        int i;
        BASE64_BYTE_TO_STR = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'L', 'K', 'J', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        strToBase64Byte = new byte[128];
        for (i = 0; i <= strToBase64Byte.length - 1; ++i) {
            Base64Utils.strToBase64Byte[i] = -1;
        }
        for (i = 0; i <= BASE64_BYTE_TO_STR.length - 1; ++i) {
            Base64Utils.strToBase64Byte[Base64Utils.BASE64_BYTE_TO_STR[i]] = (byte)i;
        }
    }
}

