/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.spec.domain.ConnectionMapping;
import com.aliyun.migration.spec.domain.DataArtsJobParamDTO;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfig;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigInput;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigValues;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobExtendedConfigs;
import com.aliyun.migration.spec.domain.constant.DataArtsConstant;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.DISetpTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.annotation.DIRef;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.config.DataArtsDiConfig;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStep;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStepParameter;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.Base64Utils;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.DataArtsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DIRef(value="MYSQL_STEP_TYPE")
public class MySQLStepTypeHandler
implements DISetpTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(MySQLStepTypeHandler.class);

    @Override
    public DiScriptStep convertToDwSourceStep(DataArtsDiConfig config, List<DataArtsJobParamDTO> jobParams, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) throws RuntimeException {
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Reader");
        diScriptStep.setStepType("mysql");
        diScriptStep.setCategory("reader");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        ArrayList<DiScriptStepParameter.Connection> connections = new ArrayList<DiScriptStepParameter.Connection>();
        String dbName = null;
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        DiScriptStepParameter.Connection connection = new DiScriptStepParameter.Connection();
        connection.setDatasource(setepParameter.getDatasource());
        for (final DataArtsCdmJobConfigInput input : inputList) {
            if ("fromJobConfig.useSql".equals(input.getName()) && Boolean.valueOf(input.getValue()).booleanValue()) {
                connection.setQuerySql(Collections.singletonList(DataArtsUtil.getSql(inputList).replace("\"", "`")));
                continue;
            }
            if ("fromJobConfig.tableName".equals(input.getName())) {
                connection.setTable((List<String>)new ArrayList<String>(){
                    {
                        this.add(input.getValue());
                    }
                });
                continue;
            }
            if ("fromJobConfig.columnList".equals(input.getName())) {
                setepParameter.setColumn(Arrays.asList(input.getValue().split("&")));
                continue;
            }
            if ("fromJobConfig.whereClause".equals(input.getName())) {
                setepParameter.setWhere(Base64Utils.decodeUtf8(input.getValue()));
                continue;
            }
            if ("fromJobConfig.partitionColumn".equals(input.getName())) {
                setepParameter.setSplitPk(input.getValue());
                continue;
            }
            if ("fromJobConfig.schemaName".equals(input.getName())) {
                dbName = input.getValue();
                continue;
            }
            if (!"fromJobConfig.database".equals(input.getName())) continue;
            dbName = input.getValue();
        }
        setepParameter.setConnection(connections);
        ConnectionMapping dwFromDataSource = config.getConnectionMapping(dataArtsLinkName, dbName);
        connection.setDatasource(dwFromDataSource.getDwConnectionName());
        connections.add(connection);
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DataArtsDiConfig config, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) throws RuntimeException {
        DataArtsCdmJobConfig dataArtsCdmJobConfig = (DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0);
        DataArtsCdmJobExtendedConfigs dataArtsCdmJobExtendedConfigs = dataArtsCdmJobConfigValues.getExtendedConfigs();
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Writer");
        diScriptStep.setStepType("mysql");
        diScriptStep.setCategory("writer");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        ArrayList<String> preSql = new ArrayList<String>();
        if (dataArtsCdmJobExtendedConfigs != null && "toJobConfig.extendedFields".equals(dataArtsCdmJobExtendedConfigs.getName()) && StringUtils.isNotEmpty((CharSequence)dataArtsCdmJobExtendedConfigs.getValue())) {
            String extendedFieldsValue = null;
            try {
                extendedFieldsValue = new String(Base64.getDecoder().decode(dataArtsCdmJobExtendedConfigs.getValue()));
            }
            catch (Exception e) {
                log.error("fromJobConfig.whereClause decode error dataArtsLinkName=" + dataArtsLinkName);
            }
            final JSONObject extendedFieldsValueJson = JSON.parseObject((String)extendedFieldsValue);
            if (extendedFieldsValueJson.containsKey("preSql")) {
                preSql.add(extendedFieldsValueJson.getString("preSql").replace("\n", ""));
            }
            if (extendedFieldsValueJson.containsKey("postSql")) {
                setepParameter.setPostSql((List<String>)new ArrayList<String>(){
                    {
                        this.add(extendedFieldsValueJson.getString("postSql"));
                    }
                });
            }
        }
        boolean deleteAllOldData = false;
        List inputList = dataArtsCdmJobConfig.getInputs();
        String whereClause = null;
        String dataArtsDataBase = null;
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("toJobConfig.tableName".equals(input.getName())) {
                setepParameter.setTable(input.getValue());
                continue;
            }
            if ("toJobConfig.columnList".equals(input.getName())) {
                setepParameter.setColumn(Arrays.asList(input.getValue().split("&")));
                continue;
            }
            if ("toJobConfig.shouldClearTable".equals(input.getName())) continue;
            if ("toJobConfig.onConflict".equals(input.getName())) {
                if (input.getValue().equalsIgnoreCase("MERGE")) {
                    setepParameter.setWriteMode("replace");
                    continue;
                }
                if (input.getValue().equalsIgnoreCase("EXCEPTION")) {
                    setepParameter.setWriteMode("insert");
                    continue;
                }
                if (!input.getValue().equalsIgnoreCase("IGNORE")) continue;
                setepParameter.setWriteMode("update");
                continue;
            }
            if ("toJobConfig.beforeImportType".equals(input.getName())) {
                if (!input.getValue().equals("shouldClearTable")) continue;
                deleteAllOldData = true;
                continue;
            }
            if ("toJobConfig.whereClause".equals(input.getName())) {
                whereClause = Base64Utils.decodeUtf8(input.getValue());
                continue;
            }
            if ("toJobConfig.database".equals(input.getName())) {
                dataArtsDataBase = input.getValue();
                continue;
            }
            if (!"toJobConfig.schemaName".equals(input.getName())) continue;
            dataArtsDataBase = input.getValue();
        }
        if (deleteAllOldData) {
            preSql.add("TRUNCATE  TABLE " + setepParameter.getTable() + ";");
        } else if (StringUtils.isNotEmpty(whereClause)) {
            preSql.add("delete from " + setepParameter.getTable() + " where " + whereClause + ";");
        }
        setepParameter.setBatchSize(DataArtsConstant.DW_DI_SYNC_BATCH_SIZE);
        setepParameter.setPreSql(preSql);
        ConnectionMapping dwFromDataSource = config.getConnectionMapping(dataArtsLinkName, dataArtsDataBase);
        setepParameter.setDatasource(dwFromDataSource.getDwConnectionName());
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }
}

