/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di;

import com.aliyun.migration.spec.domain.ConnectionMapping;
import com.aliyun.migration.spec.domain.DataArtsJobParamDTO;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfig;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigInput;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigValues;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.DISetpTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.annotation.DIRef;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.config.DataArtsDiConfig;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStep;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStepParameter;
import java.util.ArrayList;
import java.util.List;

@DIRef(value="KAFKA_STEP_TYPE")
public class KafkaStepTypeHandler
implements DISetpTypeHandler {
    @Override
    public DiScriptStep convertToDwSourceStep(DataArtsDiConfig config, List<DataArtsJobParamDTO> jobParams, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) {
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Reader");
        diScriptStep.setStepType("Kafka");
        diScriptStep.setCategory("reader");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        setepParameter.setDatasource(config.getConnectionMapping(dataArtsLinkName).getDwConnectionName());
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        for (DataArtsCdmJobConfigInput input : inputList) {
            if (!"fromJobConfig.topicsList".equals(input.getName())) continue;
            setepParameter.setTopic(input.getValue().split(",")[0]);
        }
        setepParameter.setColumn(new ArrayList<String>(){
            {
                this.add("__key__");
                this.add("__value__");
                this.add("__partition__");
                this.add("__headers__");
                this.add("__offset__");
                this.add("__timestamp__");
            }
        });
        setepParameter.setKeyType("string");
        setepParameter.setValueType("string");
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DataArtsDiConfig config, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) {
        ConnectionMapping dwFromDataSource = config.getConnectionMapping(dataArtsLinkName);
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Writer");
        diScriptStep.setStepType("Kafka");
        diScriptStep.setCategory("writer");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        setepParameter.setDatasource(dwFromDataSource.getDwConnectionName());
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("toJobConfig.topic".equals(input.getName())) {
                setepParameter.setTopic(input.getValue());
                continue;
            }
            if ("toJobConfig.dataFormat".equals(input.getName())) {
                setepParameter.setWriteMode(input.getValue().equals("CSV") ? "TEXT" : "JSON");
                continue;
            }
            if (!"toJobConfig.separator".equals(input.getName())) continue;
            setepParameter.setFieldDelimiter(input.getValue());
        }
        setepParameter.setKeyType("string");
        setepParameter.setValueType("string");
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }
}

