/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di;

import com.aliyun.migration.spec.domain.ConnectionMapping;
import com.aliyun.migration.spec.domain.DataArtsJobParamDTO;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfig;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigInput;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigValues;
import com.aliyun.migration.spec.domain.constant.DataArtsConstant;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.DISetpTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.annotation.DIRef;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.config.DataArtsDiConfig;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStep;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStepParameter;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStepParameterHOLO;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.TableMetadata;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.Base64Utils;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DIRef(value="HOLOGRES_STEP_TYPE")
public class HologresStepTypeHandler
implements DISetpTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(HologresStepTypeHandler.class);

    @Override
    public DiScriptStep convertToDwSourceStep(DataArtsDiConfig config, List<DataArtsJobParamDTO> jobParams, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) throws RuntimeException {
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Reader");
        diScriptStep.setStepType("holo");
        diScriptStep.setCategory("reader");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        ConnectionMapping dwFromDataSource = config.getConnectionMapping(dataArtsLinkName);
        setepParameter.setDatasource(dwFromDataSource.getDwConnectionName());
        String dataArtsDataBase = null;
        setepParameter.setDatasource(config.getConnectionMapping(dataArtsLinkName).getDwConnectionName());
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("fromJobConfig.tableName".equals(input.getName())) {
                setepParameter.setTable(input.getValue());
                continue;
            }
            if ("fromJobConfig.columnList".equals(input.getName())) {
                setepParameter.setColumn(Arrays.asList(input.getValue().split("&")));
                continue;
            }
            if ("fromJobConfig.whereClause".equals(input.getName())) {
                setepParameter.setWhere(Base64Utils.decodeUtf8(input.getValue()));
                continue;
            }
            if (!"fromJobConfig.schemaName".equals(input.getName())) continue;
            dataArtsDataBase = input.getValue();
        }
        if (setepParameter.getTable() != null && dataArtsDataBase != null) {
            setepParameter.setTable(dataArtsDataBase + "." + setepParameter.getTable());
        }
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DataArtsDiConfig config, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) throws RuntimeException {
        TableMetadata tableMetadata;
        DataArtsCdmJobConfig dataArtsCdmJobConfig = (DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0);
        ConnectionMapping dwDataSource = config.getConnectionMapping(dataArtsLinkName);
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Writer");
        diScriptStep.setStepType("holo");
        diScriptStep.setCategory("writer");
        DiScriptStepParameterHOLO setepParameter = new DiScriptStepParameterHOLO();
        setepParameter.setDatasource(dwDataSource.getDwConnectionName());
        List inputList = dataArtsCdmJobConfig.getInputs();
        String dataArtsDataBase = null;
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("toJobConfig.tableName".equals(input.getName())) {
                setepParameter.setTable(input.getValue());
                continue;
            }
            if ("toJobConfig.columnList".equals(input.getName())) {
                setepParameter.setColumn(Arrays.asList(input.getValue().split("&")));
                continue;
            }
            if ("toJobConfig.onConflict".equals(input.getName())) {
                if (input.getValue().equalsIgnoreCase("MERGE")) {
                    setepParameter.setConflictMode("Replace");
                    continue;
                }
                if (input.getValue().equalsIgnoreCase("EXCEPTION")) {
                    setepParameter.setWriteMode("Update");
                    continue;
                }
                if (!input.getValue().equalsIgnoreCase("IGNORE")) continue;
                setepParameter.setWriteMode("Ignore");
                continue;
            }
            if ("toJobConfig.beforeImportType".equals(input.getName()) && input.getValue().equals("shouldClearTable")) {
                setepParameter.setTruncate(true);
                continue;
            }
            if (!"toJobConfig.schemaName".equals(input.getName())) continue;
            dataArtsDataBase = input.getValue();
        }
        setepParameter.setWriteMode("insert");
        setepParameter.setConflictMode("ignore");
        if (setepParameter.getTable() != null && dataArtsDataBase != null) {
            setepParameter.setTable(dataArtsDataBase + "." + setepParameter.getTable());
        }
        if ((tableMetadata = config.getTableMetadata(dataArtsDataBase + "." + setepParameter.getTable())) == null) {
            log.error("tableMetadata is null please check tableMetadata.json,tableName={}", (Object)(dataArtsDataBase + "." + setepParameter.getTable()));
        }
        if (tableMetadata != null && StringUtils.isNotEmpty((CharSequence)tableMetadata.getPartition())) {
            setepParameter.setPartition(tableMetadata.getPartition() + "=${bizdate}");
        }
        setepParameter.setBatchSize(DataArtsConstant.DW_DI_SYNC_BATCH_SIZE);
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }
}

