/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di;

import com.workflow.migration.transform.dw.converter.dataarts.convert.di.DISetpTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.ElasticStepTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.HbaseStepTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.HiveStepTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.HologresStepTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.KafkaStepTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.MongoDBStepTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.MySQLStepTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.OSSStepTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.OdpsStepTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.OracleStepTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.PostgresqlStepTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.SqlServerStepTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.annotation.DIRef;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DIHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(DIHandlerFactory.class);
    public static final Map<String, DISetpTypeHandler> handlerMap = new HashMap<String, DISetpTypeHandler>();

    public static DISetpTypeHandler getDiHandle(String name) {
        return handlerMap.get(name.toUpperCase());
    }

    public static Map<String, DISetpTypeHandler> scanDISetpTypeHandlers(Class<?> interfaceClass) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String packageName = interfaceClass.getPackage().getName();
        String path = packageName.replace('.', '/');
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> resources = classLoader.getResources(path);
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            File directory = new File(resource.getFile());
            DIHandlerFactory.findClassesByFile(directory, packageName, handlerMap, interfaceClass);
        }
        log.info("handlerMap size: {}", (Object)handlerMap.size());
        return handlerMap;
    }

    private static void findClassesByFile(File directory, String packageName, Map<String, DISetpTypeHandler> handlerMap, Class<?> interfaceClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        File[] files;
        if (!directory.exists()) {
            return;
        }
        for (File file : files = directory.listFiles()) {
            DIRef diRef;
            String className;
            Class<?> clazz;
            if (file.isDirectory()) {
                DIHandlerFactory.findClassesByFile(file, packageName + "." + file.getName(), handlerMap, interfaceClass);
                continue;
            }
            if (!file.getName().endsWith(".class") || !interfaceClass.isAssignableFrom(clazz = Class.forName(className = packageName + "." + file.getName().substring(0, file.getName().length() - 6))) || (diRef = clazz.getAnnotation(DIRef.class)) == null) continue;
            DISetpTypeHandler handler = (DISetpTypeHandler)clazz.newInstance();
            handlerMap.put(diRef.value(), handler);
        }
    }

    static {
        handlerMap.put("ODPS_STEP_TYPE", new OdpsStepTypeHandler());
        handlerMap.put("ELASTICSEARCH_STEP_TYPE", new ElasticStepTypeHandler());
        handlerMap.put("HBASE_STEP_TYPE", new HbaseStepTypeHandler());
        handlerMap.put("HIVE_STEP_TYPE", new HiveStepTypeHandler());
        handlerMap.put("HOLOGRES_STEP_TYPE", new HologresStepTypeHandler());
        handlerMap.put("KAFKA_STEP_TYPE", new KafkaStepTypeHandler());
        handlerMap.put("MONGODB_STEP_TYPE", new MongoDBStepTypeHandler());
        handlerMap.put("MYSQL_STEP_TYPE", new MySQLStepTypeHandler());
        handlerMap.put("ORACLE_STEP_TYPE", new OracleStepTypeHandler());
        handlerMap.put("OSS_STEP_TYPE", new OSSStepTypeHandler());
        handlerMap.put("POSTGRESQL_STEP_TYPE", new PostgresqlStepTypeHandler());
        handlerMap.put("SQLSERVER_STEP_TYPE", new SqlServerStepTypeHandler());
    }
}

