/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLFSubJobConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(DLFSubJobConvert.class);

    public DLFSubJobConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public DLFSubJobConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
    }

    private Boolean isNewIde() {
        Boolean isNewIde;
        try {
            isNewIde = ((JSONObject)BwmConfiguration.from((String)this.taskContext.getBwmConfiguration()).get("self")).getBoolean("if.use.dataworks.newidea");
        }
        catch (Exception e) {
            log.info("\u672a\u8bc6\u522b\u5230if.use.dataworks.newidea\u914d\u7f6e\u9879\uff0c\u9ed8\u8ba4\u5411\u65b0\u7248IDE\u8f6c\u6362\u3002");
            return true;
        }
        if (isNewIde == null) {
            log.info("\u672a\u8bc6\u522b\u5230if.use.dataworks.newidea\u914d\u7f6e\u9879\uff0c\u9ed8\u8ba4\u5411\u65b0\u7248IDE\u8f6c\u6362\u3002");
            return true;
        }
        return isNewIde;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (this.isNewIde().booleanValue()) {
            return this.newIdeConvert(workflowNodes);
        }
        return this.oldIdeConvert(workflowNodes);
    }

    private List<WorkflowNode> oldIdeConvert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> res = new ArrayList<WorkflowNode>();
        ((List)Optional.ofNullable(workflowNodes).orElse(new ArrayList())).forEach(x -> {
            WorkflowNode workflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)x, WorkflowNode.class);
            if (Objects.isNull(workflowNode)) {
                log.error("convert node failed,{}", (Object)x.getNodeName());
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_CONVERT_FAILED);
            }
            workflowNode.setNodeType(CodeProgramType.VIRTUAL.getName());
            res.add(workflowNode);
        });
        return res;
    }

    private List<WorkflowNode> newIdeConvert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> res = new ArrayList<WorkflowNode>();
        ((List)Optional.ofNullable(workflowNodes).orElse(new ArrayList())).forEach(x -> {
            WorkflowNode workflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)x, WorkflowNode.class);
            if (Objects.isNull(workflowNode)) {
                log.error("convert node failed,{}", (Object)x.getNodeName());
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_CONVERT_FAILED);
            }
            if (workflowNode.getCustomProperties() != null && workflowNode.getCustomProperties().containsKey("DLFSubJobName")) {
                String subWorkflowName = (String)workflowNode.getCustomProperties().get("DLFSubJobName");
                workflowNode.setScript(null);
                this.taskContext.getWorkflowProjectPackage().getWorkflowList().stream().filter(y -> y.getWorkflowName().equals(subWorkflowName)).findFirst().ifPresent(y -> workflowNode.setScript(y.getWorkflowId()));
                if (Objects.isNull(workflowNode.getScript())) {
                    log.error("convert node failed,{}", (Object)x.getNodeName());
                    throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_CONVERT_FAILED, (String)"\u672a\u627e\u5230\u5b50\u5de5\u4f5c\u6d41");
                }
            } else {
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_CONVERT_FAILED, (String)"\u672a\u627e\u5230DLFSubJobName");
            }
            workflowNode.setNodeType(CodeProgramType.SUB_PROCESS.getName());
            res.add(workflowNode);
        });
        return res;
    }
}

