/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.transform.di.sqoop.converter;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiDatasourceMappingConfig;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptStep;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptStepParameter;
import com.aliyun.migration.workflow.migration.common.transform.di.module.DiStepTypeHandler;
import com.aliyun.migration.workflow.migration.common.transform.di.sqoop.utils.SqoopCommandUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class HDFS2McConverter
implements DiStepTypeHandler {
    @Override
    public DiScriptStep convertToDwSourceStep(DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping config, JSONObject jobParams) {
        DiScriptStep sourceStep = new DiScriptStep();
        sourceStep.setName("Reader");
        sourceStep.setStepType("odps");
        sourceStep.setCategory("reader");
        DiScriptStepParameter stepParameter = new DiScriptStepParameter();
        stepParameter.setDatasource(config.getTgtName());
        if (jobParams.containsKey("hcatalog-table")) {
            if (jobParams.getString("hcatalog-table").startsWith(config.getSrcName())) {
                stepParameter.setTable(jobParams.getString("hcatalog-table").replaceFirst(config.getSrcName(), config.getTgtName()));
            } else {
                stepParameter.setTable(config.getTgtName() + "." + jobParams.getString("hcatalog-table"));
            }
        } else if (jobParams.containsKey("hive-table")) {
            if (jobParams.getString("hive-table").startsWith(config.getSrcName())) {
                stepParameter.setTable(jobParams.getString("hive-table").replaceFirst(config.getSrcName(), config.getTgtName()));
            } else {
                stepParameter.setTable(config.getTgtName() + "." + jobParams.getString("hive-table"));
            }
        } else if (jobParams.containsKey("export-dir")) {
            stepParameter.setTable(config.getTgtName() + "." + SqoopCommandUtils.getLastPartOfPath(jobParams.getString("export-dir")));
        } else if (jobParams.containsKey("table")) {
            if (jobParams.getString("table").startsWith(config.getSrcName())) {
                stepParameter.setTable(jobParams.getString("table").replaceFirst(config.getSrcName(), config.getTgtName()));
            } else {
                stepParameter.setTable(config.getTgtName() + "." + jobParams.getString("table"));
            }
        }
        if (jobParams.containsKey("where")) {
            stepParameter.setWhere(jobParams.getString("where"));
            stepParameter.setEnableWhere(true);
        } else {
            stepParameter.setWhere("");
            stepParameter.setEnableWhere(false);
        }
        if (jobParams.containsKey("hive-partition-key") && jobParams.containsKey("hive-partition-value")) {
            stepParameter.setPartition(List.of(jobParams.getString("hive-partition-key") + "=" + jobParams.getString("hive-partition-value")));
        }
        if (jobParams.containsKey("columns")) {
            stepParameter.setColumn(Arrays.stream(jobParams.getString("columns").split(",")).map(String::trim).collect(Collectors.toList()));
        } else {
            stepParameter.setColumn(List.of("*"));
        }
        sourceStep.setParameter(stepParameter);
        return sourceStep;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping config, JSONObject jobParams) {
        DiScriptStep destStep = new DiScriptStep();
        destStep.setName("Writer");
        destStep.setStepType("odps");
        destStep.setCategory("writer");
        DiScriptStepParameter stepParameter = new DiScriptStepParameter();
        stepParameter.setDatasource(config.getTgtName());
        if (jobParams.containsKey("hcatalog-table")) {
            if (jobParams.getString("hcatalog-table").startsWith(config.getSrcName())) {
                stepParameter.setTable(jobParams.getString("hcatalog-table").replaceFirst(config.getSrcName(), config.getTgtName()));
            } else {
                stepParameter.setTable(config.getTgtName() + "." + jobParams.getString("hcatalog-table"));
            }
        } else if (jobParams.containsKey("hive-table")) {
            if (jobParams.getString("hive-table").startsWith(config.getSrcName())) {
                stepParameter.setTable(jobParams.getString("hive-table").replaceFirst(config.getSrcName(), config.getTgtName()));
            } else {
                stepParameter.setTable(config.getTgtName() + "." + jobParams.getString("hive-table"));
            }
        } else if (jobParams.containsKey("target-dir")) {
            stepParameter.setTable(config.getTgtName() + "." + SqoopCommandUtils.getLastPartOfPath(jobParams.getString("target-dir")));
        } else if (jobParams.containsKey("table")) {
            if (jobParams.getString("table").startsWith(config.getSrcName())) {
                stepParameter.setTable(jobParams.getString("table").replaceFirst(config.getSrcName(), config.getTgtName()));
            } else {
                stepParameter.setTable(config.getTgtName() + "." + jobParams.getString("table"));
            }
        }
        if (jobParams.containsKey("where")) {
            stepParameter.setWhere(jobParams.getString("where"));
            stepParameter.setEnableWhere(true);
        } else {
            stepParameter.setWhere("");
            stepParameter.setEnableWhere(false);
        }
        if (jobParams.containsKey("hive-partition-key") && jobParams.containsKey("hive-partition-value")) {
            stepParameter.setPartition(List.of(jobParams.getString("hive-partition-key") + "=" + jobParams.getString("hive-partition-value")));
        }
        if (jobParams.containsKey("columns")) {
            stepParameter.setColumn(Arrays.stream(jobParams.getString("columns").split(",")).map(String::trim).collect(Collectors.toList()));
        } else {
            stepParameter.setColumn(List.of("*"));
        }
        destStep.setParameter(stepParameter);
        return destStep;
    }
}

