/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.transform.di.seatunnel.utils;

import com.alibaba.fastjson2.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigRenderOptions;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigResolveOptions;

public class SeatunnelUtils {
    public static JSONObject getSeatunnelConfigJsonByHoconStr(String seatunnelConfig) {
        Config config = ConfigFactory.parseString((String)seatunnelConfig).resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true)).resolveWith(ConfigFactory.systemProperties(), ConfigResolveOptions.defaults().setAllowUnresolved(true));
        ConfigRenderOptions options = ConfigRenderOptions.concise().setFormatted(true);
        JSONObject jsonObject = JSONObject.parseObject((String)config.root().render(options));
        return jsonObject;
    }

    public static JSONObject getSeatunnelConfigJson(String seatunnelConfig) {
        JSONObject jsonObject;
        try {
            jsonObject = JSONObject.parseObject((String)seatunnelConfig);
        }
        catch (Exception e) {
            jsonObject = SeatunnelUtils.getSeatunnelConfigJsonByHoconStr(seatunnelConfig);
        }
        return jsonObject;
    }

    public static Map<String, String> getHostFromUrl(String url) {
        Pattern p = Pattern.compile("jdbc:(?<dbtype>\\w+):.*((//)|@)(?<host>.+):(?<port>\\d+)(/|(;DatabaseName=)|:)(?<dbName>\\w+)\\??.*");
        Matcher m = p.matcher(url);
        if (m.find()) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("dbtype", m.group("dbtype"));
            result.put("host", m.group("host"));
            result.put("port", m.group("port"));
            result.put("dbName", m.group("dbName"));
            return result;
        }
        return null;
    }

    public static String getTableNameFromInsertIntoSql(String sql) {
        Pattern pattern = Pattern.compile("insert\\s+into\\s+(\\w+)\\s*\\(([^)]*)\\)", 2);
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            String tableName = matcher.group(1);
            return tableName;
        }
        System.out.println("\u672a\u627e\u5230\u5339\u914d\u9879");
        return null;
    }

    public static List<String> getColumnsFromInsertIntoSql(String sql) {
        Pattern pattern = Pattern.compile("insert\\s+into\\s+(\\w+)\\s*\\(([^)]*)\\)", 2);
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            String fieldsList = matcher.group(2).trim();
            return List.of((String[])Arrays.stream(fieldsList.split(",")).map(String::trim).toArray(String[]::new));
        }
        System.out.println("\u672a\u627e\u5230\u5339\u914d\u9879");
        return null;
    }
}

