/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.writer.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.annotation.SpecWriter;
import com.aliyun.dataworks.common.spec.domain.SpecEntity;
import com.aliyun.dataworks.common.spec.writer.SpecWriterContext;
import com.aliyun.dataworks.common.spec.writer.impl.AbstractWriter;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;

@SpecWriter
public class DefaultJsonObjectWriter<T extends SpecEntity>
extends AbstractWriter<T, JSONObject> {
    public DefaultJsonObjectWriter(SpecWriterContext context) {
        super(context);
    }

    @Override
    public JSONObject write(T specObj, SpecWriterContext context) {
        return this.writeJsonObject(specObj, false);
    }

    @Override
    protected JSONObject writeJsonObject(Object specObj, boolean withoutCollectionFields) {
        JSONObject json = super.writeJsonObject(specObj, withoutCollectionFields);
        if (specObj instanceof SpecEntity) {
            Optional.ofNullable(((SpecEntity)specObj).getMetadata()).filter(MapUtils::isNotEmpty).ifPresent(metadata -> json.put((Object)"metadata", metadata));
        }
        return json;
    }

    protected <R> JSONArray buildJsonArray(List<R> depends) {
        if (CollectionUtils.isEmpty(depends)) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        ListUtils.emptyIfNull(depends).stream().map(this::writeByWriter).forEach(arg_0 -> jsonArray.add(arg_0));
        return jsonArray;
    }
}

