/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.writer.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.utils.SpecDevUtil;
import com.aliyun.dataworks.common.spec.writer.SpecWriterContext;
import com.aliyun.dataworks.common.spec.writer.Writer;
import com.aliyun.dataworks.common.spec.writer.WriterFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWriter<T, V>
implements Writer<T, V> {
    private static final Logger log = LoggerFactory.getLogger(AbstractWriter.class);
    protected SpecWriterContext context;
    private final ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();

    public AbstractWriter(SpecWriterContext context) {
        this.context = context;
    }

    public boolean matchType(Class<T> t) {
        Type tType = this.parameterizedType.getActualTypeArguments()[0];
        boolean equals = Objects.equals(t, tType);
        if (equals) {
            return true;
        }
        if (tType instanceof Class) {
            return ((Class)tType).isAssignableFrom(t);
        }
        return false;
    }

    protected JSONObject writeJsonObject(Object specObj, boolean withoutCollectionFields) {
        return SpecDevUtil.writeJsonObject(specObj, withoutCollectionFields);
    }

    protected Object writeByWriter(Object specObj) {
        if (specObj == null) {
            return null;
        }
        if (specObj instanceof List) {
            return this.writerListByWriter((List)specObj);
        }
        Writer writer = WriterFactory.getWriter(specObj.getClass(), this.context);
        if (writer != null) {
            return writer.write(specObj, this.context);
        }
        return this.writeJsonObject(specObj, false);
    }

    protected JSONArray writerListByWriter(List<Object> objects) {
        if (CollectionUtils.isEmpty(objects)) {
            return null;
        }
        JSONArray arr = new JSONArray();
        ListUtils.emptyIfNull(objects).stream().map(this::writeByWriter).forEach(arg_0 -> arr.add(arg_0));
        return arr;
    }
}

