/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.codemodel;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.DefaultJsonFormCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.SpecDescribableCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecKind;
import com.aliyun.dataworks.common.spec.domain.enums.SpecVersion;
import com.aliyun.dataworks.common.spec.domain.enums.VariableScopeType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.common.spec.utils.GsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class PaiFlowCode
extends DefaultJsonFormCode
implements SpecDescribableCode<DataWorksWorkflowSpec> {
    private static final Logger log = LoggerFactory.getLogger(PaiFlowCode.class);
    private Long appId;
    private String workspaceId;
    private String name;
    private Map<String, String> computeResource;
    private String flowUniqueCode;
    private List<InOut> inputs;
    private List<InOut> outputs;
    private String paiflowArguments;
    private Map<String, String> paiflowParameters;
    private String paiflowPipeline;
    private String paraValue;
    private String prgType;
    private String requestId;
    private List<TaskRelation> taskRelations;
    private List<Task> tasks;

    @Override
    public Specification<DataWorksWorkflowSpec> getSpec() {
        Yaml yaml = new Yaml();
        yaml.setBeanAccess(BeanAccess.FIELD);
        PaiFlowSpec paiFlowSpec = Optional.ofNullable((PaiFlowSpec)yaml.loadAs(this.getPaiflowPipeline(), PaiFlowSpec.class)).orElse(new PaiFlowSpec());
        log.info("spec: {}", (Object)GsonUtils.toJsonString(paiFlowSpec));
        Specification<DataWorksWorkflowSpec> specObj = new Specification<DataWorksWorkflowSpec>();
        DataWorksWorkflowSpec dwSpec = new DataWorksWorkflowSpec();
        specObj.setVersion(SpecVersion.V_1_1_0.getLabel());
        specObj.setKind(SpecKind.PAIFLOW.getLabel());
        specObj.setSpec(dwSpec);
        dwSpec.setMetadata(paiFlowSpec.getMetadata());
        ArrayList<SpecFlowDepend> flow = new ArrayList<SpecFlowDepend>();
        List<SpecNode> nodes = Optional.ofNullable(paiFlowSpec.getSpec()).map(Spec::getPipelines).orElse(ListUtils.emptyIfNull(null)).stream().map(node -> {
            SpecNode nodeObj = new SpecNode();
            nodeObj.setMetadata(node.getMetadata());
            nodeObj.setId((String)MapUtils.emptyIfNull(node.getMetadata()).get("name"));
            nodeObj.setName((String)MapUtils.emptyIfNull(node.getMetadata()).get("displayName"));
            SpecScript script = new SpecScript();
            SpecScriptRuntime runtime = new SpecScriptRuntime();
            runtime.setEngine("PAI");
            runtime.setCommand((String)MapUtils.emptyIfNull(node.getMetadata()).get("identifier"));
            script.setRuntime(runtime);
            List parameters = Optional.ofNullable(node.getSpec()).map(spec -> (List)MapUtils.emptyIfNull(spec.getArguments()).get("parameters")).map(paraList -> ListUtils.emptyIfNull((List)paraList).stream().map(para -> {
                SpecVariable var = new SpecVariable();
                var.setName((String)para.get("name"));
                var.setValue(Optional.ofNullable(para.get("value")).map(val -> {
                    if (val instanceof String) {
                        return (String)val;
                    }
                    return GsonUtils.toJsonString(val);
                }).orElse(null));
                var.setType(VariableType.CONSTANT);
                var.setScope(VariableScopeType.NODE_PARAMETER);
                Optional.ofNullable(para.get("from")).ifPresent(from -> var.setValue((String)from));
                return var;
            }).collect(Collectors.toList())).orElse(ListUtils.emptyIfNull(null));
            script.setParameters(parameters);
            nodeObj.setScript(script);
            List depends = Optional.ofNullable(node.getSpec()).map(Spec::getDependencies).map(dependList -> ListUtils.emptyIfNull((List)dependList).stream().map(dep -> {
                SpecDepend specDepend = new SpecDepend();
                SpecNode depId = new SpecNode();
                depId.setId((String)dep);
                specDepend.setNodeId(depId);
                return specDepend;
            }).collect(Collectors.toList())).orElse(ListUtils.emptyIfNull(null));
            if (CollectionUtils.isNotEmpty((Collection)depends)) {
                SpecFlowDepend depend = new SpecFlowDepend();
                SpecNode nodeId = new SpecNode();
                nodeId.setId((String)MapUtils.emptyIfNull(node.getMetadata()).get("name"));
                depend.setNodeId(nodeId);
                depend.setDepends(depends);
                flow.add(depend);
            }
            return nodeObj;
        }).collect(Collectors.toList());
        dwSpec.setNodes(nodes);
        dwSpec.setFlow(flow);
        return specObj;
    }

    @Override
    public PaiFlowCode parse(String code) {
        return (PaiFlowCode)super.parse(code);
    }

    @Override
    public List<String> getProgramTypes() {
        return Arrays.asList(CodeProgramType.PAI_STUDIO.name(), CodeProgramType.RECOMMEND_PLUS.name());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaiFlowCode)) {
            return false;
        }
        PaiFlowCode other = (PaiFlowCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$appId = this.getAppId();
        Long other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
            return false;
        }
        String this$workspaceId = this.getWorkspaceId();
        String other$workspaceId = other.getWorkspaceId();
        if (this$workspaceId == null ? other$workspaceId != null : !this$workspaceId.equals(other$workspaceId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$computeResource = this.getComputeResource();
        Map<String, String> other$computeResource = other.getComputeResource();
        if (this$computeResource == null ? other$computeResource != null : !((Object)this$computeResource).equals(other$computeResource)) {
            return false;
        }
        String this$flowUniqueCode = this.getFlowUniqueCode();
        String other$flowUniqueCode = other.getFlowUniqueCode();
        if (this$flowUniqueCode == null ? other$flowUniqueCode != null : !this$flowUniqueCode.equals(other$flowUniqueCode)) {
            return false;
        }
        List<InOut> this$inputs = this.getInputs();
        List<InOut> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        List<InOut> this$outputs = this.getOutputs();
        List<InOut> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        String this$paiflowArguments = this.getPaiflowArguments();
        String other$paiflowArguments = other.getPaiflowArguments();
        if (this$paiflowArguments == null ? other$paiflowArguments != null : !this$paiflowArguments.equals(other$paiflowArguments)) {
            return false;
        }
        Map<String, String> this$paiflowParameters = this.getPaiflowParameters();
        Map<String, String> other$paiflowParameters = other.getPaiflowParameters();
        if (this$paiflowParameters == null ? other$paiflowParameters != null : !((Object)this$paiflowParameters).equals(other$paiflowParameters)) {
            return false;
        }
        String this$paiflowPipeline = this.getPaiflowPipeline();
        String other$paiflowPipeline = other.getPaiflowPipeline();
        if (this$paiflowPipeline == null ? other$paiflowPipeline != null : !this$paiflowPipeline.equals(other$paiflowPipeline)) {
            return false;
        }
        String this$paraValue = this.getParaValue();
        String other$paraValue = other.getParaValue();
        if (this$paraValue == null ? other$paraValue != null : !this$paraValue.equals(other$paraValue)) {
            return false;
        }
        String this$prgType = this.getPrgType();
        String other$prgType = other.getPrgType();
        if (this$prgType == null ? other$prgType != null : !this$prgType.equals(other$prgType)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        List<TaskRelation> this$taskRelations = this.getTaskRelations();
        List<TaskRelation> other$taskRelations = other.getTaskRelations();
        if (this$taskRelations == null ? other$taskRelations != null : !((Object)this$taskRelations).equals(other$taskRelations)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PaiFlowCode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
        String $workspaceId = this.getWorkspaceId();
        result = result * 59 + ($workspaceId == null ? 43 : $workspaceId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $computeResource = this.getComputeResource();
        result = result * 59 + ($computeResource == null ? 43 : ((Object)$computeResource).hashCode());
        String $flowUniqueCode = this.getFlowUniqueCode();
        result = result * 59 + ($flowUniqueCode == null ? 43 : $flowUniqueCode.hashCode());
        List<InOut> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        List<InOut> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        String $paiflowArguments = this.getPaiflowArguments();
        result = result * 59 + ($paiflowArguments == null ? 43 : $paiflowArguments.hashCode());
        Map<String, String> $paiflowParameters = this.getPaiflowParameters();
        result = result * 59 + ($paiflowParameters == null ? 43 : ((Object)$paiflowParameters).hashCode());
        String $paiflowPipeline = this.getPaiflowPipeline();
        result = result * 59 + ($paiflowPipeline == null ? 43 : $paiflowPipeline.hashCode());
        String $paraValue = this.getParaValue();
        result = result * 59 + ($paraValue == null ? 43 : $paraValue.hashCode());
        String $prgType = this.getPrgType();
        result = result * 59 + ($prgType == null ? 43 : $prgType.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        List<TaskRelation> $taskRelations = this.getTaskRelations();
        result = result * 59 + ($taskRelations == null ? 43 : ((Object)$taskRelations).hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        return result;
    }

    public Long getAppId() {
        return this.appId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getComputeResource() {
        return this.computeResource;
    }

    public String getFlowUniqueCode() {
        return this.flowUniqueCode;
    }

    public List<InOut> getInputs() {
        return this.inputs;
    }

    public List<InOut> getOutputs() {
        return this.outputs;
    }

    public String getPaiflowArguments() {
        return this.paiflowArguments;
    }

    public Map<String, String> getPaiflowParameters() {
        return this.paiflowParameters;
    }

    public String getPaiflowPipeline() {
        return this.paiflowPipeline;
    }

    public String getParaValue() {
        return this.paraValue;
    }

    public String getPrgType() {
        return this.prgType;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public List<TaskRelation> getTaskRelations() {
        return this.taskRelations;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public PaiFlowCode setAppId(Long appId) {
        this.appId = appId;
        return this;
    }

    public PaiFlowCode setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    public PaiFlowCode setName(String name) {
        this.name = name;
        return this;
    }

    public PaiFlowCode setComputeResource(Map<String, String> computeResource) {
        this.computeResource = computeResource;
        return this;
    }

    public PaiFlowCode setFlowUniqueCode(String flowUniqueCode) {
        this.flowUniqueCode = flowUniqueCode;
        return this;
    }

    public PaiFlowCode setInputs(List<InOut> inputs) {
        this.inputs = inputs;
        return this;
    }

    public PaiFlowCode setOutputs(List<InOut> outputs) {
        this.outputs = outputs;
        return this;
    }

    public PaiFlowCode setPaiflowArguments(String paiflowArguments) {
        this.paiflowArguments = paiflowArguments;
        return this;
    }

    public PaiFlowCode setPaiflowParameters(Map<String, String> paiflowParameters) {
        this.paiflowParameters = paiflowParameters;
        return this;
    }

    public PaiFlowCode setPaiflowPipeline(String paiflowPipeline) {
        this.paiflowPipeline = paiflowPipeline;
        return this;
    }

    public PaiFlowCode setParaValue(String paraValue) {
        this.paraValue = paraValue;
        return this;
    }

    public PaiFlowCode setPrgType(String prgType) {
        this.prgType = prgType;
        return this;
    }

    public PaiFlowCode setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public PaiFlowCode setTaskRelations(List<TaskRelation> taskRelations) {
        this.taskRelations = taskRelations;
        return this;
    }

    public PaiFlowCode setTasks(List<Task> tasks) {
        this.tasks = tasks;
        return this;
    }

    @Override
    public String toString() {
        return "PaiFlowCode(appId=" + this.getAppId() + ", workspaceId=" + this.getWorkspaceId() + ", name=" + this.getName() + ", computeResource=" + this.getComputeResource() + ", flowUniqueCode=" + this.getFlowUniqueCode() + ", inputs=" + this.getInputs() + ", outputs=" + this.getOutputs() + ", paiflowArguments=" + this.getPaiflowArguments() + ", paiflowParameters=" + this.getPaiflowParameters() + ", paiflowPipeline=" + this.getPaiflowPipeline() + ", paraValue=" + this.getParaValue() + ", prgType=" + this.getPrgType() + ", requestId=" + this.getRequestId() + ", taskRelations=" + this.getTaskRelations() + ", tasks=" + this.getTasks() + ")";
    }

    public static class PaiFlowSpec {
        private String apiVersion;
        private Map<String, Object> metadata;
        private Spec spec;

        public String getApiVersion() {
            return this.apiVersion;
        }

        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        public Spec getSpec() {
            return this.spec;
        }

        public PaiFlowSpec setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public PaiFlowSpec setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public PaiFlowSpec setSpec(Spec spec) {
            this.spec = spec;
            return this;
        }

        public String toString() {
            return "PaiFlowCode.PaiFlowSpec(apiVersion=" + this.getApiVersion() + ", metadata=" + this.getMetadata() + ", spec=" + this.getSpec() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaiFlowSpec)) {
                return false;
            }
            PaiFlowSpec other = (PaiFlowSpec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$apiVersion = this.getApiVersion();
            String other$apiVersion = other.getApiVersion();
            if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
                return false;
            }
            Map<String, Object> this$metadata = this.getMetadata();
            Map<String, Object> other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            Spec this$spec = this.getSpec();
            Spec other$spec = other.getSpec();
            return !(this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PaiFlowSpec;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $apiVersion = this.getApiVersion();
            result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
            Map<String, Object> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            Spec $spec = this.getSpec();
            result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
            return result;
        }
    }

    public static final class Spec
    extends PaiFlowSpec {
        private Map<String, List<Map<String, Object>>> inputs;
        private Map<String, List<Map<String, Object>>> outputs;
        private Map<String, List<Map<String, Object>>> arguments;
        private List<String> dependencies;
        private List<Object> initContainers;
        private List<Object> sideCarContainers;
        private List<Object> volumes;
        private List<PaiFlowSpec> pipelines;

        public Map<String, List<Map<String, Object>>> getInputs() {
            return this.inputs;
        }

        public Map<String, List<Map<String, Object>>> getOutputs() {
            return this.outputs;
        }

        public Map<String, List<Map<String, Object>>> getArguments() {
            return this.arguments;
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }

        public List<Object> getInitContainers() {
            return this.initContainers;
        }

        public List<Object> getSideCarContainers() {
            return this.sideCarContainers;
        }

        public List<Object> getVolumes() {
            return this.volumes;
        }

        public List<PaiFlowSpec> getPipelines() {
            return this.pipelines;
        }

        public Spec setInputs(Map<String, List<Map<String, Object>>> inputs) {
            this.inputs = inputs;
            return this;
        }

        public Spec setOutputs(Map<String, List<Map<String, Object>>> outputs) {
            this.outputs = outputs;
            return this;
        }

        public Spec setArguments(Map<String, List<Map<String, Object>>> arguments) {
            this.arguments = arguments;
            return this;
        }

        public Spec setDependencies(List<String> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public Spec setInitContainers(List<Object> initContainers) {
            this.initContainers = initContainers;
            return this;
        }

        public Spec setSideCarContainers(List<Object> sideCarContainers) {
            this.sideCarContainers = sideCarContainers;
            return this;
        }

        public Spec setVolumes(List<Object> volumes) {
            this.volumes = volumes;
            return this;
        }

        public Spec setPipelines(List<PaiFlowSpec> pipelines) {
            this.pipelines = pipelines;
            return this;
        }

        @Override
        public String toString() {
            return "PaiFlowCode.Spec(inputs=" + this.getInputs() + ", outputs=" + this.getOutputs() + ", arguments=" + this.getArguments() + ", dependencies=" + this.getDependencies() + ", initContainers=" + this.getInitContainers() + ", sideCarContainers=" + this.getSideCarContainers() + ", volumes=" + this.getVolumes() + ", pipelines=" + this.getPipelines() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Spec)) {
                return false;
            }
            Spec other = (Spec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, List<Map<String, Object>>> this$inputs = this.getInputs();
            Map<String, List<Map<String, Object>>> other$inputs = other.getInputs();
            if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
                return false;
            }
            Map<String, List<Map<String, Object>>> this$outputs = this.getOutputs();
            Map<String, List<Map<String, Object>>> other$outputs = other.getOutputs();
            if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
                return false;
            }
            Map<String, List<Map<String, Object>>> this$arguments = this.getArguments();
            Map<String, List<Map<String, Object>>> other$arguments = other.getArguments();
            if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
                return false;
            }
            List<String> this$dependencies = this.getDependencies();
            List<String> other$dependencies = other.getDependencies();
            if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
                return false;
            }
            List<Object> this$initContainers = this.getInitContainers();
            List<Object> other$initContainers = other.getInitContainers();
            if (this$initContainers == null ? other$initContainers != null : !((Object)this$initContainers).equals(other$initContainers)) {
                return false;
            }
            List<Object> this$sideCarContainers = this.getSideCarContainers();
            List<Object> other$sideCarContainers = other.getSideCarContainers();
            if (this$sideCarContainers == null ? other$sideCarContainers != null : !((Object)this$sideCarContainers).equals(other$sideCarContainers)) {
                return false;
            }
            List<Object> this$volumes = this.getVolumes();
            List<Object> other$volumes = other.getVolumes();
            if (this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes)) {
                return false;
            }
            List<PaiFlowSpec> this$pipelines = this.getPipelines();
            List<PaiFlowSpec> other$pipelines = other.getPipelines();
            return !(this$pipelines == null ? other$pipelines != null : !((Object)this$pipelines).equals(other$pipelines));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Spec;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, List<Map<String, Object>>> $inputs = this.getInputs();
            result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
            Map<String, List<Map<String, Object>>> $outputs = this.getOutputs();
            result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
            Map<String, List<Map<String, Object>>> $arguments = this.getArguments();
            result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
            List<String> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            List<Object> $initContainers = this.getInitContainers();
            result = result * 59 + ($initContainers == null ? 43 : ((Object)$initContainers).hashCode());
            List<Object> $sideCarContainers = this.getSideCarContainers();
            result = result * 59 + ($sideCarContainers == null ? 43 : ((Object)$sideCarContainers).hashCode());
            List<Object> $volumes = this.getVolumes();
            result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
            List<PaiFlowSpec> $pipelines = this.getPipelines();
            result = result * 59 + ($pipelines == null ? 43 : ((Object)$pipelines).hashCode());
            return result;
        }
    }

    public static final class Task {
        private Boolean root = true;
        private String taskName;
        private String taskUniqueCode;

        public Boolean getRoot() {
            return this.root;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public String getTaskUniqueCode() {
            return this.taskUniqueCode;
        }

        public Task setRoot(Boolean root) {
            this.root = root;
            return this;
        }

        public Task setTaskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public Task setTaskUniqueCode(String taskUniqueCode) {
            this.taskUniqueCode = taskUniqueCode;
            return this;
        }

        public String toString() {
            return "PaiFlowCode.Task(root=" + this.getRoot() + ", taskName=" + this.getTaskName() + ", taskUniqueCode=" + this.getTaskUniqueCode() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Task)) {
                return false;
            }
            Task other = (Task)o;
            Boolean this$root = this.getRoot();
            Boolean other$root = other.getRoot();
            if (this$root == null ? other$root != null : !((Object)this$root).equals(other$root)) {
                return false;
            }
            String this$taskName = this.getTaskName();
            String other$taskName = other.getTaskName();
            if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
                return false;
            }
            String this$taskUniqueCode = this.getTaskUniqueCode();
            String other$taskUniqueCode = other.getTaskUniqueCode();
            return !(this$taskUniqueCode == null ? other$taskUniqueCode != null : !this$taskUniqueCode.equals(other$taskUniqueCode));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $root = this.getRoot();
            result = result * 59 + ($root == null ? 43 : ((Object)$root).hashCode());
            String $taskName = this.getTaskName();
            result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
            String $taskUniqueCode = this.getTaskUniqueCode();
            result = result * 59 + ($taskUniqueCode == null ? 43 : $taskUniqueCode.hashCode());
            return result;
        }
    }

    public static final class TaskRelation {
        private String childTaskUniqueCode;
        private String parentTaskUniqueCode;

        public String getChildTaskUniqueCode() {
            return this.childTaskUniqueCode;
        }

        public String getParentTaskUniqueCode() {
            return this.parentTaskUniqueCode;
        }

        public TaskRelation setChildTaskUniqueCode(String childTaskUniqueCode) {
            this.childTaskUniqueCode = childTaskUniqueCode;
            return this;
        }

        public TaskRelation setParentTaskUniqueCode(String parentTaskUniqueCode) {
            this.parentTaskUniqueCode = parentTaskUniqueCode;
            return this;
        }

        public String toString() {
            return "PaiFlowCode.TaskRelation(childTaskUniqueCode=" + this.getChildTaskUniqueCode() + ", parentTaskUniqueCode=" + this.getParentTaskUniqueCode() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskRelation)) {
                return false;
            }
            TaskRelation other = (TaskRelation)o;
            String this$childTaskUniqueCode = this.getChildTaskUniqueCode();
            String other$childTaskUniqueCode = other.getChildTaskUniqueCode();
            if (this$childTaskUniqueCode == null ? other$childTaskUniqueCode != null : !this$childTaskUniqueCode.equals(other$childTaskUniqueCode)) {
                return false;
            }
            String this$parentTaskUniqueCode = this.getParentTaskUniqueCode();
            String other$parentTaskUniqueCode = other.getParentTaskUniqueCode();
            return !(this$parentTaskUniqueCode == null ? other$parentTaskUniqueCode != null : !this$parentTaskUniqueCode.equals(other$parentTaskUniqueCode));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $childTaskUniqueCode = this.getChildTaskUniqueCode();
            result = result * 59 + ($childTaskUniqueCode == null ? 43 : $childTaskUniqueCode.hashCode());
            String $parentTaskUniqueCode = this.getParentTaskUniqueCode();
            result = result * 59 + ($parentTaskUniqueCode == null ? 43 : $parentTaskUniqueCode.hashCode());
            return result;
        }
    }

    public static final class InOut {
        private String type;
        private String value;

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public InOut setType(String type) {
            this.type = type;
            return this;
        }

        public InOut setValue(String value) {
            this.value = value;
            return this;
        }

        public String toString() {
            return "PaiFlowCode.InOut(type=" + this.getType() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InOut)) {
                return false;
            }
            InOut other = (InOut)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

