/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.codemodel;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.AbstractBaseCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrJobType;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrLauncher;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrProperty;
import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.utils.JSONUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;

public class EmrCode
extends AbstractBaseCode {
    public static final String ENVS_KEY_FLOW_SKIP_SQL_ANALYZE = "FLOW_SKIP_SQL_ANALYZE";
    private String name;
    private EmrJobType type;
    private EmrLauncher launcher = new EmrLauncher();
    private EmrProperty properties = new EmrProperty();
    private String description;

    @Override
    public EmrCode parse(String code) {
        EmrCode m = JSONUtils.parseObject(code, EmrCode.class);
        Optional.ofNullable(m).ifPresent(mm -> {
            this.setName(mm.getName());
            this.setType(mm.getType());
            this.setLauncher(mm.getLauncher());
            this.setProperties(mm.getProperties());
            this.setDescription(mm.getDescription());
        });
        this.setType(Optional.ofNullable(this.getType()).orElse(EmrCode.getEmrJobType(this.programType)));
        return this;
    }

    public static EmrJobType getEmrJobType(String defaultNodeType) {
        CodeProgramType codeProgramType = CodeProgramType.getNodeTypeByName(defaultNodeType);
        if (defaultNodeType == null) {
            return null;
        }
        switch (codeProgramType) {
            case HIVE: 
            case EMR_HIVE_CLI: {
                return EmrJobType.HIVE;
            }
            case EMR_HIVE: {
                return EmrJobType.HIVE_SQL;
            }
            case EMR_SPARK_SQL: {
                return EmrJobType.SPARK_SQL;
            }
            case EMR_SPARK_SHELL: {
                return EmrJobType.SPARK_SHELL;
            }
            case EMR_SPARK_STREAMING: {
                return EmrJobType.SPARK_STREAMING;
            }
            case EMR_SPARK: {
                return EmrJobType.SPARK;
            }
            case EMR_IMPALA: {
                return EmrJobType.IMPALA_SQL;
            }
            case EMR_PRESTO: {
                return EmrJobType.PRESTO_SQL;
            }
            case EMR_TRINO: {
                return EmrJobType.TRINO_SQL;
            }
            case EMR_MR: {
                return EmrJobType.MR;
            }
            case EMR_SCOOP: {
                return EmrJobType.SQOOP;
            }
            case EMR_SHELL: {
                return EmrJobType.SHELL;
            }
            case EMR_KYUUBI: {
                return EmrJobType.KYUUBI;
            }
        }
        return null;
    }

    @Override
    public List<String> getProgramTypes() {
        return Arrays.stream(CodeProgramType.values()).map(Enum::name).filter(named -> CodeProgramType.matchEngine(named, CalcEngineType.EMR)).collect(Collectors.toList());
    }

    @Override
    public void setSourceCode(String sourceCode) {
        if (this.properties == null) {
            this.properties = new EmrProperty();
        }
        if (this.properties.getArguments() == null) {
            this.properties.setArguments(new ArrayList<String>());
        }
        Optional.ofNullable(sourceCode).ifPresent(code -> {
            this.properties.getArguments().clear();
            this.properties.getArguments().add(0, (String)code);
        });
    }

    @Override
    public String getSourceCode() {
        return Optional.ofNullable(this.properties).map(EmrProperty::getArguments).orElse(ListUtils.emptyIfNull(null)).stream().findFirst().orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmrCode)) {
            return false;
        }
        EmrCode other = (EmrCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        EmrJobType this$type = this.getType();
        EmrJobType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        EmrLauncher this$launcher = this.getLauncher();
        EmrLauncher other$launcher = other.getLauncher();
        if (this$launcher == null ? other$launcher != null : !((Object)this$launcher).equals(other$launcher)) {
            return false;
        }
        EmrProperty this$properties = this.getProperties();
        EmrProperty other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EmrCode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        EmrJobType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        EmrLauncher $launcher = this.getLauncher();
        result = result * 59 + ($launcher == null ? 43 : ((Object)$launcher).hashCode());
        EmrProperty $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public EmrJobType getType() {
        return this.type;
    }

    public EmrLauncher getLauncher() {
        return this.launcher;
    }

    public EmrProperty getProperties() {
        return this.properties;
    }

    public String getDescription() {
        return this.description;
    }

    public EmrCode setName(String name) {
        this.name = name;
        return this;
    }

    public EmrCode setType(EmrJobType type) {
        this.type = type;
        return this;
    }

    public EmrCode setLauncher(EmrLauncher launcher) {
        this.launcher = launcher;
        return this;
    }

    public EmrCode setProperties(EmrProperty properties) {
        this.properties = properties;
        return this;
    }

    public EmrCode setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String toString() {
        return "EmrCode(name=" + this.getName() + ", type=" + this.getType() + ", launcher=" + this.getLauncher() + ", properties=" + this.getProperties() + ", description=" + this.getDescription() + ")";
    }
}

