/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.codemodel;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.Code;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CodeModel<T extends Code>
implements Code {
    protected String programType;
    protected T codeModel;

    @Override
    public String getContent() {
        return Optional.ofNullable(this.codeModel).map(Code::getContent).orElse(null);
    }

    @Override
    public String getRawContent() {
        return Optional.ofNullable(this.codeModel).map(Code::getRawContent).orElse(null);
    }

    @Override
    public void setSourceCode(String sourceCode) {
        Optional.ofNullable(this.codeModel).ifPresent(cm -> cm.setSourceCode(sourceCode));
    }

    @Override
    public String getSourceCode() {
        return Optional.ofNullable(this.codeModel).map(Code::getSourceCode).orElse(null);
    }

    @Override
    public void setProgramType(String programType) {
        this.programType = programType;
    }

    @Override
    public Code parse(String code) {
        return Optional.ofNullable(this.codeModel).map(m -> {
            m.setProgramType(this.programType);
            return m.parse(code);
        }).orElse((Code)this.codeModel);
    }

    @Override
    public List<String> getResourceReferences() {
        return Optional.ofNullable(this.codeModel).map(Code::getResourceReferences).orElse(null);
    }

    @Override
    public Map<String, Object> getTemplate() {
        return Optional.ofNullable(this.codeModel).map(Code::getTemplate).orElse(null);
    }

    @Override
    public List<String> getProgramTypes() {
        if (this.programType == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.programType);
    }

    @Override
    public int getClassHierarchyLevel() {
        return 0;
    }

    public String getProgramType() {
        return this.programType;
    }

    public CodeModel<T> setCodeModel(T codeModel) {
        this.codeModel = codeModel;
        return this;
    }

    public String toString() {
        return "CodeModel(programType=" + this.getProgramType() + ", codeModel=" + this.getCodeModel() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeModel)) {
            return false;
        }
        CodeModel other = (CodeModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$programType = this.getProgramType();
        String other$programType = other.getProgramType();
        if (this$programType == null ? other$programType != null : !this$programType.equals(other$programType)) {
            return false;
        }
        T this$codeModel = this.getCodeModel();
        T other$codeModel = other.getCodeModel();
        return !(this$codeModel == null ? other$codeModel != null : !this$codeModel.equals(other$codeModel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CodeModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $programType = this.getProgramType();
        result = result * 59 + ($programType == null ? 43 : $programType.hashCode());
        T $codeModel = this.getCodeModel();
        result = result * 59 + ($codeModel == null ? 43 : $codeModel.hashCode());
        return result;
    }

    public T getCodeModel() {
        return this.codeModel;
    }
}

