/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.adapter;

import com.aliyun.dataworks.common.spec.adapter.SpecEntityHandler;
import com.aliyun.dataworks.common.spec.adapter.SpecHandlerContext;
import com.aliyun.dataworks.common.spec.adapter.handler.AbstractEntityHandler;
import com.aliyun.dataworks.common.spec.domain.SpecEntity;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecAdapter<E, T extends SpecEntity> {
    private static final Logger log = LoggerFactory.getLogger(SpecAdapter.class);
    private final Set<Class<? extends AbstractEntityHandler<E, T>>> specEntityHandlers = new HashSet<Class<? extends AbstractEntityHandler<E, T>>>();
    private Class<? extends AbstractEntityHandler<E, T>> defaultHandler;

    public synchronized void registerHandler(Class<? extends AbstractEntityHandler<E, T>> handler) {
        this.specEntityHandlers.add(handler);
    }

    public synchronized void setDefaultHandler(Class<? extends AbstractEntityHandler<E, T>> defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public SpecEntityHandler<E, T> getHandler(E entity, Locale locale) {
        if (entity == null) {
            return null;
        }
        log.info("entity type: {}", entity.getClass());
        SpecHandlerContext context = new SpecHandlerContext();
        context.setSpecAdapter(this);
        context.setLocale(locale);
        List matchedNodeSpecHandler = SetUtils.emptyIfNull(this.specEntityHandlers).stream().map(this::newHandlerInstance).peek(handler -> handler.setContext(context)).filter(handler -> handler.support(entity)).sorted(Comparator.comparing(handler -> -1 * handler.getClassHierarchyLevel())).collect(Collectors.toList());
        log.info("node spec handlers: {}", ListUtils.emptyIfNull(matchedNodeSpecHandler).stream().map(Object::getClass).map(Class::getName).collect(Collectors.toList()));
        Optional opt = matchedNodeSpecHandler.stream().findFirst();
        if (opt.isPresent()) {
            log.info("use the first spec handler: {}", opt.get());
            return (SpecEntityHandler)opt.get();
        }
        AbstractEntityHandler<E, T> handler2 = this.newHandlerInstance(this.defaultHandler);
        handler2.setContext(context);
        log.info("use the default spec handler: {}", this.defaultHandler);
        return handler2;
    }

    private AbstractEntityHandler<E, T> newHandlerInstance(Class<?> handlerClz) {
        try {
            return (AbstractEntityHandler)handlerClz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

