/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.common.spec.domain.Spec;
import com.aliyun.dataworks.common.spec.domain.SpecEntity;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.exception.SpecErrorCode;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import com.aliyun.dataworks.common.spec.parser.Parser;
import com.aliyun.dataworks.common.spec.parser.SpecParserContext;
import com.aliyun.dataworks.common.spec.parser.SpecParserFactory;
import com.aliyun.dataworks.common.spec.parser.ToDomainRootParser;
import com.aliyun.dataworks.common.spec.utils.ParserUtil;
import com.aliyun.dataworks.common.spec.utils.SpecDevUtil;
import com.aliyun.dataworks.common.spec.writer.SpecWriterContext;
import com.aliyun.dataworks.common.spec.writer.WriterFactory;
import com.aliyun.dataworks.common.spec.writer.impl.SpecificationWriter;
import com.google.common.base.Preconditions;
import java.util.Optional;

public class SpecUtil {
    private SpecUtil() {
    }

    public static <T extends Spec> Specification<T> parseToDomain(String spec) {
        if (spec == null) {
            return null;
        }
        return new ToDomainRootParser().parseToDomain(spec);
    }

    public static <T extends Spec> String writeToSpec(Specification<T> specification) {
        if (specification == null) {
            return null;
        }
        Preconditions.checkNotNull((Object)specification.getVersion(), (Object)"version is null");
        Preconditions.checkNotNull(specification.getSpec(), (Object)"spec is null");
        Preconditions.checkNotNull((Object)specification.getKind(), (Object)"kind is null");
        SpecWriterContext context = new SpecWriterContext();
        context.setVersion(specification.getVersion());
        SpecificationWriter writer = (SpecificationWriter)WriterFactory.getWriter(specification.getClass(), context);
        if (writer == null) {
            throw new SpecException(SpecErrorCode.PARSER_LOAD_ERROR, "no available registered writer found for type: " + specification.getClass());
        }
        return JSON.toJSONString((Object)writer.write(specification, context), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat, JSONWriter.Feature.WriteEnumsUsingName, JSONWriter.Feature.LargeObject});
    }

    public static <T> Object write(T specObject, SpecWriterContext context) {
        if (specObject == null) {
            return null;
        }
        return Optional.ofNullable(WriterFactory.getWriter(specObject.getClass(), context)).map(writer -> writer.write(specObject, context)).orElse(SpecDevUtil.writeJsonObject(specObject, false));
    }

    public static <T extends SpecEntity> T parse(String json, Class specCls, SpecParserContext context) {
        Parser<?> parser = SpecParserFactory.getParser(specCls.getSimpleName());
        Preconditions.checkNotNull(parser, (Object)(specCls.getSimpleName() + " parser not found"));
        return (T)((SpecEntity)parser.parse(ParserUtil.jsonToMap(JSON.parseObject((String)json)), context));
    }
}

