/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.transform.plain.converter.module;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.DataworksMxConverter;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainConverter
extends DataworksMxConverter {
    private static final Logger log = LoggerFactory.getLogger(PlainConverter.class);

    public WorkflowProjectPackage convertSelf() {
        WorkflowProjectPackage workflowProjectPackage = this.getWorkflowPackage();
        if (Objects.isNull(workflowProjectPackage)) {
            log.warn("not found flow package");
            return null;
        }
        this.taskContext.setWorkflowProjectPackage(workflowProjectPackage);
        if (workflowProjectPackage.getWorkflowProject() != null) {
            String projectId = workflowProjectPackage.getWorkflowProject().getProjectId();
            String projectName = workflowProjectPackage.getWorkflowProject().getName();
            if (workflowProjectPackage.getWorkflowList() != null) {
                for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
                    String workflowId = workflow.getWorkflowId();
                    String workflowName = workflow.getWorkflowName();
                    workflow.setProjectId(projectId);
                    workflow.setProjectName(projectName);
                    if (workflow.getWorkflowNodes() == null) continue;
                    for (WorkflowNode workflowNode : workflow.getWorkflowNodes()) {
                        workflowNode.setProjectId(projectId);
                        workflowNode.setProjectName(projectName);
                        workflowNode.setWorkflowId(workflowId);
                        workflowNode.setWorkflowName(workflowName);
                    }
                }
            }
        }
        return (WorkflowProjectPackage)BwmJsonUtil.deepCopy((Object)workflowProjectPackage, WorkflowProjectPackage.class);
    }
}

