/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dsv2.converter;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.ProcessTaskRelation;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.Schedule;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.Flag;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.process.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.sql.SqlParameters;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.utils.BwmCommonUtil;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dolphinv22WorkflowConvert {
    private static final Logger log = LoggerFactory.getLogger(Dolphinv22WorkflowConvert.class);

    public WorkflowProjectPackage convert(DolphinSchedulerPackage aPackage) {
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        Object projectsObj = aPackage.getProjects().get(0);
        Project project = (Project)BwmJsonUtil.deepCopy(projectsObj, Project.class);
        workflowProjectPackage.setWorkflowProject(this.convertProject(Objects.requireNonNull(project)));
        List datasources = aPackage.getDatasources();
        List datasourceList = datasources.stream().map(this::convertDataSource).collect(Collectors.toList());
        workflowProjectPackage.setDatasources(datasourceList);
        List resources = aPackage.getResources();
        List resourceList = resources.stream().map(this::convertResource).collect(Collectors.toList());
        workflowProjectPackage.setFiles(resourceList);
        List functions = aPackage.getUdfFuncs();
        List functionList = functions.stream().map(this::convertFunction).collect(Collectors.toList());
        workflowProjectPackage.setFunctions(functionList);
        ArrayList workflows = new ArrayList();
        aPackage.getProcessDefinitions().values().forEach(x -> workflows.addAll((List)x));
        List workflowList = workflows.stream().map(x -> {
            Workflow workflow = this.convertWorkflow((DagData)x);
            workflow.setFiles(resourceList);
            workflow.setFunctions(functionList);
            return workflow;
        }).collect(Collectors.toList());
        workflowProjectPackage.setWorkflowList(workflowList);
        return workflowProjectPackage;
    }

    private WorkflowProject convertProject(Project dolphinData) {
        WorkflowProject workflowProject = new WorkflowProject();
        workflowProject.setProjectId(dolphinData.getCode());
        workflowProject.setName(dolphinData.getName());
        workflowProject.setDescription(dolphinData.getDescription());
        return workflowProject;
    }

    private WorkflowDatasource convertDataSource(DataSource dolphinData) {
        WorkflowDatasource datasource = new WorkflowDatasource();
        datasource.setName(dolphinData.getName());
        datasource.setDatasourceId(Integer.toString(dolphinData.getId()));
        String connectionParams = dolphinData.getConnectionParams();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        try {
            Map map = (Map)GsonUtils.defaultGson.fromJson(connectionParams, type);
            datasource.setCustomProperties(map);
        }
        catch (Exception e) {
            log.error("map.convert.error", (Throwable)e);
        }
        return datasource;
    }

    private WorkflowFileResource convertResource(ResourceInfo dolphinData) {
        WorkflowFileResource workflowFileResource = new WorkflowFileResource();
        workflowFileResource.setId(String.valueOf(dolphinData.getId()));
        workflowFileResource.setFileId(String.valueOf(dolphinData.getId()));
        workflowFileResource.setProjectId(null);
        workflowFileResource.setName(dolphinData.getFullName());
        workflowFileResource.setFileType(dolphinData.getType());
        workflowFileResource.setPath(dolphinData.getRes());
        workflowFileResource.setDescription(null);
        return workflowFileResource;
    }

    private WorkflowFunctionResource convertFunction(UdfFunc dolphinData) {
        WorkflowFunctionResource workflowFunctionResource = new WorkflowFunctionResource();
        workflowFunctionResource.setId(String.valueOf(dolphinData.getId()));
        workflowFunctionResource.setFunctionId(String.valueOf(dolphinData.getId()));
        workflowFunctionResource.setFunctionId(String.valueOf(dolphinData.getId()));
        workflowFunctionResource.setName(dolphinData.getFuncName());
        workflowFunctionResource.setType(dolphinData.getType().getDescp());
        workflowFunctionResource.setClassName(dolphinData.getClassName());
        workflowFunctionResource.setFileResources(String.valueOf(dolphinData.getResourceId()));
        workflowFunctionResource.setUsageDescription(dolphinData.getDescription());
        workflowFunctionResource.setArgumentsDescription(dolphinData.getArgTypes());
        return workflowFunctionResource;
    }

    private Workflow convertWorkflow(DagData dolphinData) {
        Workflow workflow = new Workflow();
        workflow.setProjectName(dolphinData.getProcessDefinition().getProjectName());
        workflow.setWorkflowName(dolphinData.getProcessDefinition().getName());
        workflow.setDescription(dolphinData.getProcessDefinition().getDescription());
        workflow.setCustomProperties(BwmCommonUtil.convertObjMap((Map)dolphinData.getProcessDefinition().getGlobalParamMap()));
        workflow.setWorkflowId(String.valueOf(dolphinData.getProcessDefinition().getCode()));
        workflow.setOwner(String.valueOf(dolphinData.getProcessDefinition().getUserId()));
        List workflowNodes = dolphinData.getTaskDefinitionList().stream().collect(Collectors.groupingBy(TaskDefinition::getCode, Collectors.reducing((x, y) -> y))).values().stream().map(x -> {
            WorkflowNode workflowNode = this.convertNode((TaskDefinition)x.get());
            return workflowNode;
        }).collect(Collectors.toList());
        workflow.setWorkflowNodes(workflowNodes);
        Map<String, WorkflowNode> nodeMap = workflowNodes.stream().collect(Collectors.toMap(WorkflowNode::getNodeId, x -> x));
        List processDefinitionConnects = dolphinData.getProcessTaskRelationList();
        List<RelationPackage> relationPackages = this.dealNodeRelation(processDefinitionConnects);
        workflow.setNodeRelations(relationPackages);
        processDefinitionConnects.forEach(x -> {
            if (x.getPreTaskCode() != 0L) {
                String endPointSourceId = String.valueOf(x.getPreTaskCode());
                String endPointTargetId = String.valueOf(x.getPostTaskCode());
                WorkflowNode sourceNode = (WorkflowNode)nodeMap.get(endPointSourceId);
                ArrayList<WorkflowNode> children = sourceNode.getChildren();
                if (CollectionUtils.isEmpty((Collection)children)) {
                    children = new ArrayList<WorkflowNode>();
                }
                WorkflowNode targetNode = (WorkflowNode)nodeMap.get(endPointTargetId);
                children.add(targetNode);
            }
        });
        WorkflowTrigger workflowTrigger = this.convertTrigger(dolphinData.getSchedule());
        workflow.setTriggers(Collections.singletonList(workflowTrigger));
        return workflow;
    }

    private List<RelationPackage> dealNodeRelation(List<ProcessTaskRelation> processDefinitionConnects) {
        return ((List)Optional.ofNullable(processDefinitionConnects).orElse(new ArrayList())).stream().map(x -> {
            if (x.getPreTaskCode() != 0L) {
                String endPointSourceId = String.valueOf(x.getPreTaskCode());
                String endPointTargetId = String.valueOf(x.getPostTaskCode());
                return RelationPackage.builder().from(endPointSourceId).to(endPointTargetId).reType(RelationPackage.ReType.NODE).build();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private WorkflowNode convertNode(TaskDefinition dolphinTask) {
        WorkflowNode workflowNode = new WorkflowNode();
        workflowNode.setProjectId(String.valueOf(dolphinTask.getProjectCode()));
        workflowNode.setProjectName(dolphinTask.getProjectName());
        workflowNode.setNodeId(String.valueOf(dolphinTask.getCode()));
        workflowNode.setNodeName(dolphinTask.getName());
        workflowNode.setOwner(String.valueOf(dolphinTask.getUserId()));
        workflowNode.setDescription(dolphinTask.getDescription());
        workflowNode.setNodeType(dolphinTask.getTaskType());
        workflowNode.setScript(dolphinTask.getTaskParams());
        if (dolphinTask.getFlag().equals((Object)Flag.NO)) {
            workflowNode.setState(WorkflowNode.Recurrence.SKIP);
        } else {
            workflowNode.setState(WorkflowNode.Recurrence.NORMAL);
        }
        if (dolphinTask.getTaskType().equals("SQL")) {
            SqlParameters parameter = (SqlParameters)GsonUtils.fromJsonString((String)dolphinTask.getTaskParams(), (Type)TypeToken.get(SqlParameters.class).getType());
            String dbType = parameter.getType();
            workflowNode.setDbType(dbType);
            workflowNode.setScript(this.extract(dolphinTask.getTaskParams()));
        }
        workflowNode.setTimeout(Integer.valueOf(dolphinTask.getTimeout()));
        workflowNode.setPriority(Integer.valueOf(dolphinTask.getTaskPriority().getCode()));
        workflowNode.setVersion(String.valueOf(dolphinTask.getVersion()));
        workflowNode.setParamMap(BwmCommonUtil.convertObjMap((Map)dolphinTask.getTaskParamMap()));
        return workflowNode;
    }

    private WorkflowTrigger convertTrigger(Schedule dolphinSchedule) {
        WorkflowTrigger workflowTrigger = new WorkflowTrigger();
        if (Objects.isNull(dolphinSchedule)) {
            log.info("no dolphinSchedule find");
            return workflowTrigger;
        }
        workflowTrigger.setProjectName(dolphinSchedule.getProjectName());
        workflowTrigger.setName(String.valueOf(dolphinSchedule.getId()));
        workflowTrigger.setCron(dolphinSchedule.getCrontab());
        workflowTrigger.setTimezone(ZoneId.of(dolphinSchedule.getTimezoneId()));
        workflowTrigger.setStartTime(dolphinSchedule.getStartTime().toInstant().atZone(workflowTrigger.getTimezone()).toLocalDateTime());
        workflowTrigger.setEndTime(dolphinSchedule.getEndTime().toInstant().atZone(workflowTrigger.getTimezone()).toLocalDateTime());
        workflowTrigger.setDescription(dolphinSchedule.getDefinitionDescription());
        return workflowTrigger;
    }

    private String extract(String param) {
        try {
            JSONObject jsonObject = JSON.parseObject((String)param);
            String sql = jsonObject.getString("sql");
            if (StringUtils.isBlank((CharSequence)sql)) {
                return param;
            }
            return sql;
        }
        catch (Exception e) {
            log.error("extract sql error ", (Throwable)e);
            return param;
        }
    }
}

