/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.http.comm;

import com.aliyun.log.thirdparty.org.apache.http.conn.HttpClientConnectionManager;
import com.aliyun.openservices.log.http.client.ClientConfiguration;
import com.aliyun.openservices.log.http.client.ClientException;
import com.aliyun.openservices.log.http.client.HttpMethod;
import com.aliyun.openservices.log.http.client.ServiceException;
import com.aliyun.openservices.log.http.comm.HttpMessage;
import com.aliyun.openservices.log.http.comm.RequestMessage;
import com.aliyun.openservices.log.http.comm.ResponseMessage;
import com.aliyun.openservices.log.http.comm.RetryStrategy;
import com.aliyun.openservices.log.http.utils.HttpUtil;
import com.aliyun.openservices.log.util.Args;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public abstract class ServiceClient {
    private static final int DEFAULT_MARK_LIMIT = 4096;
    protected ClientConfiguration config;

    protected ServiceClient(ClientConfiguration config) {
        this.config = config;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage sendRequest(RequestMessage request, String charset) throws ServiceException, ClientException {
        Args.notNull(request, "request");
        Args.notNullOrEmpty(charset, "charset");
        try {
            ResponseMessage responseMessage = this.sendRequestImpl(request, charset);
            return responseMessage;
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    private ResponseMessage sendRequestImpl(RequestMessage request, String charset) throws ClientException, ServiceException {
        InputStream requestContent = request.getContent();
        if (requestContent != null && requestContent.markSupported()) {
            requestContent.mark(4096);
        }
        int retries = 0;
        RetryStrategy retryStrategy = this.config.getRetryStrategy() != null ? this.config.getRetryStrategy() : this.getDefaultRetryStrategy();
        while (true) {
            try {
                if (retries > 0) {
                    this.pause(retries, retryStrategy);
                    if (requestContent != null && requestContent.markSupported()) {
                        try {
                            requestContent.reset();
                        }
                        catch (IOException ex) {
                            throw new ClientException("Failed to reset the request input stream: ", ex);
                        }
                    }
                }
                Request httpRequest = this.buildRequest(request, charset);
                ResponseMessage responseMessage = this.sendRequestCore(httpRequest, charset);
                return responseMessage;
            }
            catch (ServiceException sex) {
                if (this.shouldRetry(sex, request, retries, retryStrategy)) continue;
                throw sex;
            }
            catch (ClientException cex) {
                if (this.shouldRetry(cex, request, retries, retryStrategy)) continue;
                throw cex;
            }
            catch (Exception ex) {
                throw new ClientException(ex.getMessage(), ex);
            }
            finally {
                ++retries;
                continue;
            }
            break;
        }
    }

    protected abstract ResponseMessage sendRequestCore(Request var1, String var2) throws Exception;

    private void pause(int retries, RetryStrategy retryStrategy) throws ClientException {
        long delay = retryStrategy.getPauseDelay(retries);
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    private boolean shouldRetry(Exception exception, RequestMessage request, int retries, RetryStrategy retryStrategy) {
        if (retries >= this.config.getMaxErrorRetry()) {
            return false;
        }
        if (!request.isRepeatable()) {
            return false;
        }
        return retryStrategy.shouldRetry(exception, request, retries);
    }

    protected abstract RetryStrategy getDefaultRetryStrategy();

    private Request buildRequest(RequestMessage requestMessage, String charset) throws ClientException {
        boolean putParamsInUri;
        Request request = new Request();
        request.setMethod(requestMessage.getMethod());
        request.setHeaders(requestMessage.getHeaders());
        if (request.getHeaders() != null) {
            HttpUtil.convertHeaderCharsetToIso88591(request.getHeaders());
        }
        String delimiter = "/";
        String uri = requestMessage.getEndpoint().toString();
        if (!(uri.endsWith("/") || requestMessage.getResourcePath() != null && requestMessage.getResourcePath().startsWith("/"))) {
            uri = uri + "/";
        }
        if (requestMessage.getResourcePath() != null) {
            uri = uri + requestMessage.getResourcePath();
        }
        String paramString = HttpUtil.paramToQueryString(requestMessage.getParameters(), charset);
        boolean requestHasNoPayload = requestMessage.getContent() != null;
        boolean requestIsPost = requestMessage.getMethod() == HttpMethod.POST;
        boolean bl = putParamsInUri = !requestIsPost || requestHasNoPayload;
        if (paramString != null && putParamsInUri) {
            uri = uri + "?" + paramString;
        }
        request.setUrl(uri);
        if (requestIsPost && requestMessage.getContent() == null && paramString != null) {
            try {
                byte[] buf = paramString.getBytes(charset);
                ByteArrayInputStream content = new ByteArrayInputStream(buf);
                request.setContent(content);
                request.setContentLength(buf.length);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)("EncodingFailed" + e.getMessage()));
            }
        } else {
            request.setContent(requestMessage.getContent());
            request.setContentLength(requestMessage.getContentLength());
        }
        return request;
    }

    public abstract void shutdown();

    public abstract HttpClientConnectionManager getConnectionManager();

    public static class Request
    extends HttpMessage {
        private String uri;
        private HttpMethod method;

        public String getUri() {
            return this.uri;
        }

        public void setUrl(String uri) {
            this.uri = uri;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }
    }
}

