/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common.auth;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.log.thirdparty.org.apache.http.HttpResponse;
import com.aliyun.log.thirdparty.org.apache.http.util.EntityUtils;
import com.aliyun.openservices.log.common.auth.HttpCredentialsFetcher;
import com.aliyun.openservices.log.common.auth.TemporaryCredentials;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.http.utils.DateUtil;
import java.text.ParseException;

public class ECSRoleCredentialsFetcher
extends HttpCredentialsFetcher {
    private static final String META_DATA_SERVICE_URL = "http://100.100.100.200/latest/meta-data/ram/security-credentials/";
    private final String ecsRamRole;

    public ECSRoleCredentialsFetcher(String ecsRamRole) {
        this.ecsRamRole = ecsRamRole;
    }

    @Override
    public String buildUrl() {
        return META_DATA_SERVICE_URL + this.ecsRamRole;
    }

    private TemporaryCredentials credentialsFromJson(JSONObject response) throws ParseException {
        String accessKeyId = response.getString("AccessKeyId");
        String accessKeySecret = response.getString("AccessKeySecret");
        String securityToken = response.getString("SecurityToken");
        long expiration = DateUtil.stringToLong(response.getString("Expiration"));
        long lastUpdated = DateUtil.stringToLong(response.getString("LastUpdated"));
        return new TemporaryCredentials(accessKeyId, accessKeySecret, securityToken, expiration, lastUpdated);
    }

    @Override
    public TemporaryCredentials parse(HttpResponse httpResponse) throws LogException {
        String rawRespBody;
        try {
            rawRespBody = EntityUtils.toString(httpResponse.getEntity());
        }
        catch (Exception e) {
            throw new LogException("FetchCredentialsFailed", "Fail to fetch credentials: fetch http resp body", e, "");
        }
        try {
            JSONObject response = JSONObject.parseObject((String)rawRespBody);
            if (response == null || !"Success".equalsIgnoreCase(response.getString("Code"))) {
                throw new LogException("FetchCredentialsFailed", "Fetch credential got unexpected response, " + rawRespBody, "");
            }
            return this.credentialsFromJson(response);
        }
        catch (LogException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LogException("FetchCredentialsFailed", "Fetch credential fail to parse response, " + rawRespBody, e, "");
        }
    }
}

