/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class LogGroupMeta
implements Serializable {
    private List<Long> cursorIdList;
    private int rawDataSize = 0;
    private int rawLogGroupCount = 0;
    private byte[] rawBytes = null;
    private int offset;
    private int length;
    private int logGroupCount;
    private String requestId = "";

    public LogGroupMeta(byte[] rawBytes, int offset, int length, int logGroupCount, String requestId) {
        this.requestId = requestId;
        this.rawBytes = rawBytes;
        this.offset = offset;
        this.length = length;
        this.logGroupCount = logGroupCount;
        this.cursorIdList = new ArrayList<Long>();
    }

    public List<Long> getCursorIdList() {
        return this.cursorIdList;
    }

    public int getRawDataSize() {
        return this.rawDataSize;
    }

    public int getRawLogGroupCount() {
        return this.rawLogGroupCount;
    }

    public void parseMeta() throws LogException {
        if (this.length <= 0) {
            return;
        }
        String meta = new String(this.rawBytes, this.offset, this.length);
        try {
            JSONObject object = JSONObject.parseObject((String)meta);
            this.rawDataSize = object.getIntValue("rawDataSize");
            this.rawLogGroupCount = object.getIntValue("rawLogGroupCount");
            JSONArray cursorIdList = object.getJSONArray("cursorIdList");
            if (cursorIdList != null) {
                for (int i = 0; i < cursorIdList.size(); ++i) {
                    this.cursorIdList.add(cursorIdList.getLong(i));
                }
                if (this.cursorIdList.size() != this.logGroupCount) {
                    throw new LogException("InvalidLogGroupMeta", "The cursorIdList count does not match with the LogGroup count", this.requestId);
                }
            }
        }
        catch (JSONException e) {
            throw new LogException("InvalidLogGroupMeta", "Fail to parse LogGroup meta: " + meta, e, this.requestId);
        }
    }
}

