/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.http.protocol;

import com.aliyun.log.thirdparty.org.apache.http.HttpEntity;
import com.aliyun.log.thirdparty.org.apache.http.HttpEntityEnclosingRequest;
import com.aliyun.log.thirdparty.org.apache.http.HttpException;
import com.aliyun.log.thirdparty.org.apache.http.HttpRequest;
import com.aliyun.log.thirdparty.org.apache.http.HttpRequestInterceptor;
import com.aliyun.log.thirdparty.org.apache.http.HttpVersion;
import com.aliyun.log.thirdparty.org.apache.http.ProtocolVersion;
import com.aliyun.log.thirdparty.org.apache.http.annotation.Immutable;
import com.aliyun.log.thirdparty.org.apache.http.protocol.HttpContext;
import com.aliyun.log.thirdparty.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

