/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.wedata.module;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.StatisticOp;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.common.AbstractConverter;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvertFactory;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.workflow.migration.transform.dw.converter.wedata.convert.Wedata2DwConvertFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wedata2DwConverter
extends AbstractConverter {
    private static final Logger log = LoggerFactory.getLogger(Wedata2DwConverter.class);

    public AbstractConvertFactory getConvertFactory() {
        return new Wedata2DwConvertFactory();
    }

    public WorkflowProjectPackage convertUseMx() {
        return null;
    }

    public WorkflowProjectPackage convertSelf() {
        WorkflowProjectPackage workflowProjectPackage = this.getWorkflowPackage();
        if (Objects.isNull(workflowProjectPackage)) {
            log.warn("not found flow package");
            return null;
        }
        this.taskContext.setWorkflowProjectPackage(workflowProjectPackage);
        WorkflowProjectPackage targetWorkflowProjectPackage = new WorkflowProjectPackage();
        this.taskContext.setTargetWorkflowProjectPackage(targetWorkflowProjectPackage);
        WorkflowProject tgtWorkflowProject = (WorkflowProject)this.convertFactory.getProjectConvert(this.taskContext).convert((Object)workflowProjectPackage.getWorkflowProject());
        targetWorkflowProjectPackage.setWorkflowProject(tgtWorkflowProject);
        ArrayList<Workflow> tgtWorkflows = new ArrayList<Workflow>();
        if (Objects.nonNull(workflowProjectPackage.getWorkflowList())) {
            tgtWorkflows = new ArrayList();
        }
        for (int i = 0; i < workflowProjectPackage.getWorkflowList().size(); ++i) {
            Workflow workflow = (Workflow)workflowProjectPackage.getWorkflowList().get(i);
            log.info("[WORKFLOW-CONVERT]({}/{}): {}, {}", new Object[]{i + 1, workflowProjectPackage.getWorkflowList().size(), workflow.getWorkflowName(), workflow.getWorkflowId()});
            Workflow tgtWorkflow = this.convertSingleWorkflow(workflow);
            tgtWorkflows.add(tgtWorkflow);
        }
        targetWorkflowProjectPackage.setWorkflowList(tgtWorkflows);
        this.taskContext.setWorkflowProjectPackage(targetWorkflowProjectPackage);
        this.taskContext.setTargetWorkflowProjectPackage(targetWorkflowProjectPackage);
        return targetWorkflowProjectPackage;
    }

    public Workflow convertSingleWorkflow(Workflow sourceWorkflow) {
        Workflow tgtWorkflow = (Workflow)BwmJsonUtil.deepCopy((Object)sourceWorkflow, Workflow.class);
        ((List)Optional.ofNullable(sourceWorkflow.getWorkflowNodes()).orElse(new ArrayList())).forEach(workflowNode -> {
            log.info("[NODE-CONVERET]: {}, {}, {}", new Object[]{workflowNode.getNodeName(), workflowNode.getNodeId(), workflowNode.getNodeType()});
            List workflowNodes = tgtWorkflow.getWorkflowNodes();
            ArrayList tgtResWorkflowNodes = new ArrayList();
            workflowNodes.stream().filter(x -> !x.getNodeId().equals(workflowNode.getNodeId())).forEach(x -> tgtResWorkflowNodes.add(x));
            tgtWorkflow.setWorkflowNodes(tgtResWorkflowNodes);
            ArrayList orgRelationPackages = new ArrayList();
            if (sourceWorkflow.getNodeRelations() == null) {
                sourceWorkflow.setNodeRelations(new ArrayList());
            }
            sourceWorkflow.getNodeRelations().stream().forEach(x -> orgRelationPackages.add(x));
            List<WorkflowNode> tgtNodes = null;
            tgtNodes = this.convertSingleNode(tgtWorkflow, (WorkflowNode)workflowNode);
            this.compactNodeMap((WorkflowNode)workflowNode, tgtNodes);
            Set nodeNameAndIdSets = ((List)Optional.ofNullable(tgtWorkflow.getWorkflowNodes()).orElse(new ArrayList())).stream().map(x -> x.getNodeName() + x.getNodeId()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toSet());
            ((List)Optional.ofNullable(tgtNodes).orElse(new ArrayList())).forEach(tgtNode -> {
                if (Objects.nonNull(tgtNode.getNodeName()) && !nodeNameAndIdSets.contains(tgtNode.getNodeName() + tgtNode.getNodeId())) {
                    tgtWorkflow.getWorkflowNodes().add(tgtNode);
                }
            });
        });
        return tgtWorkflow;
    }

    public List<WorkflowNode> convertSingleNode(Workflow workflow, WorkflowNode workflowNode) {
        AbstractConvert convert;
        ArrayList<WorkflowNode> needConvertNodes = new ArrayList<WorkflowNode>();
        try {
            needConvertNodes.add(workflowNode);
            convert = this.convertFactory.getNodeListConvert(workflowNode.getNodeType(), this.taskContext, workflow);
        }
        catch (Exception e) {
            log.error("get convert error", (Throwable)e);
            this.taskContext.getStatisticOp().getWorkflowNodeTotalStatisticOp().increment(1);
            this.taskContext.getStatisticOp().getWorkflowNodeFailureStatisticOp().incrementFailedOne(workflowNode.getNodeName(), e.getMessage());
            return null;
        }
        return (List)Wedata2DwConverter.convertAll((AbstractConvert)convert, needConvertNodes, (String)workflowNode.getNodeId(), (String)workflowNode.getNodeName(), (StatisticOp.StatisticIterm)this.taskContext.getStatisticOp().getWorkflowNodeTotalStatisticOp(), (StatisticOp.StatisticIterm)this.taskContext.getStatisticOp().getWorkflowNodeSuccessStatisticOp(), (StatisticOp.StatisticIterm)this.taskContext.getStatisticOp().getWorkflowNodeFailureStatisticOp());
    }

    public WorkflowFileResource convertSingleWorkflowFileResource(WorkflowFileResource sourceWorkflowFileResource) {
        return null;
    }
}

