/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.wedata.convert.node;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiDatasourceMappingConfig;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.WedataDIScriptConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflineSyncNodeConverter
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(OfflineSyncNodeConverter.class);

    public OfflineSyncNodeConverter(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return tgtNodes;
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        if (Objects.isNull(workflowNode.getCustomProperties())) {
            workflowNode.setCustomProperties(new HashMap());
        }
        if (Objects.isNull(tgtworkflowNode.getCustomProperties())) {
            tgtworkflowNode.setCustomProperties(new HashMap());
        }
        tgtworkflowNode.setNodeType(CodeProgramType.DI.name());
        DiDatasourceMappingConfig diDatasourceMappingConfig = this.getDataSourceMapping();
        WedataDIScriptConverter discriptConvert = new WedataDIScriptConverter(diDatasourceMappingConfig, this.taskContext.getWorkflowProjectPackage().getDatasources());
        String script = discriptConvert.convert(workflowNode.getScript());
        tgtworkflowNode.setScript(script);
        tgtworkflowNode.getCustomProperties().put("datasource", discriptConvert.getConnectDatasource());
        tgtworkflowNode.setDbType(discriptConvert.getConnectDatasourceType());
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    private DiDatasourceMappingConfig getDataSourceMapping() {
        DiDatasourceMappingConfig diDatasourceMappingConfig = new DiDatasourceMappingConfig();
        diDatasourceMappingConfig.init(this.bwmConfiguration);
        return diDatasourceMappingConfig;
    }

    private WorkflowDatasource findDatasourceById(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        Optional<WorkflowDatasource> workflowDatasource = this.taskContext.getWorkflowProjectPackage().getDatasources().stream().filter(ds -> ds.getDatasourceId().equals(id)).findFirst();
        if (workflowDatasource.isPresent()) {
            return workflowDatasource.get();
        }
        return null;
    }
}

